/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.BindResultAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedBindRequestAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedForwardAccessLogMessageHelper;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedResultAccessLogMessageHelper;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedBindResultAccessLogMessage
extends TextFormattedBindRequestAccessLogMessage
implements BindResultAccessLogMessage {
    private static final long serialVersionUID = 3250258313916133793L;
    @Nullable
    private final Boolean retiredPasswordUsed;
    @Nullable
    private final Long authenticationFailureID;
    @Nullable
    private final String authenticationDN = this.getString(TextFormattedAccessLogFields.BIND_AUTHENTICATION_DN);
    @Nullable
    private final String authenticationFailureMessage;
    @Nullable
    private final String authenticationFailureName;
    @Nullable
    private final String authorizationDN = this.getString(TextFormattedAccessLogFields.BIND_AUTHORIZATION_DN);
    @Nullable
    private final String clientConnectionPolicy;
    @NotNull
    private final TextFormattedForwardAccessLogMessageHelper forwardHelper;
    @NotNull
    private final TextFormattedResultAccessLogMessageHelper resultHelper;

    public TextFormattedBindResultAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedBindResultAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.retiredPasswordUsed = this.getBooleanNoThrow(TextFormattedAccessLogFields.BIND_RETIRED_PASSWORD_USED);
        this.clientConnectionPolicy = this.getString(TextFormattedAccessLogFields.CLIENT_CONNECTION_POLICY);
        this.authenticationFailureID = this.getLongNoThrow(TextFormattedAccessLogFields.BIND_AUTHENTICATION_FAILURE_ID);
        this.authenticationFailureName = this.getString(TextFormattedAccessLogFields.BIND_AUTHENTICATION_FAILURE_NAME);
        this.authenticationFailureMessage = this.getString(TextFormattedAccessLogFields.BIND_AUTHENTICATION_FAILURE_REASON);
        this.resultHelper = new TextFormattedResultAccessLogMessageHelper(this);
        this.forwardHelper = new TextFormattedForwardAccessLogMessageHelper(this);
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.RESULT;
    }

    @Override
    @Nullable
    public ResultCode getResultCode() {
        return this.resultHelper.getResultCode();
    }

    @Override
    @Nullable
    public String getDiagnosticMessage() {
        return this.resultHelper.getDiagnosticMessage();
    }

    @Override
    @Nullable
    public String getAdditionalInformation() {
        return this.resultHelper.getAdditionalInformation();
    }

    @Override
    @Nullable
    public String getMatchedDN() {
        return this.resultHelper.getMatchedDN();
    }

    @Override
    @NotNull
    public List<String> getReferralURLs() {
        return this.resultHelper.getReferralURLs();
    }

    @Override
    @Nullable
    public Double getProcessingTimeMillis() {
        return this.resultHelper.getProcessingTimeMillis();
    }

    @Override
    @Nullable
    public Double getWorkQueueWaitTimeMillis() {
        return this.resultHelper.getWorkQueueWaitTimeMillis();
    }

    @Override
    @NotNull
    public Set<String> getResponseControlOIDs() {
        return this.resultHelper.getResponseControlOIDs();
    }

    @Override
    @Nullable
    public Long getIntermediateResponsesReturned() {
        return this.resultHelper.getIntermediateResponsesReturned();
    }

    @Override
    @NotNull
    public List<String> getServersAccessed() {
        return this.resultHelper.getServersAccessed();
    }

    @Override
    @Nullable
    public Boolean getUncachedDataAccessed() {
        return this.resultHelper.getUncachedDataAccessed();
    }

    @Override
    @NotNull
    public Set<String> getUsedPrivileges() {
        return this.resultHelper.getUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getPreAuthorizationUsedPrivileges() {
        return this.resultHelper.getPreAuthorizationUsedPrivileges();
    }

    @Override
    @NotNull
    public Set<String> getMissingPrivileges() {
        return this.resultHelper.getMissingPrivileges();
    }

    @Nullable
    public String getIntermediateClientResponseControl() {
        return this.resultHelper.getIntermediateClientResponseControl();
    }

    @Override
    @Nullable
    public String getTargetHost() {
        return this.forwardHelper.getTargetHost();
    }

    @Override
    @Nullable
    public Integer getTargetPort() {
        return this.forwardHelper.getTargetPort();
    }

    @Override
    @Nullable
    public String getTargetProtocol() {
        return this.forwardHelper.getTargetProtocol();
    }

    @Override
    @Nullable
    public String getAuthenticationDN() {
        return this.authenticationDN;
    }

    @Override
    @Nullable
    public String getAuthorizationDN() {
        return this.authorizationDN;
    }

    @Override
    @Nullable
    public Long getAuthenticationFailureID() {
        return this.authenticationFailureID;
    }

    @Override
    @Nullable
    public String getAuthenticationFailureName() {
        return this.authenticationFailureName;
    }

    @Override
    @Nullable
    public String getAuthenticationFailureMessage() {
        return this.authenticationFailureMessage;
    }

    @Override
    @Nullable
    public Boolean getRetiredPasswordUsed() {
        return this.retiredPasswordUsed;
    }

    @Override
    @Nullable
    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicy;
    }
}

