/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import org.rocksdb.AbstractSlice;
import org.rocksdb.AbstractTableFilter;
import org.rocksdb.ReadTier;
import org.rocksdb.RocksObject;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;

public class ReadOptions
extends RocksObject {
    private AbstractSlice<?> iterateLowerBoundSlice_;
    private AbstractSlice<?> iterateUpperBoundSlice_;
    private AbstractSlice<?> timestampSlice_;
    private AbstractSlice<?> iterStartTs_;

    public ReadOptions() {
        super(ReadOptions.newReadOptions());
    }

    public ReadOptions(boolean bl, boolean bl2) {
        super(ReadOptions.newReadOptions(bl, bl2));
    }

    public ReadOptions(ReadOptions readOptions) {
        super(ReadOptions.copyReadOptions(readOptions.nativeHandle_));
        this.iterateLowerBoundSlice_ = readOptions.iterateLowerBoundSlice_;
        this.iterateUpperBoundSlice_ = readOptions.iterateUpperBoundSlice_;
        this.timestampSlice_ = readOptions.timestampSlice_;
        this.iterStartTs_ = readOptions.iterStartTs_;
    }

    public boolean verifyChecksums() {
        assert (this.isOwningHandle());
        return this.verifyChecksums(this.nativeHandle_);
    }

    public ReadOptions setVerifyChecksums(boolean bl) {
        assert (this.isOwningHandle());
        this.setVerifyChecksums(this.nativeHandle_, bl);
        return this;
    }

    public boolean fillCache() {
        assert (this.isOwningHandle());
        return this.fillCache(this.nativeHandle_);
    }

    public ReadOptions setFillCache(boolean bl) {
        assert (this.isOwningHandle());
        this.setFillCache(this.nativeHandle_, bl);
        return this;
    }

    public Snapshot snapshot() {
        assert (this.isOwningHandle());
        long l = this.snapshot(this.nativeHandle_);
        if (l != 0L) {
            return new Snapshot(l);
        }
        return null;
    }

    public ReadOptions setSnapshot(Snapshot snapshot) {
        assert (this.isOwningHandle());
        if (snapshot != null) {
            this.setSnapshot(this.nativeHandle_, snapshot.nativeHandle_);
        } else {
            this.setSnapshot(this.nativeHandle_, 0L);
        }
        return this;
    }

    public ReadTier readTier() {
        assert (this.isOwningHandle());
        return ReadTier.getReadTier(this.readTier(this.nativeHandle_));
    }

    public ReadOptions setReadTier(ReadTier readTier) {
        assert (this.isOwningHandle());
        this.setReadTier(this.nativeHandle_, readTier.getValue());
        return this;
    }

    public boolean tailing() {
        assert (this.isOwningHandle());
        return this.tailing(this.nativeHandle_);
    }

    public ReadOptions setTailing(boolean bl) {
        assert (this.isOwningHandle());
        this.setTailing(this.nativeHandle_, bl);
        return this;
    }

    @Deprecated
    public boolean managed() {
        assert (this.isOwningHandle());
        return this.managed(this.nativeHandle_);
    }

    @Deprecated
    public ReadOptions setManaged(boolean bl) {
        assert (this.isOwningHandle());
        this.setManaged(this.nativeHandle_, bl);
        return this;
    }

    public boolean totalOrderSeek() {
        assert (this.isOwningHandle());
        return this.totalOrderSeek(this.nativeHandle_);
    }

    public ReadOptions setTotalOrderSeek(boolean bl) {
        assert (this.isOwningHandle());
        this.setTotalOrderSeek(this.nativeHandle_, bl);
        return this;
    }

    public boolean prefixSameAsStart() {
        assert (this.isOwningHandle());
        return this.prefixSameAsStart(this.nativeHandle_);
    }

    public ReadOptions setPrefixSameAsStart(boolean bl) {
        assert (this.isOwningHandle());
        this.setPrefixSameAsStart(this.nativeHandle_, bl);
        return this;
    }

    public boolean pinData() {
        assert (this.isOwningHandle());
        return this.pinData(this.nativeHandle_);
    }

    public ReadOptions setPinData(boolean bl) {
        assert (this.isOwningHandle());
        this.setPinData(this.nativeHandle_, bl);
        return this;
    }

    public boolean backgroundPurgeOnIteratorCleanup() {
        assert (this.isOwningHandle());
        return this.backgroundPurgeOnIteratorCleanup(this.nativeHandle_);
    }

    public ReadOptions setBackgroundPurgeOnIteratorCleanup(boolean bl) {
        assert (this.isOwningHandle());
        this.setBackgroundPurgeOnIteratorCleanup(this.nativeHandle_, bl);
        return this;
    }

    public long readaheadSize() {
        assert (this.isOwningHandle());
        return this.readaheadSize(this.nativeHandle_);
    }

    public ReadOptions setReadaheadSize(long l) {
        assert (this.isOwningHandle());
        this.setReadaheadSize(this.nativeHandle_, l);
        return this;
    }

    public long maxSkippableInternalKeys() {
        assert (this.isOwningHandle());
        return this.maxSkippableInternalKeys(this.nativeHandle_);
    }

    public ReadOptions setMaxSkippableInternalKeys(long l) {
        assert (this.isOwningHandle());
        this.setMaxSkippableInternalKeys(this.nativeHandle_, l);
        return this;
    }

    public boolean ignoreRangeDeletions() {
        assert (this.isOwningHandle());
        return this.ignoreRangeDeletions(this.nativeHandle_);
    }

    public ReadOptions setIgnoreRangeDeletions(boolean bl) {
        assert (this.isOwningHandle());
        this.setIgnoreRangeDeletions(this.nativeHandle_, bl);
        return this;
    }

    public ReadOptions setIterateLowerBound(AbstractSlice<?> abstractSlice) {
        assert (this.isOwningHandle());
        this.setIterateLowerBound(this.nativeHandle_, abstractSlice == null ? 0L : abstractSlice.getNativeHandle());
        this.iterateLowerBoundSlice_ = abstractSlice;
        return this;
    }

    public Slice iterateLowerBound() {
        assert (this.isOwningHandle());
        long l = this.iterateLowerBound(this.nativeHandle_);
        if (l != 0L) {
            return new Slice(l, false);
        }
        return null;
    }

    public ReadOptions setIterateUpperBound(AbstractSlice<?> abstractSlice) {
        assert (this.isOwningHandle());
        this.setIterateUpperBound(this.nativeHandle_, abstractSlice == null ? 0L : abstractSlice.getNativeHandle());
        this.iterateUpperBoundSlice_ = abstractSlice;
        return this;
    }

    public Slice iterateUpperBound() {
        assert (this.isOwningHandle());
        long l = this.iterateUpperBound(this.nativeHandle_);
        if (l != 0L) {
            return new Slice(l, false);
        }
        return null;
    }

    public ReadOptions setTableFilter(AbstractTableFilter abstractTableFilter) {
        assert (this.isOwningHandle());
        this.setTableFilter(this.nativeHandle_, abstractTableFilter.nativeHandle_);
        return this;
    }

    public boolean autoPrefixMode() {
        assert (this.isOwningHandle());
        return this.autoPrefixMode(this.nativeHandle_);
    }

    public ReadOptions setAutoPrefixMode(boolean bl) {
        assert (this.isOwningHandle());
        this.setAutoPrefixMode(this.nativeHandle_, bl);
        return this;
    }

    public Slice timestamp() {
        assert (this.isOwningHandle());
        long l = this.timestamp(this.nativeHandle_);
        if (l != 0L) {
            return new Slice(l);
        }
        return null;
    }

    public ReadOptions setTimestamp(AbstractSlice<?> abstractSlice) {
        assert (this.isOwningHandle());
        this.setTimestamp(this.nativeHandle_, abstractSlice == null ? 0L : abstractSlice.getNativeHandle());
        this.timestampSlice_ = abstractSlice;
        return this;
    }

    public Slice iterStartTs() {
        assert (this.isOwningHandle());
        long l = this.iterStartTs(this.nativeHandle_);
        if (l != 0L) {
            return new Slice(l);
        }
        return null;
    }

    public ReadOptions setIterStartTs(AbstractSlice<?> abstractSlice) {
        assert (this.isOwningHandle());
        this.setIterStartTs(this.nativeHandle_, abstractSlice == null ? 0L : abstractSlice.getNativeHandle());
        this.iterStartTs_ = abstractSlice;
        return this;
    }

    public long deadline() {
        assert (this.isOwningHandle());
        return this.deadline(this.nativeHandle_);
    }

    public ReadOptions setDeadline(long l) {
        assert (this.isOwningHandle());
        this.setDeadline(this.nativeHandle_, l);
        return this;
    }

    public long ioTimeout() {
        assert (this.isOwningHandle());
        return this.ioTimeout(this.nativeHandle_);
    }

    public ReadOptions setIoTimeout(long l) {
        assert (this.isOwningHandle());
        this.setIoTimeout(this.nativeHandle_, l);
        return this;
    }

    public long valueSizeSoftLimit() {
        assert (this.isOwningHandle());
        return this.valueSizeSoftLimit(this.nativeHandle_);
    }

    public ReadOptions setValueSizeSoftLimit(long l) {
        assert (this.isOwningHandle());
        this.setValueSizeSoftLimit(this.nativeHandle_, l);
        return this;
    }

    private static native long newReadOptions();

    private static native long newReadOptions(boolean var0, boolean var1);

    private static native long copyReadOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native boolean verifyChecksums(long var1);

    private native void setVerifyChecksums(long var1, boolean var3);

    private native boolean fillCache(long var1);

    private native void setFillCache(long var1, boolean var3);

    private native long snapshot(long var1);

    private native void setSnapshot(long var1, long var3);

    private native byte readTier(long var1);

    private native void setReadTier(long var1, byte var3);

    private native boolean tailing(long var1);

    private native void setTailing(long var1, boolean var3);

    private native boolean managed(long var1);

    private native void setManaged(long var1, boolean var3);

    private native boolean totalOrderSeek(long var1);

    private native void setTotalOrderSeek(long var1, boolean var3);

    private native boolean prefixSameAsStart(long var1);

    private native void setPrefixSameAsStart(long var1, boolean var3);

    private native boolean pinData(long var1);

    private native void setPinData(long var1, boolean var3);

    private native boolean backgroundPurgeOnIteratorCleanup(long var1);

    private native void setBackgroundPurgeOnIteratorCleanup(long var1, boolean var3);

    private native long readaheadSize(long var1);

    private native void setReadaheadSize(long var1, long var3);

    private native long maxSkippableInternalKeys(long var1);

    private native void setMaxSkippableInternalKeys(long var1, long var3);

    private native boolean ignoreRangeDeletions(long var1);

    private native void setIgnoreRangeDeletions(long var1, boolean var3);

    private native void setIterateUpperBound(long var1, long var3);

    private native long iterateUpperBound(long var1);

    private native void setIterateLowerBound(long var1, long var3);

    private native long iterateLowerBound(long var1);

    private native void setTableFilter(long var1, long var3);

    private native boolean autoPrefixMode(long var1);

    private native void setAutoPrefixMode(long var1, boolean var3);

    private native long timestamp(long var1);

    private native void setTimestamp(long var1, long var3);

    private native long iterStartTs(long var1);

    private native void setIterStartTs(long var1, long var3);

    private native long deadline(long var1);

    private native void setDeadline(long var1, long var3);

    private native long ioTimeout(long var1);

    private native void setIoTimeout(long var1, long var3);

    private native long valueSizeSoftLimit(long var1);

    private native void setValueSizeSoftLimit(long var1, long var3);
}

