/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.keymaster.NetworkServiceDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.keymaster.NetworkServiceEntity;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class NetworkServiceLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final NetworkServiceDAO serviceDAO;
    protected final EntityFactory entityFactory;

    public NetworkServiceLogic(NetworkServiceDAO serviceDAO, EntityFactory entityFactory) {
        this.serviceDAO = serviceDAO;
        this.entityFactory = entityFactory;
    }

    protected NetworkService toNetworkService(NetworkService.Type serviceType, NetworkServiceEntity service) {
        NetworkService ns = new NetworkService();
        ns.setType(serviceType);
        ns.setAddress(service.getAddress());
        return ns;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    @Transactional(readOnly=true)
    public List<NetworkService> list(NetworkService.Type serviceType) {
        return this.serviceDAO.findAll(serviceType).stream().map(service -> this.toNetworkService(serviceType, (NetworkServiceEntity)service)).toList();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    @Transactional(readOnly=true)
    public NetworkService get(NetworkService.Type serviceType) {
        List<NetworkService> list = this.list(serviceType);
        if (list.isEmpty()) {
            throw new NotFoundException("No registered services for type " + String.valueOf(serviceType));
        }
        return list.size() == 1 ? list.getFirst() : list.get(SecureRandomUtils.generateRandomInt((int)0, (int)list.size()));
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void register(NetworkService networkService) {
        if (this.serviceDAO.findAll(networkService.getType()).stream().noneMatch(s -> s.getAddress().equals(networkService.getAddress()))) {
            NetworkServiceEntity service = (NetworkServiceEntity)this.entityFactory.newEntity(NetworkServiceEntity.class);
            service.setType(networkService.getType());
            service.setAddress(networkService.getAddress());
            this.serviceDAO.save((Entity)service);
        }
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name")
    public void unregister(NetworkService networkService) {
        this.serviceDAO.deleteAll(networkService);
    }

    protected EntityTO resolveReference(Method method, Object ... args) {
        throw new UnsupportedOperationException();
    }
}

