/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapUtils;

public final class LdapURLActivatorService {
    private static final String ACTIVATOR_PERIOD_PROPERTY = "org.ldaptive.urlActivatorPeriod";
    private static final String STALE_PERIOD_PROPERTY = "org.ldaptive.urlActivatorStalePeriod";
    private static final Duration ACTIVATOR_PERIOD = Duration.ofMinutes(LdapUtils.parseLong(System.getProperty("org.ldaptive.urlActivatorPeriod", "5"), l -> l > 0L, 5L));
    private static final Duration STALE_PERIOD = Duration.ofHours(LdapUtils.parseLong(System.getProperty("org.ldaptive.urlActivatorStalePeriod", "4"), l -> l > 0L, 4L));
    private static final LdapURLActivatorService INSTANCE = new LdapURLActivatorService();
    private final List<LdapURL> inactiveUrls = new ArrayList<LdapURL>();

    private LdapURLActivatorService() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r, "ldaptive-ldap-url-activator");
            t.setDaemon(true);
            return t;
        });
        executor.scheduleAtFixedRate(this::testInactiveUrls, ACTIVATOR_PERIOD.toMillis(), ACTIVATOR_PERIOD.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static LdapURLActivatorService getInstance() {
        return INSTANCE;
    }

    public static Duration getPeriod() {
        return ACTIVATOR_PERIOD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUrl(LdapURL url) {
        List<LdapURL> list = this.inactiveUrls;
        synchronized (list) {
            this.inactiveUrls.add(url);
        }
    }

    public List<LdapURL> getInactiveUrls() {
        return Collections.unmodifiableList(this.inactiveUrls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testInactiveUrls() {
        ArrayList<LdapURL> copy;
        List<LdapURL> list = this.inactiveUrls;
        synchronized (list) {
            copy = new ArrayList<LdapURL>(this.inactiveUrls);
        }
        for (LdapURL url : copy) {
            if (url.isActive() || !url.getRetryMetadata().getConnectionStrategy().getRetryCondition().test(url)) continue;
            if (url.getRetryMetadata().getConnectionStrategy().getActivateCondition().test(url)) {
                url.getRetryMetadata().getConnectionStrategy().success(url);
                continue;
            }
            url.getRetryMetadata().recordFailure(Instant.now());
            this.activateIfStale(url);
        }
        list = this.inactiveUrls;
        synchronized (list) {
            this.inactiveUrls.removeIf(LdapURL::isActive);
        }
    }

    private void activateIfStale(LdapURL url) {
        Instant now = Instant.now();
        if (url.getRetryMetadata().getSuccessTime() == null) {
            if (url.getRetryMetadata().getCreateTime().plus(STALE_PERIOD).isBefore(now)) {
                url.activate();
            }
        } else if (url.getRetryMetadata().getSuccessTime().plus(STALE_PERIOD).isBefore(now)) {
            url.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        List<LdapURL> list = this.inactiveUrls;
        synchronized (list) {
            this.inactiveUrls.clear();
        }
    }
}

