/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.layoutdialect.decorators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nz.net.ultraq.thymeleaf.layoutdialect.models.extensions.IModelExtensions;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.StringUtils;

public class TitlePatternProcessor
extends AbstractAttributeTagProcessor {
    private static final String TOKEN_LAYOUT_TITLE = "$LAYOUT_TITLE";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(\\$(LAYOUT|CONTENT)_TITLE)");
    public static final String PROCESSOR_NAME = "title-pattern";
    public static final int PROCESSOR_PRECEDENCE = 1;
    public static final String CONTENT_TITLE_KEY = "LayoutDialect::ContentTitle";
    public static final String LAYOUT_TITLE_KEY = "LayoutDialect::LayoutTitle";

    public TitlePatternProcessor(TemplateMode templateMode, String string) {
        super(templateMode, string, null, false, PROCESSOR_NAME, true, 1, true);
    }

    protected void doProcess(ITemplateContext iTemplateContext, IProcessableElementTag iProcessableElementTag, AttributeName attributeName, String string, IElementTagStructureHandler iElementTagStructureHandler) {
        if (!"title".equals(iProcessableElementTag.getElementCompleteName())) {
            throw new IllegalArgumentException(attributeName + " processor should only appear in a <title> element");
        }
        String string2 = string;
        IModelFactory iModelFactory = iTemplateContext.getModelFactory();
        IModel iModel = (IModel)iTemplateContext.getVariable(CONTENT_TITLE_KEY);
        IModel iModel2 = (IModel)iTemplateContext.getVariable(LAYOUT_TITLE_KEY);
        IModel iModel3 = iModelFactory.createModel();
        if (IModelExtensions.asBoolean(iModel2) && IModelExtensions.asBoolean(iModel)) {
            String string3;
            Matcher matcher = TOKEN_PATTERN.matcher(string2);
            while (matcher.find()) {
                String string4;
                string3 = string2.substring(matcher.regionStart(), matcher.start());
                if (!StringUtils.isEmpty((String)string3)) {
                    iModel3.add((ITemplateEvent)iModelFactory.createText((CharSequence)string3));
                }
                iModel3.addModel(TOKEN_LAYOUT_TITLE.equals(string4 = matcher.group(1)) ? iModel2 : iModel);
                matcher.region(matcher.regionStart() + string3.length() + string4.length(), string2.length());
            }
            string3 = string2.substring(matcher.regionStart());
            if (!StringUtils.isEmpty((String)string3)) {
                iModel3.add((ITemplateEvent)iModelFactory.createText((CharSequence)string3));
            }
        } else if (IModelExtensions.asBoolean(iModel)) {
            iModel3.addModel(iModel);
        } else if (IModelExtensions.asBoolean(iModel2)) {
            iModel3.addModel(iModel2);
        }
        iElementTagStructureHandler.setBody(iModel3, true);
    }
}

