/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.jpa.dao.repo.ReportExecRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPAReportExec;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.ReflectionUtils;

public class ReportExecRepoExtImpl
implements ReportExecRepoExt {
    protected final EntityManager entityManager;

    public ReportExecRepoExtImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<ReportExec> findRecent(int max) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.end IS NOT NULL ORDER BY e.end DESC", ReportExec.class);
        query.setMaxResults(max);
        return query.getResultList();
    }

    protected ReportExec findLatest(Report report, String field) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAReportExec.class.getSimpleName() + " e WHERE e.report=:report ORDER BY e." + field + " DESC", ReportExec.class);
        query.setParameter("report", (Object)report);
        query.setMaxResults(1);
        List result = query.getResultList();
        return result == null || result.isEmpty() ? null : (ReportExec)result.getFirst();
    }

    @Override
    public ReportExec findLatestStarted(Report report) {
        return this.findLatest(report, "start");
    }

    @Override
    public ReportExec findLatestEnded(Report report) {
        return this.findLatest(report, "end");
    }

    protected StringBuilder query(StringBuilder select, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder query = select.append(JPAReportExec.class.getSimpleName()).append(" e WHERE e.report=:report ");
        if (before != null) {
            query.append("AND e.start <= :before ");
        }
        if (after != null) {
            query.append("AND e.start >= :after ");
        }
        return query;
    }

    @Override
    public long count(Report report, OffsetDateTime before, OffsetDateTime after) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT COUNT(e) FROM "), before, after);
        Query query = this.entityManager.createQuery(queryString.toString());
        query.setParameter("report", (Object)report);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        return ((Number)query.getSingleResult()).longValue();
    }

    protected String toOrderByStatement(Stream<Sort.Order> orderByClauses) {
        StringBuilder statement = new StringBuilder();
        orderByClauses.forEach(clause -> {
            String field = clause.getProperty().trim();
            if (ReflectionUtils.findField(JPAReportExec.class, (String)field) != null) {
                statement.append("e.").append(field).append(' ').append(clause.getDirection().name());
            }
        });
        if (statement.length() == 0) {
            statement.append(" ORDER BY e.id DESC");
        } else {
            statement.insert(0, " ORDER BY ");
        }
        return statement.toString();
    }

    @Override
    public List<ReportExec> findAll(Report report, OffsetDateTime before, OffsetDateTime after, Pageable pageable) {
        StringBuilder queryString = this.query(new StringBuilder("SELECT e FROM "), before, after).append(this.toOrderByStatement(pageable.getSort().stream()));
        TypedQuery query = this.entityManager.createQuery(queryString.toString(), ReportExec.class);
        query.setParameter("report", (Object)report);
        if (before != null) {
            query.setParameter("before", (Object)before);
        }
        if (after != null) {
            query.setParameter("after", (Object)after);
        }
        if (pageable.isPaged()) {
            query.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
            query.setMaxResults(pageable.getPageSize());
        }
        return query.getResultList();
    }

    @Override
    public void deleteById(String key) {
        Optional.ofNullable((JPAReportExec)this.entityManager.find(JPAReportExec.class, (Object)key)).ifPresent(this::delete);
    }

    @Override
    public void delete(ReportExec execution) {
        Optional.ofNullable(execution.getReport()).ifPresent(report -> report.getExecs().remove(execution));
        this.entityManager.remove((Object)execution);
    }
}

