/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.PropertyManager;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.Serializable;
import java.util.logging.Level;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class PropertyManagerCacheRecord
implements Serializable {
    private static final long serialVersionUID = -3306871931780281568L;
    @Nullable
    private final Boolean booleanValue;
    @Nullable
    private final Integer intValue;
    private final long expirationTimeMillis;
    @Nullable
    private final Long longValue;
    @NotNull
    private final String propertyName;
    @Nullable
    private final String stringValue;

    PropertyManagerCacheRecord(@NotNull String propertyName, @Nullable String stringValue, int cacheDurationMillis) {
        this.propertyName = propertyName;
        this.stringValue = stringValue;
        this.expirationTimeMillis = cacheDurationMillis == Integer.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + (long)cacheDurationMillis;
        if (stringValue == null) {
            this.booleanValue = null;
            this.intValue = null;
            this.longValue = null;
        } else {
            Long l;
            Integer i;
            this.booleanValue = PropertyManager.parseBoolean(stringValue);
            try {
                i = Integer.parseInt(stringValue);
                l = i.longValue();
            }
            catch (Exception e) {
                Debug.debugException(Level.FINEST, e);
                i = null;
                try {
                    l = Long.parseLong(stringValue);
                }
                catch (Exception e2) {
                    Debug.debugException(Level.FINEST, e);
                    l = null;
                }
            }
            this.intValue = i;
            this.longValue = l;
        }
    }

    @NotNull
    String getPropertyName() {
        return this.propertyName;
    }

    long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTimeMillis;
    }

    boolean isDefined() {
        return this.stringValue != null;
    }

    @Nullable
    String stringValue() {
        return this.stringValue;
    }

    @Nullable
    String stringValue(@Nullable String defaultValue) {
        if (this.stringValue == null) {
            return defaultValue;
        }
        return this.stringValue;
    }

    @Nullable
    Boolean booleanValue() {
        return this.booleanValue;
    }

    @Nullable
    Boolean booleanValue(@Nullable Boolean defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        if (this.booleanValue == null) {
            if (this.stringValue != null && throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_BOOLEAN.get(PropertyManager.getIdentifierString(this.propertyName), this.stringValue));
            }
            return defaultValue;
        }
        return this.booleanValue;
    }

    @Nullable
    Integer intValue() {
        return this.intValue;
    }

    @Nullable
    Integer intValue(@Nullable Integer defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        if (this.intValue == null) {
            if (this.stringValue != null && throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_INT.get(PropertyManager.getIdentifierString(this.propertyName), this.stringValue));
            }
            return defaultValue;
        }
        return this.intValue;
    }

    @Nullable
    Long longValue() {
        return this.longValue;
    }

    @Nullable
    Long longValue(@Nullable Long defaultValue, boolean throwOnInvalidValue) throws IllegalArgumentException {
        if (this.longValue == null) {
            if (this.stringValue != null && throwOnInvalidValue) {
                throw new IllegalArgumentException(UtilityMessages.ERR_PROPERTY_MANAGER_NOT_LONG.get(PropertyManager.getIdentifierString(this.propertyName), this.stringValue));
            }
            return defaultValue;
        }
        return this.longValue;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(@NotNull StringBuilder buffer) {
        buffer.append("PropertyManagerCacheRecord(propertyName='");
        buffer.append(this.propertyName);
        buffer.append("', isDefined=");
        if (this.stringValue == null) {
            buffer.append("false");
        } else {
            buffer.append("true, stringValue='");
            buffer.append(this.stringValue);
            buffer.append('\'');
        }
        buffer.append(", expirationTime='");
        buffer.append(StaticUtils.encodeGeneralizedTime(this.expirationTimeMillis));
        buffer.append("')");
    }
}

