/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MetavarInference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveEnumArgumentType<T extends Enum<T>>
implements ArgumentType<T>,
MetavarInference {
    private Class<T> type_;

    public CaseInsensitiveEnumArgumentType(Class<T> type) {
        this.type_ = type;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        for (Enum t : (Enum[])this.type_.getEnumConstants()) {
            if (!t.name().toLowerCase().equals(value.toLowerCase())) continue;
            return (T)t;
        }
        String choices = TextHelper.concat(this.type_.getEnumConstants(), 0, ",", "{", "}");
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, "could not convert '%s' (choose from %s)", value, choices), parser, arg);
    }

    @Override
    public String[] inferMetavar() {
        return new String[]{TextHelper.concat(this.type_.getEnumConstants(), 0, ",", "{", "}")};
    }
}

