/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.commons.ConnectorDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceWizardBuilder;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ConnectorDirectoryPanel
extends DirectoryPanel<Serializable, Serializable, ConnectorDataProvider, ConnectorRestClient> {
    private static final long serialVersionUID = 2041468935602350821L;
    @SpringBean
    protected AuditRestClient auditRestClient;
    @SpringBean
    protected ResourceRestClient resourceRestClient;
    protected String keyword;

    protected ConnectorDirectoryPanel(String id, Builder builder) {
        super(id, (DirectoryPanel.Builder)builder);
        if (SyncopeConsoleSession.get().owns("CONNECTOR_CREATE", new String[0])) {
            MetaDataRoleAuthorizationStrategy.authorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        } else {
            MetaDataRoleAuthorizationStrategy.unauthorizeAll((Component)this.addAjaxLink, (Action)RENDER);
        }
        this.setShowResultPanel(false);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (object instanceof ConnectorSearchEvent) {
            ConnectorSearchEvent payload = (ConnectorSearchEvent)object;
            AjaxRequestTarget target = payload.getTarget();
            if (StringUtils.isNotBlank((CharSequence)payload.getKeyword())) {
                this.keyword = payload.getKeyword().toLowerCase();
            }
            this.updateResultTable(target);
        } else {
            super.onEvent(event);
        }
    }

    protected ConnectorDataProvider dataProvider() {
        this.dataProvider = new ConnectorDataProvider((ConnectorRestClient)this.restClient, this.rows, this.pageRef, this.keyword);
        return (ConnectorDataProvider)this.dataProvider;
    }

    public ConnectorDataProvider getDataProvider() {
        return (ConnectorDataProvider)this.dataProvider;
    }

    protected String paginatorRowsKey() {
        return "parameters.paginator.rows";
    }

    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("displayName"), (Object)"displayNameSortParam", "displayName"));
        columns.add((IColumn<Serializable, String>)new PropertyColumn((IModel)new ResourceModel("connectorName"), (Object)"connectorNameSortParam", "connectorName"));
        return columns;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    public ActionsPanel<Serializable> getActions(final IModel<Serializable> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 8345646188740279483L;
            final /* synthetic */ ConnectorDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ResourceTO modelObject = new ResourceTO();
                modelObject.setConnector(((ConnInstanceTO)model.getObject()).getKey());
                modelObject.setConnectorDisplayName(((ConnInstanceTO)model.getObject()).getDisplayName());
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)modelObject);
                this.this$0.modal.setFormModel((Serializable)model2.getObject());
                target.add(new Component[]{this.this$0.modal.setContent(new ResourceWizardBuilder(modelObject, this.this$0.resourceRestClient, (ConnectorRestClient)this.this$0.restClient, this.this$0.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("resource.new"), ((ResourceTO)model2.getObject()).getKey()))));
                this.this$0.modal.show(true);
                target.add(new Component[]{this.this$0.modal});
            }
        }, ActionLink.ActionType.CREATE_RESOURCE, String.format("%s", "RESOURCE_CREATE"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 8200500789152854321L;
            final /* synthetic */ ConnectorDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO connInstance = ((ConnectorRestClient)this.this$0.restClient).read(((ConnInstanceTO)model.getObject()).getKey());
                CompoundPropertyModel model2 = new CompoundPropertyModel((Object)connInstance);
                this.this$0.modal.setFormModel((Serializable)model2);
                target.add(new Component[]{this.this$0.modal.setContent((ModalPanel)new ConnectorWizardBuilder(connInstance, (ConnectorRestClient)this.this$0.restClient, this.this$0.pageRef).build("content", SyncopeConsoleSession.get().owns("CONNECTOR_UPDATE", new String[]{connInstance.getAdminRealm()}) ? AjaxWizard.Mode.EDIT : AjaxWizard.Mode.READONLY))});
                this.this$0.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("connector.edit"), connInstance.getDisplayName()))));
                this.this$0.modal.show(true);
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "CONNECTOR_READ", "CONNECTOR_UPDATE"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = 1085863437941911947L;
            final /* synthetic */ ConnectorDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO modelObject = ((ConnectorRestClient)this.this$0.restClient).read(((ConnInstanceTO)model.getObject()).getKey());
                target.add(new Component[]{this.this$0.altDefaultModal.setContent((ModalPanel)new AuditHistoryModal<ConnInstanceTO>(this, OpEvent.CategoryType.LOGIC, "ConnectorLogic", modelObject, "CONNECTOR_UPDATE", this.this$0.auditRestClient){
                    private static final long serialVersionUID = -3225348282675513648L;
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        super(type, category, (EntityTO)entity, auditRestoreEntitlement, restClient);
                    }

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ConnInstanceTO updated = (ConnInstanceTO)DirectoryPanel.MAPPER.readValue(json, ConnInstanceTO.class);
                            ((ConnectorRestClient)this.this$1.this$0.restClient).update(updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring connector {}", (Object)((ConnInstanceTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)this.this$1.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                this.this$0.altDefaultModal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(this.this$0.getString("connector.menu.history"), ((ConnInstanceTO)model.getObject()).getDisplayName()))));
                this.this$0.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "CONNECTOR_READ", "AUDIT_LIST"));
        panel.add((ActionLink)new ActionLink<Serializable>(this){
            private static final long serialVersionUID = -1544718936080799146L;
            final /* synthetic */ ConnectorDirectoryPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                try {
                    ((ConnectorRestClient)this.this$0.restClient).delete(((ConnInstanceTO)model.getObject()).getKey());
                    target.appendJavaScript((CharSequence)String.format("jsPlumb.remove('%s');", ((ConnInstanceTO)model.getObject()).getKey()));
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.this$0.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting resource {}", (Object)((ConnInstanceTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)this.this$0.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CONNECTOR_DELETE", true);
        return panel;
    }

    public static class ConnectorSearchEvent
    implements Serializable {
        private static final long serialVersionUID = -282052400565266028L;
        private final AjaxRequestTarget target;
        private final String keyword;

        public ConnectorSearchEvent(AjaxRequestTarget target, String keyword) {
            this.target = target;
            this.keyword = keyword;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }

    public static class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, ConnectorRestClient> {
        private static final long serialVersionUID = 6128427903964630093L;

        public Builder(ConnectorRestClient restClient, PageReference pageRef) {
            super((RestClient)restClient, pageRef);
            this.setShowResultPage(false);
        }

        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ConnectorDirectoryPanel(id, this);
        }
    }
}

