/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.DefaultBucketConsumer;
import org.apereo.cas.bucket4j.producer.BucketStore;
import org.apereo.cas.bucket4j.producer.InMemoryBucketStore;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.bucket4j.BaseBucket4jProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicketImpl;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator;
import org.apereo.cas.mfa.simple.ticket.DefaultCasSimpleMultifactorAuthenticationTicketFactory;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.web.CasSimpleMultifactorAuthenticationEndpoint;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendTokenAction;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorUpdateEmailAction;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorVerifyEmailAction;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.serialization.TicketSerializationExecutionPlanConfigurer;
import org.apereo.cas.util.serialization.BaseJacksonSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@Configuration(value="CasSimpleMultifactorAuthenticationConfiguration", proxyBeanMethods=false)
class CasSimpleMultifactorAuthenticationConfiguration {
    private static final BeanCondition CONDITION_BUCKET4J_ENABLED = BeanCondition.on((String)"cas.authn.mfa.simple.bucket4j.enabled").isTrue();

    CasSimpleMultifactorAuthenticationConfiguration() {
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketFactoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationTicketFactoryPlanConfiguration {
        CasSimpleMultifactorAuthenticationTicketFactoryPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer casSimpleMultifactorAuthenticationTicketFactoryConfigurer(@Qualifier(value="casSimpleMultifactorAuthenticationTicketFactory") CasSimpleMultifactorAuthenticationTicketFactory casSimpleMultifactorAuthenticationTicketFactory) {
            return () -> casSimpleMultifactorAuthenticationTicketFactory;
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketSerializationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationTicketSerializationConfiguration {
        CasSimpleMultifactorAuthenticationTicketSerializationConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketSerializationExecutionPlanConfigurer casSimpleMultifactorAuthenticationTicketSerializationExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext) {
            return plan -> {
                plan.registerTicketSerializer((StringSerializer)new CasSimpleMultifactorAuthenticationTicketStringSerializer(applicationContext));
                plan.registerTicketSerializer(CasSimpleMultifactorAuthenticationTicket.class.getName(), (StringSerializer)new CasSimpleMultifactorAuthenticationTicketStringSerializer(applicationContext));
                plan.registerTicketSerializer("CASMFA", (StringSerializer)new CasSimpleMultifactorAuthenticationTicketStringSerializer(applicationContext));
            };
        }

        private static final class CasSimpleMultifactorAuthenticationTicketStringSerializer
        extends BaseJacksonSerializer<CasSimpleMultifactorAuthenticationTicketImpl> {
            private static final long serialVersionUID = -2198623586274810263L;

            CasSimpleMultifactorAuthenticationTicketStringSerializer(ConfigurableApplicationContext applicationContext) {
                super(MINIMAL_PRETTY_PRINTER, applicationContext, CasSimpleMultifactorAuthenticationTicketImpl.class);
            }
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationTicketFactoryConfiguration {
        CasSimpleMultifactorAuthenticationTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasSimpleMultifactorAuthenticationTicketFactory casSimpleMultifactorAuthenticationTicketFactory(@Qualifier(value="casSimpleMultifactorAuthenticationUniqueTicketIdGenerator") UniqueTicketIdGenerator casSimpleMultifactorAuthenticationUniqueTicketIdGenerator, @Qualifier(value="casSimpleMultifactorAuthenticationTicketExpirationPolicy") ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy) {
            return new DefaultCasSimpleMultifactorAuthenticationTicketFactory(casSimpleMultifactorAuthenticationTicketExpirationPolicy, casSimpleMultifactorAuthenticationUniqueTicketIdGenerator);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationTicketConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationTicketConfiguration {
        CasSimpleMultifactorAuthenticationTicketConfiguration() {
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder casSimpleMultifactorAuthenticationTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new CasSimpleMultifactorAuthenticationTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationUniqueTicketIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator casSimpleMultifactorAuthenticationUniqueTicketIdGenerator(CasConfigurationProperties casProperties) {
            return new CasSimpleMultifactorAuthenticationUniqueTicketIdGenerator(casProperties);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationPlanConfiguration {
        CasSimpleMultifactorAuthenticationPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"mfaSimpleCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer mfaSimpleCasWebflowExecutionPlanConfigurer(@Qualifier(value="mfaSimpleMultifactorWebflowConfigurer") CasWebflowConfigurer mfaSimpleMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(mfaSimpleMultifactorWebflowConfigurer);
        }
    }

    @Configuration(value="CasSimpleMultifactorAuthenticationActionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasSimpleMultifactorAuthenticationActionConfiguration {
        CasSimpleMultifactorAuthenticationActionConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnAvailableEndpoint
        public CasSimpleMultifactorAuthenticationEndpoint mfaSimpleMultifactorEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return new CasSimpleMultifactorAuthenticationEndpoint(casProperties, applicationContext);
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorSendTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaSimpleMultifactorSendTokenAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorAuthenticationService") CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService, @Qualifier(value="mfaSimpleMultifactorTokenCommunicationStrategy") CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy, CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="mfaSimpleMultifactorBucketConsumer") BucketConsumer mfaSimpleMultifactorBucketConsumer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new CasSimpleMultifactorSendTokenAction(communicationsManager, casSimpleMultifactorAuthenticationService, simple, mfaSimpleMultifactorTokenCommunicationStrategy, mfaSimpleMultifactorBucketConsumer, tenantExtractor);
            }).withId("mfaSimpleMultifactorSendTokenAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorUpdateEmailAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaSimpleMultifactorUpdateEmailAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorAuthenticationService") CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService, @Qualifier(value="mfaSimpleMultifactorTokenCommunicationStrategy") CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy, CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="mfaSimpleMultifactorBucketConsumer") BucketConsumer mfaSimpleMultifactorBucketConsumer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new CasSimpleMultifactorUpdateEmailAction(communicationsManager, casSimpleMultifactorAuthenticationService, simple, mfaSimpleMultifactorTokenCommunicationStrategy, mfaSimpleMultifactorBucketConsumer, tenantExtractor);
            }).withId("mfaSimpleMultifactorUpdateEmailAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorVerifyEmailAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action mfaSimpleMultifactorVerifyEmailAction(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, ConfigurableApplicationContext applicationContext, @Qualifier(value="casSimpleMultifactorAuthenticationService") CasSimpleMultifactorAuthenticationService casSimpleMultifactorAuthenticationService, @Qualifier(value="mfaSimpleMultifactorTokenCommunicationStrategy") CasSimpleMultifactorTokenCommunicationStrategy mfaSimpleMultifactorTokenCommunicationStrategy, CasConfigurationProperties casProperties, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="mfaSimpleMultifactorBucketConsumer") BucketConsumer mfaSimpleMultifactorBucketConsumer) {
            return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new CasSimpleMultifactorVerifyEmailAction(communicationsManager, casSimpleMultifactorAuthenticationService, casProperties.getAuthn().getMfa().getSimple(), mfaSimpleMultifactorTokenCommunicationStrategy, mfaSimpleMultifactorBucketConsumer, tenantExtractor)).withId("mfaSimpleMultifactorVerifyEmailAction").build().get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorBucketConsumer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BucketConsumer mfaSimpleMultifactorBucketConsumer(ConfigurableApplicationContext applicationContext, @Qualifier(value="mfaSimpleMultifactorBucketStore") BucketStore mfaSimpleMultifactorBucketStore, CasConfigurationProperties casProperties) {
            return (BucketConsumer)BeanSupplier.of(BucketConsumer.class).when(CONDITION_BUCKET4J_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new DefaultBucketConsumer(mfaSimpleMultifactorBucketStore, (BaseBucket4jProperties)simple.getBucket4j());
            }).otherwise(BucketConsumer::permitAll).get();
        }

        @ConditionalOnMissingBean(name={"mfaSimpleMultifactorBucketStore"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BucketStore mfaSimpleMultifactorBucketStore(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BucketStore)BeanSupplier.of(BucketStore.class).when(CONDITION_BUCKET4J_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
                return new InMemoryBucketStore((BaseBucket4jProperties)simple.getBucket4j());
            }).otherwiseProxy().get();
        }
    }
}

