/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.adaptors.duo.DuoSecurityBypassCode;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountGroup;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.DuoSecurityUserDevice;

public class DuoSecurityUserAccount
implements Serializable {
    private static final long serialVersionUID = 403995883439339241L;
    private final String username;
    @JsonIgnore
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();
    private DuoSecurityUserAccountStatus status = DuoSecurityUserAccountStatus.AUTH;
    private String enrollPortalUrl;
    private String message;
    private List<DuoSecurityUserDevice> devices = new ArrayList<DuoSecurityUserDevice>();
    private List<DuoSecurityBypassCode> bypassCodes = new ArrayList<DuoSecurityBypassCode>();
    private List<DuoSecurityUserAccountGroup> groups = new ArrayList<DuoSecurityUserAccountGroup>();
    private String userId;
    private String providerId;

    @CanIgnoreReturnValue
    public DuoSecurityUserAccount addGroup(DuoSecurityUserAccountGroup group) {
        this.groups.add(group);
        return this;
    }

    @CanIgnoreReturnValue
    public DuoSecurityUserAccount addBypassCodes(List<DuoSecurityBypassCode> codes) {
        this.bypassCodes.addAll(codes);
        return this;
    }

    @CanIgnoreReturnValue
    public DuoSecurityUserAccount addDevice(DuoSecurityUserDevice device) {
        this.devices.add(device);
        return this;
    }

    @CanIgnoreReturnValue
    public DuoSecurityUserAccount addAttribute(String key, String value) {
        if (!Strings.CI.equalsAny((CharSequence)"null", new CharSequence[]{value}) && StringUtils.isNotBlank((CharSequence)value)) {
            this.metadata.put(key, value);
        }
        return this;
    }

    public String getUserId() {
        return this.metadata.get("user_id");
    }

    public String getFirstName() {
        return this.metadata.get("firstname");
    }

    public String getLastName() {
        return this.metadata.get("lastname");
    }

    public String getEmail() {
        return this.metadata.get("email");
    }

    public String getRealName() {
        return this.metadata.get("realname");
    }

    public Instant getLastLogin() {
        return Instant.ofEpochMilli(Long.parseLong(this.metadata.getOrDefault("last_login", "0")));
    }

    public Instant getCreated() {
        return Instant.ofEpochMilli(Long.parseLong(this.metadata.getOrDefault("created", "0")));
    }

    public boolean isEnrolled() {
        return BooleanUtils.toBoolean((String)this.metadata.getOrDefault("is_enrolled", "false"));
    }

    public String getPhone() {
        return this.devices.stream().filter(device -> Strings.CI.equals(device.getType(), "phone") || Strings.CI.equals(device.getType(), "mobile")).map(DuoSecurityUserDevice::getNumber).filter(StringUtils::isNotBlank).findFirst().orElse("");
    }

    @Generated
    public String toString() {
        return "DuoSecurityUserAccount(username=" + this.username + ", metadata=" + String.valueOf(this.metadata) + ", status=" + String.valueOf((Object)this.status) + ", enrollPortalUrl=" + this.enrollPortalUrl + ", message=" + this.message + ", devices=" + String.valueOf(this.devices) + ", bypassCodes=" + String.valueOf(this.bypassCodes) + ", groups=" + String.valueOf(this.groups) + ", userId=" + this.userId + ", providerId=" + this.providerId + ")";
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public DuoSecurityUserAccountStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getEnrollPortalUrl() {
        return this.enrollPortalUrl;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<DuoSecurityUserDevice> getDevices() {
        return this.devices;
    }

    @Generated
    public List<DuoSecurityBypassCode> getBypassCodes() {
        return this.bypassCodes;
    }

    @Generated
    public List<DuoSecurityUserAccountGroup> getGroups() {
        return this.groups;
    }

    @Generated
    public String getProviderId() {
        return this.providerId;
    }

    @Generated
    public DuoSecurityUserAccount setStatus(DuoSecurityUserAccountStatus status) {
        this.status = status;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setEnrollPortalUrl(String enrollPortalUrl) {
        this.enrollPortalUrl = enrollPortalUrl;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setMessage(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setDevices(List<DuoSecurityUserDevice> devices) {
        this.devices = devices;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setBypassCodes(List<DuoSecurityBypassCode> bypassCodes) {
        this.bypassCodes = bypassCodes;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setGroups(List<DuoSecurityUserAccountGroup> groups) {
        this.groups = groups;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    @Generated
    public DuoSecurityUserAccount setProviderId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DuoSecurityUserAccount)) {
            return false;
        }
        DuoSecurityUserAccount other = (DuoSecurityUserAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Map<String, String> this$metadata = this.metadata;
        Map<String, String> other$metadata = other.metadata;
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        DuoSecurityUserAccountStatus this$status = this.status;
        DuoSecurityUserAccountStatus other$status = other.status;
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$enrollPortalUrl = this.enrollPortalUrl;
        String other$enrollPortalUrl = other.enrollPortalUrl;
        if (this$enrollPortalUrl == null ? other$enrollPortalUrl != null : !this$enrollPortalUrl.equals(other$enrollPortalUrl)) {
            return false;
        }
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<DuoSecurityUserDevice> this$devices = this.devices;
        List<DuoSecurityUserDevice> other$devices = other.devices;
        if (this$devices == null ? other$devices != null : !((Object)this$devices).equals(other$devices)) {
            return false;
        }
        List<DuoSecurityBypassCode> this$bypassCodes = this.bypassCodes;
        List<DuoSecurityBypassCode> other$bypassCodes = other.bypassCodes;
        if (this$bypassCodes == null ? other$bypassCodes != null : !((Object)this$bypassCodes).equals(other$bypassCodes)) {
            return false;
        }
        List<DuoSecurityUserAccountGroup> this$groups = this.groups;
        List<DuoSecurityUserAccountGroup> other$groups = other.groups;
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        String this$userId = this.userId;
        String other$userId = other.userId;
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$providerId = this.providerId;
        String other$providerId = other.providerId;
        return !(this$providerId == null ? other$providerId != null : !this$providerId.equals(other$providerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DuoSecurityUserAccount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Map<String, String> $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        DuoSecurityUserAccountStatus $status = this.status;
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $enrollPortalUrl = this.enrollPortalUrl;
        result = result * 59 + ($enrollPortalUrl == null ? 43 : $enrollPortalUrl.hashCode());
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<DuoSecurityUserDevice> $devices = this.devices;
        result = result * 59 + ($devices == null ? 43 : ((Object)$devices).hashCode());
        List<DuoSecurityBypassCode> $bypassCodes = this.bypassCodes;
        result = result * 59 + ($bypassCodes == null ? 43 : ((Object)$bypassCodes).hashCode());
        List<DuoSecurityUserAccountGroup> $groups = this.groups;
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        String $userId = this.userId;
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $providerId = this.providerId;
        result = result * 59 + ($providerId == null ? 43 : $providerId.hashCode());
        return result;
    }

    @Generated
    public DuoSecurityUserAccount(String username) {
        this.username = username;
    }

    @Generated
    public DuoSecurityUserAccount(String username, DuoSecurityUserAccountStatus status, String enrollPortalUrl, String message, List<DuoSecurityUserDevice> devices, List<DuoSecurityBypassCode> bypassCodes, List<DuoSecurityUserAccountGroup> groups, String userId, String providerId) {
        this.username = username;
        this.status = status;
        this.enrollPortalUrl = enrollPortalUrl;
        this.message = message;
        this.devices = devices;
        this.bypassCodes = bypassCodes;
        this.groups = groups;
        this.userId = userId;
        this.providerId = providerId;
    }

    @Generated
    public DuoSecurityUserAccount withUsername(String username) {
        return this.username == username ? this : new DuoSecurityUserAccount(username, this.status, this.enrollPortalUrl, this.message, this.devices, this.bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withStatus(DuoSecurityUserAccountStatus status) {
        return this.status == status ? this : new DuoSecurityUserAccount(this.username, status, this.enrollPortalUrl, this.message, this.devices, this.bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withEnrollPortalUrl(String enrollPortalUrl) {
        return this.enrollPortalUrl == enrollPortalUrl ? this : new DuoSecurityUserAccount(this.username, this.status, enrollPortalUrl, this.message, this.devices, this.bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withMessage(String message) {
        return this.message == message ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, message, this.devices, this.bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withDevices(List<DuoSecurityUserDevice> devices) {
        return this.devices == devices ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, this.message, devices, this.bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withBypassCodes(List<DuoSecurityBypassCode> bypassCodes) {
        return this.bypassCodes == bypassCodes ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, this.message, this.devices, bypassCodes, this.groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withGroups(List<DuoSecurityUserAccountGroup> groups) {
        return this.groups == groups ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, this.message, this.devices, this.bypassCodes, groups, this.userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withUserId(String userId) {
        return this.userId == userId ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, this.message, this.devices, this.bypassCodes, this.groups, userId, this.providerId);
    }

    @Generated
    public DuoSecurityUserAccount withProviderId(String providerId) {
        return this.providerId == providerId ? this : new DuoSecurityUserAccount(this.username, this.status, this.enrollPortalUrl, this.message, this.devices, this.bypassCodes, this.groups, this.userId, providerId);
    }

    @Generated
    public DuoSecurityUserAccount() {
        this.username = null;
    }
}

