/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.Client;
import com.duosecurity.client.Util;
import java.lang.reflect.Field;
import java.util.Objects;
import lombok.Generated;
import okhttp3.CertificatePinner;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.springframework.util.ReflectionUtils;

public class DuoSecurityClient {
    private final Client instance;
    private final DuoSecurityMultifactorAuthenticationProperties properties;

    public DuoSecurityClient(String loginUrl, DuoSecurityMultifactorAuthenticationProperties properties) {
        this.properties = properties;
        this.instance = this.buildClient(loginUrl);
    }

    public String getDuoApiHost() {
        return this.properties.getDuoApiHost();
    }

    public String getDuoIntegrationKey() {
        return this.properties.getDuoIntegrationKey();
    }

    public String getDuoSecretKey() {
        return this.properties.getDuoSecretKey();
    }

    private Client buildClient(String loginUrl) {
        return (Client)FunctionUtils.doUnchecked(() -> {
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            Client.Builder clientBuilder = new Client.Builder(resolver.resolve(this.getDuoIntegrationKey()), resolver.resolve(this.getDuoSecretKey()), resolver.resolve(this.getDuoApiHost()), loginUrl);
            return clientBuilder.build();
        });
    }

    public CertificatePinner createCertificatePinner(String host, Object target) {
        String[] newCerts = DuoSecurityClient.fetchCaCerts(target);
        return Util.createPinner((String)host, (String[])newCerts);
    }

    private static String[] fetchCaCerts(Object target) {
        Field field = ReflectionUtils.findField(Client.Builder.class, (String)"DEFAULT_CA_CERTS");
        Objects.requireNonNull(field, "Unable to extract default CA certs for Duo Security").trySetAccessible();
        return (String[])ReflectionUtils.getField((Field)field, (Object)target);
    }

    @Generated
    public Client getInstance() {
        return this.instance;
    }
}

