/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app.verifier;

import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyMismatchDetectedException;
import com.giffing.wicket.spring.boot.starter.app.verifier.WicketDependencyVersionCheckerProperties;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

@Configuration
@ConditionalOnProperty(prefix="wicket.verifier.dependencies", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={WicketDependencyVersionCheckerProperties.class})
public class WicketDependencyVersionChecker
implements ResourceLoaderAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WicketDependencyVersionChecker.class);
    private static final String DEFAULT_RESOURCE_PATTERN = "/META-INF/maven/**/pom.properties";
    private static final String WICKETSTUFF_GROUPID = "org.wicketstuff";
    private static final String WICKET_JQUERYUI_GROUPID = "com.googlecode.wicket-jquery-ui";
    private static final String WICKET_CORE_GROUPID = "org.apache.wicket";
    private ResourcePatternResolver resourcePatternResolver;
    private final WicketDependencyVersionCheckerProperties props;

    @Autowired
    public WicketDependencyVersionChecker(WicketDependencyVersionCheckerProperties props) {
        this.props = props;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    @PostConstruct
    public void detectWicketDependencyVersionMismatch() {
        List<MavenDependency> wicketMavenDependencies = this.collectWicketMavenDependencies();
        ArrayList<MavenDependency> mismatchVersionDependencies = new ArrayList<MavenDependency>();
        AtomicBoolean versionMismatchFound = new AtomicBoolean(false);
        Optional<String> wicketCoreVersionOpt = this.findWicketCoreVersion(wicketMavenDependencies);
        wicketCoreVersionOpt.ifPresent(wicketCoreVersion -> {
            for (MavenDependency mavenDependency : wicketMavenDependencies) {
                String majorMavenDependencyVersion;
                String majorWicketCoreVersion;
                if (mavenDependency.groupId.equals(WICKET_CORE_GROUPID) && !mavenDependency.version.equals(wicketCoreVersion)) {
                    log.error("########## INVALID WICKET VERSION DETECTED - CORE: {} - DEPENDENCY: {}", wicketCoreVersion, (Object)mavenDependency);
                    versionMismatchFound.set(true);
                    mismatchVersionDependencies.add(mavenDependency);
                    continue;
                }
                if (!mavenDependency.groupId.equals(WICKETSTUFF_GROUPID) && !mavenDependency.groupId.equals(WICKET_JQUERYUI_GROUPID) || (majorWicketCoreVersion = wicketCoreVersion.substring(0, wicketCoreVersion.indexOf(46))).equals(majorMavenDependencyVersion = mavenDependency.version.substring(0, mavenDependency.version.indexOf(46)))) continue;
                log.error("########## INVALID {} MAJOR VERSION DETECTED - WICKET: {} - DEPENDENCY: {}", new Object[]{mavenDependency.groupId, majorWicketCoreVersion, majorMavenDependencyVersion});
                versionMismatchFound.set(true);
                mismatchVersionDependencies.add(mavenDependency);
            }
        });
        if (versionMismatchFound.get() && this.props.isThrowExceptionOnDependencyVersionMismatch()) {
            throw new WicketDependencyMismatchDetectedException(wicketCoreVersionOpt.orElse("unknown"), mismatchVersionDependencies);
        }
    }

    private Optional<String> findWicketCoreVersion(List<MavenDependency> wicketMavenDependencies) {
        for (MavenDependency wicketMavenDependency : wicketMavenDependencies) {
            if (!wicketMavenDependency.groupId.equals(WICKET_CORE_GROUPID) || !wicketMavenDependency.artifactId.equals("wicket-core")) continue;
            return Optional.of(wicketMavenDependency.version);
        }
        return Optional.empty();
    }

    private List<MavenDependency> collectWicketMavenDependencies() {
        String packageSearchPath = "classpath*:/META-INF/maven/**/pom.properties";
        try {
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            return this.collectWicketMavenDependencies(resources);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private List<MavenDependency> collectWicketMavenDependencies(Resource[] resources) throws IOException {
        ArrayList<MavenDependency> wicketMavenDependencies = new ArrayList<MavenDependency>();
        for (Resource resource : resources) {
            if (!resource.isReadable() || !resource.getURL().getPath().contains("wicket")) continue;
            Properties props = new Properties();
            props.load(resource.getInputStream());
            String groupId = (String)props.get("groupId");
            String artifactId = (String)props.get("artifactId");
            String version = (String)props.get("version");
            wicketMavenDependencies.add(new MavenDependency(groupId, artifactId, version));
        }
        return wicketMavenDependencies;
    }

    public static class MavenDependency {
        public final String groupId;
        public final String artifactId;
        public final String version;

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        @Generated
        public MavenDependency(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }
    }
}

