/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

@Endpoint(id="job")
public class JobEndpoint {
    protected final SyncopeTaskScheduler syncopeTaskScheduler;

    public JobEndpoint(SyncopeTaskScheduler syncopeTaskScheduler) {
        this.syncopeTaskScheduler = syncopeTaskScheduler;
    }

    @ReadOperation
    public Map<String, Object> status() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        this.syncopeTaskScheduler.getJobs().forEach((k, v) -> {
            Map jobs = (Map)status.computeIfAbsent(k.domain(), d -> new HashMap());
            HashMap<String, Object> job = new HashMap<String, Object>();
            jobs.put(k.job(), job);
            job.put("executor", v.job().getContext().getExecutor());
            job.put("dryRun", v.job().getContext().isDryRun());
            job.put("context", v.job().getContext().getData());
            v.instant().ifPresent(f -> job.put("delay (seconds)", f.getDelay(TimeUnit.SECONDS)));
            v.cron().ifPresent(f -> {
                job.put("next schedule (seconds)", f.getDelay(TimeUnit.SECONDS));
                job.put("done", f.isDone());
                job.put("cancelled", f.isCancelled());
            });
        });
        return status;
    }

    @WriteOperation
    public void action(@Selector String domain, @Selector String jobName, @Selector JobAction action) {
        switch (action) {
            case START: {
                this.syncopeTaskScheduler.start(domain, jobName);
                break;
            }
            case STOP: {
                this.syncopeTaskScheduler.stop(domain, jobName);
                break;
            }
            case DELETE: {
                this.syncopeTaskScheduler.delete(domain, jobName);
                break;
            }
        }
    }
}

