/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.session;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.zip.Inflater;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.session.HashMapBackedSessionMappingStorage;
import org.apereo.cas.client.session.SessionMappingStorage;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.WebUtils;
import org.apereo.cas.client.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleSignOutHandler {
    private static final int DECOMPRESSION_FACTOR = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LogoutStrategy logoutStrategy = SingleSignOutHandler.isServlet30() ? new Servlet30LogoutStrategy() : new Servlet25LogoutStrategy();
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = Protocol.CAS2.getArtifactParameterName();
    private String logoutParameterName = ConfigurationKeys.LOGOUT_PARAMETER_NAME.getDefaultValue();
    private String relayStateParameterName = ConfigurationKeys.RELAY_STATE_PARAMETER_NAME.getDefaultValue();
    private String logoutCallbackPath;
    private boolean artifactParameterOverPost = false;
    private boolean eagerlyCreateSessions = true;
    private List<String> safeParameters;

    private static boolean isServlet30() {
        try {
            return HttpServletRequest.class.getMethod("logout", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setArtifactParameterOverPost(boolean artifactParameterOverPost) {
        this.artifactParameterOverPost = artifactParameterOverPost;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void setLogoutCallbackPath(String logoutCallbackPath) {
        this.logoutCallbackPath = logoutCallbackPath;
    }

    public void setRelayStateParameterName(String name) {
        this.relayStateParameterName = name;
    }

    public void setEagerlyCreateSessions(boolean eagerlyCreateSessions) {
        this.eagerlyCreateSessions = eagerlyCreateSessions;
    }

    public synchronized void init() {
        if (this.safeParameters == null) {
            CommonUtils.assertNotNull(this.artifactParameterName, "artifactParameterName cannot be null.");
            CommonUtils.assertNotNull(this.logoutParameterName, "logoutParameterName cannot be null.");
            CommonUtils.assertNotNull(this.sessionMappingStorage, "sessionMappingStorage cannot be null.");
            CommonUtils.assertNotNull(this.relayStateParameterName, "relayStateParameterName cannot be null.");
            this.safeParameters = this.artifactParameterOverPost ? Arrays.asList(this.logoutParameterName, this.artifactParameterName) : Collections.singletonList(this.logoutParameterName);
        }
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response) {
        if (this.isTokenRequest(request)) {
            this.logger.trace("Received a token request");
            this.recordSession(request);
            return true;
        }
        if (this.isLogoutRequest(request)) {
            this.logger.trace("Received a logout request");
            this.destroySession(request);
            return false;
        }
        this.logger.trace("Ignoring URI for logout: {}", (Object)request.getRequestURI());
        return true;
    }

    private boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank(WebUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters));
    }

    private boolean isLogoutRequest(HttpServletRequest request) {
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            return !SingleSignOutHandler.isMultipartRequest((ServletRequest)request) && this.pathEligibleForLogout(request) && CommonUtils.isNotBlank(WebUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            return CommonUtils.isNotBlank(WebUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
        }
        return false;
    }

    private boolean pathEligibleForLogout(HttpServletRequest request) {
        return this.logoutCallbackPath == null || this.logoutCallbackPath.equals(SingleSignOutHandler.getPath(request));
    }

    private static String getPath(HttpServletRequest request) {
        return request.getServletPath() + CommonUtils.nullToEmpty(request.getPathInfo());
    }

    private void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(this.eagerlyCreateSessions);
        if (session == null) {
            this.logger.debug("No session currently exists (and none created).  Cannot record session information for single sign out.");
            return;
        }
        String token = WebUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters);
        this.logger.debug("Recording session for token {}", (Object)token);
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(token, session);
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = Base64.getDecoder().decode(originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            this.logger.error("Unable to decompress logout message", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private void destroySession(HttpServletRequest request) {
        HttpSession session;
        String logoutMessage = WebUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters);
        if (CommonUtils.isBlank(logoutMessage)) {
            this.logger.error("Could not locate logout message of the request from {}", (Object)this.logoutParameterName);
            return;
        }
        if (!logoutMessage.contains("SessionIndex")) {
            logoutMessage = this.uncompressLogoutMessage(logoutMessage);
        }
        this.logger.trace("Logout request:\n{}", (Object)logoutMessage);
        String token = XmlUtils.getTextForElement(logoutMessage, "SessionIndex");
        if (CommonUtils.isNotBlank(token) && (session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
            String sessionID = session.getId();
            this.logger.debug("Invalidating session [{}] for token [{}]", (Object)sessionID, (Object)token);
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Error invalidating session.", (Throwable)e);
            }
            this.logoutStrategy.logout(request);
        }
    }

    private static boolean isMultipartRequest(ServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }

    private class Servlet30LogoutStrategy
    implements LogoutStrategy {
        private Servlet30LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
            try {
                request.logout();
            }
            catch (ServletException e) {
                SingleSignOutHandler.this.logger.debug("Error performing request.logout.");
            }
        }
    }

    private static class Servlet25LogoutStrategy
    implements LogoutStrategy {
        private Servlet25LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
        }
    }

    @FunctionalInterface
    private static interface LogoutStrategy {
        public void logout(HttpServletRequest var1);
    }
}

