/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.util;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.util.AbstractConfigurationFilter;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.WebUtils;

public abstract class AbstractCasFilter
extends AbstractConfigurationFilter {
    public static final String CONST_CAS_ASSERTION = "_const_cas_assertion_";
    private final Protocol protocol;
    private boolean encodeServiceUrl = true;
    private String serverName;
    private String service;

    protected AbstractCasFilter(Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public final void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        if (!this.isIgnoreInitConfiguration()) {
            this.setServerName(this.getString(ConfigurationKeys.SERVER_NAME));
            this.setService(this.getString(ConfigurationKeys.SERVICE));
            this.setEncodeServiceUrl(this.getBoolean(ConfigurationKeys.ENCODE_SERVICE_URL));
            this.initInternal(filterConfig);
        }
        this.init();
    }

    public void init() {
        CommonUtils.assertTrue(CommonUtils.isNotEmpty(this.serverName) || CommonUtils.isNotEmpty(this.service), "serverName or service must be set.");
        CommonUtils.assertTrue(CommonUtils.isBlank(this.serverName) || CommonUtils.isBlank(this.service), "serverName and service cannot both be set.  You MUST ONLY set one.");
    }

    public void destroy() {
    }

    public final void setServerName(String serverName) {
        if (serverName != null && serverName.endsWith("/")) {
            this.serverName = serverName.substring(0, serverName.length() - 1);
            this.logger.info("Eliminated extra slash from serverName [{}].  It is now [{}]", (Object)serverName, (Object)this.serverName);
        } else {
            this.serverName = serverName;
        }
    }

    public final void setService(String service) {
        this.service = service;
    }

    public final void setEncodeServiceUrl(boolean encodeServiceUrl) {
        this.encodeServiceUrl = encodeServiceUrl;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
    }

    protected final String constructServiceUrl(HttpServletRequest request, HttpServletResponse response) {
        return WebUtils.constructServiceUrl(request, response, this.service, this.serverName, this.protocol.getServiceParameterName(), this.protocol.getArtifactParameterName(), this.encodeServiceUrl);
    }

    protected Protocol getProtocol() {
        return this.protocol;
    }

    protected String retrieveTicketFromRequest(HttpServletRequest request) {
        return WebUtils.safeGetParameter(request, this.protocol.getArtifactParameterName(), Collections.singletonList(this.protocol.getArtifactParameterName()));
    }
}

