/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation.jwt;

import jakarta.servlet.FilterConfig;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKey;
import org.apereo.cas.client.validation.AbstractTicketValidationFilter;
import org.apereo.cas.client.validation.TicketValidator;
import org.apereo.cas.client.validation.jwt.CasJWTTicketValidator;

public class CasJWTTicketValidationFilter
extends AbstractTicketValidationFilter {
    protected CasJWTTicketValidationFilter() {
        super(Protocol.CAS3);
    }

    @Override
    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        CasJWTTicketValidator validator = new CasJWTTicketValidator();
        validator.setEncryptionKey(this.getString(new ConfigurationKey<String>("encryptionKey")));
        validator.setSigningKey(this.getString(new ConfigurationKey<String>("signingKey")));
        validator.setExpectedIssuer(this.getString(new ConfigurationKey<String>("expectedIssuer")));
        validator.setExpectedAudience(this.getString(new ConfigurationKey<String>("expectedAudience")));
        validator.setEncryptionKeyAlgorithm(this.getString(new ConfigurationKey<String>("encryptionKeyAlgorithm", "AES")));
        validator.setSigningKeyAlgorithm(this.getString(new ConfigurationKey<String>("signingKeyAlgorithm", "AES")));
        validator.setRequiredClaims(this.getString(new ConfigurationKey<String>("requiredClaims", "sub,aud,iat,jti,exp,iss")));
        validator.setBase64EncryptionKey(this.getBoolean(new ConfigurationKey<Boolean>("base64EncryptionKey", true)));
        validator.setBase64SigningKey(this.getBoolean(new ConfigurationKey<Boolean>("base64SigningKey", true)));
        validator.setMaxClockSkew(this.getInt(new ConfigurationKey<Integer>("maxClockSkew", 60)));
        validator.initialize();
        return validator;
    }
}

