/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.authn;

import com.duosecurity.client.Http;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccountStatus;
import org.apereo.cas.adaptors.duo.authn.DefaultDuoSecurityAdminApiService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAdminApiService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationResult;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAuthenticationService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityDirectCredential;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityException;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityPasscodeCredential;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.duo.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.HttpClientFactory;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.ReflectionUtils;

public abstract class BaseDuoSecurityAuthenticationService
implements DuoSecurityAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDuoSecurityAuthenticationService.class);
    private static final int AUTH_API_VERSION = 2;
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final int DEFAULT_HTTP_TIMEOUT_SECONDS = 60;
    protected final DuoSecurityMultifactorAuthenticationProperties properties;
    protected final HttpClient httpClient;
    protected final TenantExtractor tenantExtractor;
    private final List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver;
    private final Cache<String, DuoSecurityUserAccount> userAccountCache;

    public DuoSecurityAuthenticationResult authenticate(Credential credential) throws Exception {
        if (credential instanceof DuoSecurityPasscodeCredential) {
            DuoSecurityPasscodeCredential duo = (DuoSecurityPasscodeCredential)credential;
            return this.authenticateDuoPasscodeCredential(duo);
        }
        if (credential instanceof DuoSecurityDirectCredential) {
            DuoSecurityDirectCredential duo = (DuoSecurityDirectCredential)credential;
            return this.authenticateDuoCredentialDirect(duo);
        }
        return this.authenticateInternal(credential);
    }

    public DuoSecurityUserAccount getUserAccount(String username) {
        ConcurrentMap userAccountCachedMap = this.userAccountCache.asMap();
        if (userAccountCachedMap.containsKey(username)) {
            DuoSecurityUserAccount account = (DuoSecurityUserAccount)userAccountCachedMap.get(username);
            LOGGER.debug("Found cached duo user account [{}]", (Object)account);
            return account;
        }
        DuoSecurityUserAccount account = new DuoSecurityUserAccount(username);
        account.setStatus(DuoSecurityUserAccountStatus.AUTH);
        try {
            Http userRequest = this.buildHttpPostUserPreAuthRequest(username);
            this.signHttpUserPreAuthRequest(userRequest);
            LOGGER.debug("Contacting Duo Security to inquire about username [{}]", (Object)username);
            String userResponse = this.getHttpResponse(userRequest);
            String jsonResponse = URLDecoder.decode(userResponse, StandardCharsets.UTF_8);
            LOGGER.debug("Received Duo response [{}]", (Object)jsonResponse);
            JsonNode result = MAPPER.readTree(jsonResponse);
            if (!result.has("stat")) {
                LOGGER.warn("Duo response was received in unknown format: [{}]", (Object)jsonResponse);
                throw new DuoSecurityException("Invalid response format received from Duo");
            }
            if ("OK".equalsIgnoreCase(result.get("stat").asText())) {
                JsonNode response = result.get("response");
                String authResult = response.get("result").asText().toUpperCase(Locale.ENGLISH);
                DuoSecurityUserAccountStatus status = DuoSecurityUserAccountStatus.valueOf((String)authResult);
                account.setProviderId(this.properties.getId());
                account.setStatus(status);
                account.setMessage(response.get("status_msg").asText());
                if (status == DuoSecurityUserAccountStatus.ENROLL) {
                    String enrollUrl = response.get("enroll_portal_url").asText();
                    account.setEnrollPortalUrl(enrollUrl);
                }
            } else {
                int code = result.get("code").asInt();
                if (code > 49999) {
                    LOGGER.warn("Duo returned a failure response with code: [{}]. Duo will be considered unavailable", (Object)result.get("message"));
                    throw new DuoSecurityException("Duo returned code %s: %s".formatted(code, result.get("message")));
                }
                LOGGER.warn("Duo returned an Invalid response with message [{}] and detail [{}] when determining user account. This maybe a configuration error in the admin request and Duo will still be considered available.", (Object)(result.hasNonNull("message") ? result.get("message").asText() : ""), (Object)(result.hasNonNull("message_detail") ? result.get("message_detail").asText() : ""));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Reaching Duo has failed with error: [{}]", (Object)e.getMessage(), (Object)e);
            account.setStatus(DuoSecurityUserAccountStatus.UNAVAILABLE);
        }
        userAccountCachedMap.put(account.getUsername(), account);
        LOGGER.debug("Fetched and cached duo user account [{}]", (Object)account);
        return account;
    }

    public Optional<DuoSecurityAdminApiService> getAdminApiService() {
        if (StringUtils.isNotBlank((CharSequence)this.properties.getDuoAdminIntegrationKey()) && StringUtils.isNotBlank((CharSequence)this.properties.getDuoAdminSecretKey())) {
            return Optional.of(new DefaultDuoSecurityAdminApiService(this.httpClient, this.properties));
        }
        return Optional.empty();
    }

    protected abstract DuoSecurityAuthenticationResult authenticateInternal(Credential var1) throws Exception;

    protected String getHttpResponse(Http userRequest) throws Exception {
        try (Response request = userRequest.executeHttpRequest();){
            String string = Objects.requireNonNull(request.body()).string();
            return string;
        }
    }

    protected Http buildHttpPostAuthRequest() throws Exception {
        Http request = this.buildHttpRequest("/auth/v%s/auth");
        this.configureHttpRequest(request);
        return request;
    }

    protected Http buildHttpPostUserPreAuthRequest(String username) throws Exception {
        Http request = this.buildHttpRequest("/auth/v%s/preauth");
        request.addParam("username", username);
        this.configureHttpRequest(request);
        return request;
    }

    private Http buildHttpRequest(String format) throws Exception {
        String originalHost = SpringExpressionLanguageValueResolver.getInstance().resolve(this.getDuoClient().getDuoApiHost());
        URI host = new URI(Strings.CI.prependIfMissing(originalHost, (CharSequence)"https://", new CharSequence[0]));
        Http request = new CasHttpBuilder(HttpMethod.POST.name(), host.getHost(), String.format(format, 2)).build();
        Field hostField = ReflectionUtils.findField(request.getClass(), (String)"host");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(hostField));
        String resultingHost = host.getHost() + (String)(host.getPort() > 0 ? ":" + host.getPort() : "");
        ReflectionUtils.setField((Field)hostField, (Object)request, (Object)resultingHost);
        HttpClientFactory factory = this.httpClient.httpClientFactory();
        OkHttpClient.Builder clientInstanceBuilder = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).hostnameVerifier(factory.getHostnameVerifier());
        if ("localhost".equalsIgnoreCase(host.getHost())) {
            clientInstanceBuilder.certificatePinner(CertificatePinner.DEFAULT).sslSocketFactory(factory.getSslContext().getSocketFactory(), (X509TrustManager)factory.getTrustManagers()[0]);
        } else {
            CertificatePinner pinner = this.getDuoClient().createCertificatePinner(host.getHost(), (Object)request);
            clientInstanceBuilder.certificatePinner(pinner);
        }
        Field httpClientField = ReflectionUtils.findField(Http.class, (String)"httpClient");
        ReflectionUtils.makeAccessible((Field)Objects.requireNonNull(httpClientField));
        OkHttpClient clientInstance = clientInstanceBuilder.build();
        ReflectionUtils.setField((Field)httpClientField, (Object)request, (Object)clientInstance);
        return request;
    }

    protected void configureHttpRequest(Http request) {
        HttpClientFactory factory = this.httpClient.httpClientFactory();
        if (factory.getProxy() != null) {
            request.setProxy(factory.getProxy().getHostName(), factory.getProxy().getPort());
        }
    }

    protected DuoSecurityAuthenticationResult authenticateDuoCredentialDirect(DuoSecurityDirectCredential credential) {
        try {
            Principal principal = this.resolvePrincipal(credential.getPrincipal());
            Http request = this.buildHttpPostAuthRequest();
            this.signHttpAuthRequest(request, principal.getId());
            JSONObject result = this.executeDuoApiRequest(request);
            LOGGER.debug("Duo Security authentication response: [{}]", (Object)result);
            if ("allow".equalsIgnoreCase(result.getString("result"))) {
                return DuoSecurityAuthenticationResult.builder().success(true).username(credential.getId()).build();
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return DuoSecurityAuthenticationResult.builder().success(false).username(credential.getId()).build();
    }

    protected JSONObject executeDuoApiRequest(Http request) throws Exception {
        return (JSONObject)request.executeRequest();
    }

    protected Http signHttpAuthRequest(Http request, String id) {
        return this.signHttpAuthRequest(request, Map.of("username", id, "factor", "auto", "device", "auto"));
    }

    private Http signHttpAuthRequest(Http request, Map<String, String> parameters) {
        parameters.forEach((arg_0, arg_1) -> ((Http)request).addParam(arg_0, arg_1));
        return this.signHttpUserPreAuthRequest(request);
    }

    protected Http signHttpUserPreAuthRequest(Http request) {
        return (Http)FunctionUtils.doUnchecked(() -> {
            SpringExpressionLanguageValueResolver resolver = SpringExpressionLanguageValueResolver.getInstance();
            request.signRequest(resolver.resolve(this.getDuoClient().getDuoIntegrationKey()), resolver.resolve(this.getDuoClient().getDuoSecretKey()));
            return request;
        });
    }

    protected Principal resolvePrincipal(Principal principal) {
        return this.multifactorAuthenticationPrincipalResolver.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }

    private DuoSecurityAuthenticationResult authenticateDuoPasscodeCredential(DuoSecurityPasscodeCredential credential) {
        try {
            Http request = this.buildHttpPostAuthRequest();
            this.signHttpAuthRequest(request, Map.of("username", credential.getId().trim(), "factor", "passcode", "passcode", credential.getPassword().trim()));
            JSONObject result = this.executeDuoApiRequest(request);
            LOGGER.debug("Duo authentication response: [{}]", (Object)result);
            if ("allow".equalsIgnoreCase(result.getString("result"))) {
                return DuoSecurityAuthenticationResult.builder().success(true).username(credential.getId()).build();
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return DuoSecurityAuthenticationResult.builder().success(false).username(credential.getId()).build();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDuoSecurityAuthenticationService)) {
            return false;
        }
        BaseDuoSecurityAuthenticationService other = (BaseDuoSecurityAuthenticationService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DuoSecurityMultifactorAuthenticationProperties this$properties = this.properties;
        DuoSecurityMultifactorAuthenticationProperties other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseDuoSecurityAuthenticationService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DuoSecurityMultifactorAuthenticationProperties $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    protected BaseDuoSecurityAuthenticationService(DuoSecurityMultifactorAuthenticationProperties properties, HttpClient httpClient, TenantExtractor tenantExtractor, List<MultifactorAuthenticationPrincipalResolver> multifactorAuthenticationPrincipalResolver, Cache<String, DuoSecurityUserAccount> userAccountCache) {
        this.properties = properties;
        this.httpClient = httpClient;
        this.tenantExtractor = tenantExtractor;
        this.multifactorAuthenticationPrincipalResolver = multifactorAuthenticationPrincipalResolver;
        this.userAccountCache = userAccountCache;
    }

    @Generated
    public DuoSecurityMultifactorAuthenticationProperties getProperties() {
        return this.properties;
    }

    private static final class CasHttpBuilder
    extends Http.HttpBuilder {
        CasHttpBuilder(String method, String host, String uri) {
            super(method, host, uri);
        }
    }
}

