/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service.wa;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="WA")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="wa/config")
public interface WAConfigService
extends JAXRSService {
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Attr> list();

    @GET
    @Path(value="{schema}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Attr get(@NotNull @PathParam(value="schema") String var1);

    @Parameter(name="schema", description="Configuration schema", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{schema}")
    public void set(@NotNull Attr var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{schema}")
    @Produces(value={"application/json"})
    public void delete(@NotNull @PathParam(value="schema") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="push/{subject}")
    @Produces(value={"application/json"})
    public void pushToWA(@NotNull @PathParam(value="subject") PushSubject var1, @QueryParam(value="service") List<String> var2);

    public static enum PushSubject {
        clientApps,
        conf;

    }
}

