/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.dialect.DB2SqlAstTranslator;
import org.hibernate.dialect.DB2iDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2iSqlAstTranslator<T extends JdbcOperation>
extends DB2SqlAstTranslator<T> {
    private final DatabaseVersion version;

    public DB2iSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, DatabaseVersion version) {
        super(sessionFactory, statement);
        this.version = version;
    }

    @Override
    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        if (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart)) {
            return true;
        }
        return this.version.isBefore(7, 1) && queryPart.getFetchClauseExpression() != null && !(queryPart.getFetchClauseExpression() instanceof Literal);
    }

    @Override
    protected boolean supportsOffsetClause() {
        return this.version.isSameOrAfter(7, 1);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    protected void renderExpressionsAsValuesSubquery(int tupleSize, List<Expression> listExpressions) {
        this.appendSql("values");
        int separator = 32;
        for (Expression expression : listExpressions) {
            this.appendSql((char)separator);
            this.appendSql('(');
            this.renderCommaSeparated(SqlTupleContainer.getSqlTuple(expression).getExpressions());
            this.appendSql(')');
            separator = 44;
        }
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2iDialect.DB2_LUW_VERSION;
    }

    @Override
    protected String getForUpdate() {
        return " for update with rs";
    }
}

