/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenValidator;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AccessTokenValidatorTest
extends OAuthBearerTest {
    protected abstract AccessTokenValidator createAccessTokenValidator(AccessTokenBuilder var1) throws Exception;

    protected AccessTokenValidator createAccessTokenValidator() throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder();
        return this.createAccessTokenValidator(builder);
    }

    @Test
    public void testNull() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        this.assertThrowsWithMessage(ValidateException.class, () -> validator.validate(null), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testEmptyString() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        this.assertThrowsWithMessage(ValidateException.class, () -> validator.validate(""), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testWhitespace() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        this.assertThrowsWithMessage(ValidateException.class, () -> validator.validate("    "), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testEmptySections() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        this.assertThrowsWithMessage(ValidateException.class, () -> validator.validate(".."), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testMissingHeader() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        String header = "";
        String payload = this.createBase64JsonJwtSection(node -> {});
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(ValidateException.class, () -> validator.validate(accessToken));
    }

    @Test
    public void testMissingPayload() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        String header = this.createBase64JsonJwtSection(node -> node.put("alg", "none"));
        String payload = "";
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(ValidateException.class, () -> validator.validate(accessToken));
    }

    @Test
    public void testMissingSignature() throws Exception {
        AccessTokenValidator validator = this.createAccessTokenValidator();
        String header = this.createBase64JsonJwtSection(node -> node.put("alg", "none"));
        String payload = this.createBase64JsonJwtSection(node -> {});
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(ValidateException.class, () -> validator.validate(accessToken));
    }
}

