/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.rest.SRARouteRestClient;
import org.apache.syncope.client.console.rest.SRAStatistics;
import org.apache.syncope.client.console.rest.SRAStatisticsRestClient;
import org.apache.syncope.client.console.widgets.NumberWidget;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.to.SRARouteTO;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class SRAStatisticsPanel
extends Panel {
    private static final long serialVersionUID = 23816535591360L;
    protected static final List<Buttons.Type> TYPES = List.of(Buttons.Type.Info, Buttons.Type.Success, Buttons.Type.Warning, Buttons.Type.Danger, Buttons.Type.Dark);
    @SpringBean
    protected SRARouteRestClient sraRouteRestClient;
    @SpringBean
    protected SRAStatisticsRestClient sraStatisticsRestClient;
    protected final NumberWidget count;
    protected final NumberWidget totalTime;
    protected final NumberWidget max;
    protected final List<Pair<String, String>> selected = new ArrayList<Pair<String, String>>();
    protected final LoadableDetachableModel<Map<String, String>> routes = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = 9089911876466472133L;

        protected Map<String, String> load() {
            return SRAStatisticsPanel.this.sraRouteRestClient.list().stream().collect(Collectors.toMap(SRARouteTO::getKey, SRARouteTO::getName));
        }
    };
    protected int current;

    public SRAStatisticsPanel(String id, final List<NetworkService> instances) {
        super(id);
        SRAStatistics stats = this.sraStatisticsRestClient.get(instances, this.selected);
        this.count = new NumberWidget("count", "text-bg-success", (Number)stats.getMeasurement("COUNT").orElse(Float.valueOf(0.0f)), "count", "fas fa-pen-nib");
        this.add(new Component[]{this.count});
        this.totalTime = new NumberWidget("totalTime", "bg-info", (Number)stats.getMeasurement("TOTAL_TIME").orElse(Float.valueOf(0.0f)), "total time", "fas fa-stopwatch");
        this.add(new Component[]{this.totalTime});
        this.max = new NumberWidget("max", "text-bg-warning", (Number)stats.getMeasurement("MAX").orElse(Float.valueOf(0.0f)), "max", "fas fa-greater-than");
        this.add(new Component[]{this.max});
        ListView<SRAStatistics.Tag> availableTags = new ListView<SRAStatistics.Tag>(this, "availableTags", stats.getAvailableTags()){
            private static final long serialVersionUID = -9112553137618363167L;
            final /* synthetic */ SRAStatisticsPanel this$0;
            {
                this.this$0 = this$0;
                super(id, list);
            }

            protected void populateItem(final ListItem<SRAStatistics.Tag> tag) {
                final String btnCss = this.this$0.next().cssClassName();
                tag.add(new Component[]{new Label("label", (Serializable)((Object)((SRAStatistics.Tag)tag.getModelObject()).getTag()))});
                tag.add(new Component[]{new ListView<String>(this, "tag", ((SRAStatistics.Tag)tag.getModelObject()).getValues()){
                    private static final long serialVersionUID = -9112553137618363167L;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(id, list);
                    }

                    protected void populateItem(final ListItem<String> value) {
                        AjaxLink<String> valueLink = new AjaxLink<String>(this, "valueLink"){
                            private static final long serialVersionUID = 6250423506463465679L;
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                                super(id);
                            }

                            public void onClick(AjaxRequestTarget target) {
                                Pair selection = Pair.of((Object)((SRAStatistics.Tag)tag.getModelObject()).getTag(), (Object)((String)value.getModelObject()));
                                if (this.this$2.this$1.this$0.selected.contains(selection)) {
                                    this.this$2.this$1.this$0.selected.remove(selection);
                                } else {
                                    this.this$2.this$1.this$0.selected.add((Pair<String, String>)selection);
                                }
                                SRAStatistics refresh = this.this$2.this$1.this$0.sraStatisticsRestClient.get(instances, this.this$2.this$1.this$0.selected);
                                this.this$2.this$1.this$0.count.refresh((Number)refresh.getMeasurement("COUNT").orElse(Float.valueOf(0.0f)));
                                this.this$2.this$1.this$0.totalTime.refresh((Number)refresh.getMeasurement("TOTAL_TIME").orElse(Float.valueOf(0.0f)));
                                this.this$2.this$1.this$0.max.refresh((Number)refresh.getMeasurement("MAX").orElse(Float.valueOf(0.0f)));
                                target.add(new Component[]{this.this$2.this$1.this$0.count});
                                target.add(new Component[]{this.this$2.this$1.this$0.totalTime});
                                target.add(new Component[]{this.this$2.this$1.this$0.max});
                            }

                            protected void onComponentTag(ComponentTag tag2) {
                                super.onComponentTag(tag2);
                                tag2.append("class", (CharSequence)btnCss, " ");
                            }
                        };
                        IModel valueLabel = ((Map)this.this$1.this$0.routes.getObject()).containsKey(value.getModelObject()) ? Model.of((Serializable)((Object)((String)((Map)this.this$1.this$0.routes.getObject()).get(value.getModelObject())))) : value.getModel();
                        valueLink.add(new Component[]{new Label("valueLabel", valueLabel)});
                        value.add(new Component[]{valueLink});
                    }
                }});
            }
        };
        this.add(new Component[]{availableTags});
    }

    protected Buttons.Type next() {
        if (this.current < TYPES.size()) {
            Buttons.Type type = TYPES.get(this.current);
            ++this.current;
            return type;
        }
        this.current = 0;
        return this.next();
    }
}

