/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.ServiceFactoryConfigurer;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logout.DefaultLogoutConfirmationResolver;
import org.apereo.cas.logout.DefaultLogoutExecutionPlan;
import org.apereo.cas.logout.DefaultLogoutManager;
import org.apereo.cas.logout.DefaultLogoutRedirectionStrategy;
import org.apereo.cas.logout.DefaultSingleLogoutMessageCreator;
import org.apereo.cas.logout.DescendantTicketsLogoutPostProcessor;
import org.apereo.cas.logout.LogoutConfirmationResolver;
import org.apereo.cas.logout.LogoutExecutionPlan;
import org.apereo.cas.logout.LogoutExecutionPlanConfigurer;
import org.apereo.cas.logout.LogoutManager;
import org.apereo.cas.logout.LogoutPostProcessor;
import org.apereo.cas.logout.LogoutRedirectionStrategy;
import org.apereo.cas.logout.LogoutWebApplicationServiceFactory;
import org.apereo.cas.logout.slo.ChainingSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutRequestExecutor;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.DefaultSingleLogoutServiceMessageHandler;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestExecutor;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilder;
import org.apereo.cas.logout.slo.SingleLogoutServiceLogoutUrlBuilderConfigurer;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.UrlValidator;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Logout})
@AutoConfiguration
public class CasCoreLogoutAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreLogoutAutoConfiguration.class);

    @Configuration(value="CasCoreLogoutExecutorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutExecutorConfiguration {
        CasCoreLogoutExecutorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutRequestExecutor"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public SingleLogoutRequestExecutor defaultSingleLogoutRequestExecutor(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="logoutManager") LogoutManager logoutManager, ConfigurableApplicationContext applicationContext) {
            return new DefaultSingleLogoutRequestExecutor(ticketRegistry, logoutManager, (ApplicationContext)applicationContext);
        }
    }

    @Configuration(value="CasCoreLogoutServiceConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=-2147483648)
    static class CasCoreLogoutServiceConfiguration {
        CasCoreLogoutServiceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"logoutWebApplicationServiceFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactory<WebApplicationService> logoutWebApplicationServiceFactory(@Qualifier(value="urlValidator") UrlValidator urlValidator, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties) {
            return new LogoutWebApplicationServiceFactory(tenantExtractor, urlValidator, casProperties.getLogout());
        }

        @Bean
        @ConditionalOnMissingBean(name={"logoutWebApplicationServiceFactoryConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceFactoryConfigurer logoutWebApplicationServiceFactoryConfigurer(@Qualifier(value="logoutWebApplicationServiceFactory") ServiceFactory<WebApplicationService> logoutWebApplicationServiceFactory) {
            return () -> CollectionUtils.wrap((Object)logoutWebApplicationServiceFactory);
        }
    }

    @Configuration(value="CasCoreLogoutExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutExecutionPlanConfiguration {
        CasCoreLogoutExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"logoutExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LogoutExecutionPlan logoutExecutionPlan(List<LogoutExecutionPlanConfigurer> configurers) {
            DefaultLogoutExecutionPlan plan = new DefaultLogoutExecutionPlan();
            configurers.forEach(cfg -> {
                LOGGER.trace("Configuring logout execution plan [{}]", (Object)cfg.getName());
                cfg.configureLogoutExecutionPlan((LogoutExecutionPlan)plan);
            });
            return plan;
        }
    }

    @Configuration(value="CasCoreLogoutExecutionPlanBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutExecutionPlanBaseConfiguration {
        CasCoreLogoutExecutionPlanBaseConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"casCoreLogoutExecutionPlanConfigurer"})
        public LogoutExecutionPlanConfigurer casCoreLogoutExecutionPlanConfigurer(@Qualifier(value="descendantTicketsLogoutPostProcessor") LogoutPostProcessor descendantTicketsLogoutPostProcessor, CasConfigurationProperties casProperties, @Qualifier(value="defaultSingleLogoutServiceMessageHandler") SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler, @Qualifier(value="defaultLogoutRedirectionStrategy") LogoutRedirectionStrategy defaultLogoutRedirectionStrategy, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return plan -> {
                plan.registerSingleLogoutServiceMessageHandler(defaultSingleLogoutServiceMessageHandler);
                plan.registerLogoutRedirectionStrategy(defaultLogoutRedirectionStrategy);
                BeanSupplier.ifNotProxy((Object)descendantTicketsLogoutPostProcessor, arg_0 -> ((LogoutExecutionPlan)plan).registerLogoutPostProcessor(arg_0));
            };
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"descendantTicketsLogoutPostProcessor"})
        public LogoutPostProcessor descendantTicketsLogoutPostProcessor(@Qualifier(value="descendantTicketsTrackingPolicy") TicketTrackingPolicy descendantTicketsTrackingPolicy, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return (LogoutPostProcessor)BeanSupplier.of(LogoutPostProcessor.class).when(BeanCondition.on((String)"cas.ticket.track-descendant-tickets").isTrue().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DescendantTicketsLogoutPostProcessor(ticketRegistry, descendantTicketsTrackingPolicy)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreLogoutManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutManagementConfiguration {
        CasCoreLogoutManagementConfiguration() {
        }

        @ConditionalOnMissingBean(name={"logoutManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public LogoutManager logoutManager(@Qualifier(value="logoutExecutionPlan") LogoutExecutionPlan logoutExecutionPlan, CasConfigurationProperties casProperties) {
            return new DefaultLogoutManager(casProperties.getSlo().isDisabled(), logoutExecutionPlan);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"logoutConfirmationResolver"})
        public LogoutConfirmationResolver logoutConfirmationResolver(CasConfigurationProperties casProperties) {
            return new DefaultLogoutConfirmationResolver(casProperties);
        }
    }

    @Configuration(value="CasCoreLogoutMessagesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutMessagesConfiguration {
        CasCoreLogoutMessagesConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceMessageHandler"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceMessageHandler defaultSingleLogoutServiceMessageHandler(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager, CasConfigurationProperties casProperties, @Qualifier(value="defaultSingleLogoutMessageCreator") SingleLogoutMessageCreator defaultSingleLogoutMessageCreator, @Qualifier(value="noRedirectHttpClient") HttpClient noRedirectHttpClient, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
            return new DefaultSingleLogoutServiceMessageHandler(noRedirectHttpClient, defaultSingleLogoutMessageCreator, servicesManager, singleLogoutServiceLogoutUrlBuilder, casProperties.getSlo().isAsynchronous(), authenticationServiceSelectionPlan);
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutMessageCreator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutMessageCreator defaultSingleLogoutMessageCreator() {
            return new DefaultSingleLogoutMessageCreator();
        }
    }

    @Configuration(value="CasCoreLogoutRedirectConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutRedirectConfiguration {
        CasCoreLogoutRedirectConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultLogoutRedirectionStrategy"})
        public LogoutRedirectionStrategy defaultLogoutRedirectionStrategy(CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="singleLogoutServiceLogoutUrlBuilder") SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder) {
            return new DefaultLogoutRedirectionStrategy(argumentExtractor, casProperties, singleLogoutServiceLogoutUrlBuilder, webApplicationServiceFactory, servicesManager);
        }
    }

    @Configuration(value="CasCoreLogoutUrlBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreLogoutUrlBuilderConfiguration {
        CasCoreLogoutUrlBuilderConfiguration() {
        }

        @ConditionalOnMissingBean(name={"singleLogoutServiceLogoutUrlBuilder"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilder singleLogoutServiceLogoutUrlBuilder(List<SingleLogoutServiceLogoutUrlBuilderConfigurer> configurers) {
            List results = configurers.stream().sorted(Comparator.comparing(SingleLogoutServiceLogoutUrlBuilderConfigurer::getOrder)).map(cfg -> {
                SingleLogoutServiceLogoutUrlBuilder builder = cfg.configureBuilder();
                LOGGER.trace("Configuring single logout url builder [{}]", (Object)builder.getName());
                return builder;
            }).filter(BeanSupplier::isNotProxy).sorted(Comparator.comparing(SingleLogoutServiceLogoutUrlBuilder::getOrder)).collect(Collectors.toList());
            return new ChainingSingleLogoutServiceLogoutUrlBuilder(results);
        }

        @ConditionalOnMissingBean(name={"defaultSingleLogoutServiceLogoutUrlBuilderConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public SingleLogoutServiceLogoutUrlBuilderConfigurer defaultSingleLogoutServiceLogoutUrlBuilderConfigurer(@Qualifier(value="urlValidator") UrlValidator urlValidator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return () -> new DefaultSingleLogoutServiceLogoutUrlBuilder(servicesManager, urlValidator);
        }
    }
}

