/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client.azuread;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.text.ParseException;

public class AzureAdIdTokenValidator
extends IDTokenValidator {
    private IDTokenValidator base;
    private String originalIssuer;

    public AzureAdIdTokenValidator(IDTokenValidator base) {
        super(base.getExpectedIssuer(), base.getClientID());
        this.base = base;
        this.originalIssuer = base.getExpectedIssuer().getValue();
    }

    public IDTokenClaimsSet validate(JWT idToken, Nonce expectedNonce) throws BadJOSEException, JOSEException {
        try {
            if (this.originalIssuer.contains("%7Btenantid%7D")) {
                Object tid = idToken.getJWTClaimsSet().getClaim("tid");
                if (tid == null) {
                    throw new BadJWTException("ID token does not contain the 'tid' claim");
                }
                this.base = new IDTokenValidator(new Issuer(this.originalIssuer.replace("%7Btenantid%7D", tid.toString())), this.base.getClientID(), this.base.getJWSKeySelector(), this.base.getJWEKeySelector());
                this.base.setMaxClockSkew(this.getMaxClockSkew());
            }
        }
        catch (ParseException e) {
            throw new BadJWTException(e.getMessage(), (Throwable)e);
        }
        return this.base.validate(idToken, expectedNonce);
    }
}

