/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.slo;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.logout.slo.SingleLogoutMessage;
import org.apereo.cas.logout.slo.SingleLogoutMessageCreator;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.nameid.SamlAttributeBasedNameIdGenerator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlIdPProfileSingleLogoutMessageCreator
extends AbstractSaml20ObjectBuilder
implements SingleLogoutMessageCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPProfileSingleLogoutMessageCreator.class);
    private final SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext;
    private final SOAPObjectBuilder<Envelope> envelopeBuilder;
    private final SOAPObjectBuilder<Body> bodyBuilder;

    public SamlIdPProfileSingleLogoutMessageCreator(SamlProfileHandlerConfigurationContext samlProfileHandlerConfigurationContext) {
        super(samlProfileHandlerConfigurationContext.getOpenSamlConfigBean());
        this.samlProfileHandlerConfigurationContext = samlProfileHandlerConfigurationContext;
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envelopeBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
    }

    public SingleLogoutMessage create(SingleLogoutRequestContext request) throws Throwable {
        SamlIdPProperties samlIdPProperties = this.samlProfileHandlerConfigurationContext.getCasProperties().getAuthn().getSamlIdp();
        String id = "_" + String.valueOf(RandomUtils.nextLong());
        SamlRegisteredService samlService = (SamlRegisteredService)request.getRegisteredService();
        long skewAllowance = samlService.getSkewAllowance() != 0 ? (long)samlService.getSkewAllowance() : Beans.newDuration((String)samlIdPProperties.getResponse().getSkewAllowance()).toSeconds();
        ZonedDateTime issueInstant = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(skewAllowance);
        String serviceId = request.getService().getId();
        SamlRegisteredServiceCachingMetadataResolver resolver = this.samlProfileHandlerConfigurationContext.getSamlRegisteredServiceCachingMetadataResolver();
        SamlRegisteredServiceMetadataAdaptor adaptor = (SamlRegisteredServiceMetadataAdaptor)SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)resolver, (SamlRegisteredService)samlService, (String)serviceId).orElseThrow(() -> new IllegalArgumentException("Unable to find metadata for saml service " + serviceId));
        NameID nameId = this.buildNameId(request, adaptor);
        LogoutRequest samlLogoutRequest = this.newLogoutRequest(id, issueInstant, request.getLogoutUrl().toExternalForm(), this.newIssuer(samlIdPProperties.getCore().getEntityId()), request.getTicketId(), nameId);
        String binding = (String)request.getProperties().get("singleLogoutSamlBinding");
        if (this.shouldSignLogoutRequestFor(samlService)) {
            HttpServletRequest httpRequest = HttpRequestUtils.getHttpServletRequestFromRequestAttributes();
            HttpServletResponse httpResponse = HttpRequestUtils.getHttpServletResponseFromRequestAttributes();
            FunctionUtils.doUnchecked(__ -> this.samlProfileHandlerConfigurationContext.getSamlObjectSigner().encode(samlLogoutRequest, samlService, adaptor, httpResponse, httpRequest, binding, (RequestAbstractType)samlLogoutRequest, new MessageContext()), (Object[])new Object[0]);
        }
        if ("urn:oasis:names:tc:SAML:2.0:bindings:SOAP".equalsIgnoreCase(binding)) {
            Envelope envelope = (Envelope)this.envelopeBuilder.buildObject();
            Body body = (Body)this.bodyBuilder.buildObject();
            envelope.setBody(body);
            body.getUnknownXMLObjects().add(samlLogoutRequest);
            SamlUtils.logSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)envelope);
            return this.buildSingleLogoutMessage(samlLogoutRequest, (XMLObject)envelope);
        }
        SamlUtils.logSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)samlLogoutRequest);
        return this.buildSingleLogoutMessage(samlLogoutRequest, (XMLObject)samlLogoutRequest);
    }

    private NameID buildNameId(SingleLogoutRequestContext request, SamlRegisteredServiceMetadataAdaptor adaptor) throws Throwable {
        List effectiveNameIdFormats;
        SamlRegisteredService samlService = (SamlRegisteredService)request.getRegisteredService();
        List list = effectiveNameIdFormats = StringUtils.isNotBlank((CharSequence)samlService.getRequiredNameIdFormat()) ? CollectionUtils.wrapList((Object[])new String[]{samlService.getRequiredNameIdFormat()}) : adaptor.getSupportedNameIdFormats();
        if (effectiveNameIdFormats.isEmpty()) {
            effectiveNameIdFormats.add("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        }
        for (String nameFormat : effectiveNameIdFormats) {
            try {
                String nameIdValue = this.buildLogoutRequestNameId(request, nameFormat);
                SAML2NameIDGenerator encoder = SamlAttributeBasedNameIdGenerator.get(Optional.empty(), nameFormat, samlService, nameIdValue);
                LOGGER.debug("Encoding NameID based on [{}]", (Object)nameFormat);
                NameID nameId = encoder.generate(new ProfileRequestContext(), nameFormat);
                if (nameId == null) continue;
                LOGGER.debug("Generated NameID [{}] with format [{}]", (Object)nameId.getValue(), (Object)nameFormat);
                return nameId;
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Unable to find supported NameID format for service %s".formatted(samlService.getServiceId()));
    }

    protected boolean shouldSignLogoutRequestFor(SamlRegisteredService registeredService) {
        SamlIdPProperties samlIdPProperties = this.samlProfileHandlerConfigurationContext.getCasProperties().getAuthn().getSamlIdp();
        return registeredService.getSignLogoutRequest().isUndefined() ? samlIdPProperties.getLogout().isForceSignedLogoutRequests() : registeredService.getSignLogoutRequest().isTrue();
    }

    protected String buildLogoutRequestNameId(SingleLogoutRequestContext request, String nameIdFormat) throws Throwable {
        SamlRegisteredService samlService = (SamlRegisteredService)request.getRegisteredService();
        LOGGER.debug("Preparing NameID attribute for SAML service [{}] with format [{}]", (Object)samlService.getName(), (Object)nameIdFormat);
        Principal principal = request.getExecutionRequest().getTicketGrantingTicket().getAuthentication().getPrincipal();
        if ("urn:oasis:names:tc:SAML:2.0:nameid-format:transient".equalsIgnoreCase(StringUtils.trim((String)nameIdFormat))) {
            String serviceId = request.getService().getId();
            SamlRegisteredServiceCachingMetadataResolver resolver = this.samlProfileHandlerConfigurationContext.getSamlRegisteredServiceCachingMetadataResolver();
            Optional adaptorRes = SamlRegisteredServiceMetadataAdaptor.get((SamlRegisteredServiceCachingMetadataResolver)resolver, (SamlRegisteredService)samlService, (String)serviceId);
            SamlRegisteredServiceMetadataAdaptor adaptor = (SamlRegisteredServiceMetadataAdaptor)adaptorRes.orElseThrow(() -> new IllegalArgumentException("Unable to find metadata for saml service " + serviceId));
            String entityId = adaptor.getEntityId();
            String principalName = principal.getId();
            LOGGER.debug("Generating transient NameID value for principal [{}] and entity id [{}]", (Object)principalName, (Object)entityId);
            return this.samlProfileHandlerConfigurationContext.getPersistentIdGenerator().generate(principalName, entityId);
        }
        RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)samlService).service((Service)request.getService()).principal(principal).applicationContext(this.samlProfileHandlerConfigurationContext.getApplicationContext()).build();
        String principalName = samlService.getUsernameAttributeProvider().resolveUsername(usernameContext);
        LOGGER.trace("Preparing NameID attribute for principal [{}]", (Object)principalName);
        return principalName;
    }

    private SingleLogoutMessage buildSingleLogoutMessage(LogoutRequest logoutRequest, XMLObject message) {
        SingleLogoutMessage.SingleLogoutMessageBuilder builder = SingleLogoutMessage.builder();
        return builder.message((Object)logoutRequest).payload(SamlUtils.transformSamlObject((OpenSamlConfigBean)this.openSamlConfigBean, (XMLObject)message).toString()).build();
    }
}

