/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;

public class SyncInvokerImpl
implements SyncInvoker {
    private WebClient wc;

    public SyncInvokerImpl(WebClient wc) {
        this.wc = wc;
    }

    public Response delete() {
        return this.method("DELETE");
    }

    public <T> T delete(Class<T> cls) {
        return this.method("DELETE", cls);
    }

    public <T> T delete(GenericType<T> genericType) {
        return this.method("DELETE", genericType);
    }

    public Response get() {
        return this.method("GET");
    }

    public <T> T get(Class<T> cls) {
        return this.method("GET", cls);
    }

    public <T> T get(GenericType<T> genericType) {
        return this.method("GET", genericType);
    }

    public Response head() {
        return this.method("HEAD");
    }

    public Response options() {
        return this.method("OPTIONS");
    }

    public <T> T options(Class<T> cls) {
        return this.method("OPTIONS", cls);
    }

    public <T> T options(GenericType<T> genericType) {
        return this.method("OPTIONS", genericType);
    }

    public Response post(Entity<?> entity) {
        return this.method("POST", entity);
    }

    public <T> T post(Entity<?> entity, Class<T> cls) {
        return this.method("POST", entity, cls);
    }

    public <T> T post(Entity<?> entity, GenericType<T> genericType) {
        return this.method("POST", entity, genericType);
    }

    public Response put(Entity<?> entity) {
        return this.method("PUT", entity);
    }

    public <T> T put(Entity<?> entity, Class<T> cls) {
        return this.method("PUT", entity, cls);
    }

    public <T> T put(Entity<?> entity, GenericType<T> genericType) {
        return this.method("PUT", entity, genericType);
    }

    public Response trace() {
        return this.method("TRACE");
    }

    public <T> T trace(Class<T> cls) {
        return this.method("TRACE", cls);
    }

    public <T> T trace(GenericType<T> genericType) {
        return this.method("TRACE", genericType);
    }

    public Response method(String method) {
        return this.method(method, Response.class);
    }

    public <T> T method(String method, Class<T> cls) {
        return this.wc.invoke(method, null, cls);
    }

    public <T> T method(String method, GenericType<T> genericType) {
        return this.wc.invoke(method, null, genericType);
    }

    public Response method(String method, Entity<?> entity) {
        return this.method(method, entity, Response.class);
    }

    public <T> T method(String method, Entity<?> entity, Class<T> cls) {
        return this.wc.invoke(method, entity, cls);
    }

    public <T> T method(String method, Entity<?> entity, GenericType<T> genericType) {
        return this.wc.invoke(method, entity, genericType);
    }

    public WebClient getWebClient() {
        return this.wc;
    }
}

