/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.metadata;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.configurationmetadata.CasConfigurationMetadataRepositoryJsonBuilder;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CasConfigurationMetadataRepository {
    public static final String BEAN_NAME = "casConfigurationMetadataRepository";
    private static final String CONFIGURATION_METADATA_RESOURCE_PATTERN = "classpath*:META-INF/spring-configuration-metadata.json";
    private final ConfigurationMetadataRepository repository;

    public CasConfigurationMetadataRepository() {
        this(CasConfigurationMetadataRepository.collectConfigurationMetadata());
    }

    public CasConfigurationMetadataRepository(List<byte[]> sources) {
        CasConfigurationMetadataRepositoryJsonBuilder builder = CasConfigurationMetadataRepositoryJsonBuilder.create();
        sources.forEach(Unchecked.consumer(buffer -> {
            try (ByteArrayInputStream stream = new ByteArrayInputStream((byte[])buffer);){
                builder.withJsonResource(stream, StandardCharsets.UTF_8);
            }
        }));
        this.repository = builder.build();
    }

    public static String getPropertyGroupId(ConfigurationMetadataProperty prop) {
        if (CasConfigurationMetadataRepository.isCasProperty(prop)) {
            return StringUtils.substringBeforeLast((String)prop.getName(), (String)".");
        }
        return StringUtils.substringBeforeLast((String)prop.getId(), (String)".");
    }

    public static boolean isCasProperty(ConfigurationMetadataProperty prop) {
        return prop.getName().startsWith("cas".concat("."));
    }

    public Set<ConfigurationMetadataProperty> getPropertiesWithType(Class clazz) {
        return this.repository.getAllProperties().values().stream().filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getType())).filter(prop -> prop.getType().contains(clazz.getName())).collect(Collectors.toSet());
    }

    private static List<byte[]> collectConfigurationMetadata() {
        return (List)FunctionUtils.doUnchecked(() -> {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(CONFIGURATION_METADATA_RESOURCE_PATTERN);
            return Arrays.stream(resources).map(Unchecked.function(r -> {
                try (InputStream in = r.getInputStream();){
                    byte[] byArray = in.readAllBytes();
                    return byArray;
                }
            })).toList();
        });
    }

    @Generated
    public ConfigurationMetadataRepository getRepository() {
        return this.repository;
    }
}

