/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationmetadata;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataHint;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.boot.configurationmetadata.JsonReader;
import org.springframework.boot.configurationmetadata.RawConfigurationMetadata;
import org.springframework.boot.configurationmetadata.SimpleConfigurationMetadataRepository;

public class CasConfigurationMetadataRepositoryJsonBuilder {
    private final JsonReader reader = new JsonReader();
    private final List<SimpleConfigurationMetadataRepository> repositories = new ArrayList<SimpleConfigurationMetadataRepository>();
    private final Charset defaultCharset;

    CasConfigurationMetadataRepositoryJsonBuilder(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    private static void addValueHints(ConfigurationMetadataProperty property, ConfigurationMetadataHint hint) {
        property.getHints().getValueHints().addAll(hint.getValueHints());
        property.getHints().getValueProviders().addAll(hint.getValueProviders());
    }

    private static void addMapHints(ConfigurationMetadataProperty property, ConfigurationMetadataHint hint) {
        property.getHints().getKeyHints().addAll(hint.getValueHints());
        property.getHints().getKeyProviders().addAll(hint.getValueProviders());
    }

    private static ConfigurationMetadataSource getSource(RawConfigurationMetadata metadata, ConfigurationMetadataItem item) {
        if (item.getSourceType() == null) {
            return null;
        }
        int idx = item.getId().lastIndexOf(46);
        String name = idx > 0 ? item.getId().substring(0, idx) : "";
        return metadata.getSources().stream().filter(source -> Objects.equals(source.getType(), item.getSourceType()) && name.equals(source.getGroupId())).findFirst().orElse(null);
    }

    private static SimpleConfigurationMetadataRepository create(RawConfigurationMetadata metadata) {
        SimpleConfigurationMetadataRepository repository = new SimpleConfigurationMetadataRepository();
        repository.add((Collection)metadata.getSources());
        for (ConfigurationMetadataItem item : metadata.getItems()) {
            ConfigurationMetadataSource source = CasConfigurationMetadataRepositoryJsonBuilder.getSource(metadata, item);
            repository.add((ConfigurationMetadataProperty)item, source);
        }
        Map allProperties = repository.getAllProperties();
        for (ConfigurationMetadataHint hint : metadata.getHints()) {
            ConfigurationMetadataProperty property = (ConfigurationMetadataProperty)allProperties.get(hint.getId());
            if (property != null) {
                CasConfigurationMetadataRepositoryJsonBuilder.addValueHints(property, hint);
                continue;
            }
            String id = hint.resolveId();
            property = (ConfigurationMetadataProperty)allProperties.get(id);
            if (property == null) continue;
            if (hint.isMapKeyHints()) {
                CasConfigurationMetadataRepositoryJsonBuilder.addMapHints(property, hint);
                continue;
            }
            CasConfigurationMetadataRepositoryJsonBuilder.addValueHints(property, hint);
        }
        return repository;
    }

    public static CasConfigurationMetadataRepositoryJsonBuilder create(InputStream ... inputStreams) {
        CasConfigurationMetadataRepositoryJsonBuilder builder = CasConfigurationMetadataRepositoryJsonBuilder.create();
        for (InputStream inputStream : inputStreams) {
            builder = builder.withJsonResource(inputStream);
        }
        return builder;
    }

    public static CasConfigurationMetadataRepositoryJsonBuilder create() {
        return CasConfigurationMetadataRepositoryJsonBuilder.create(StandardCharsets.UTF_8);
    }

    public static CasConfigurationMetadataRepositoryJsonBuilder create(Charset defaultCharset) {
        return new CasConfigurationMetadataRepositoryJsonBuilder(defaultCharset);
    }

    @CanIgnoreReturnValue
    public CasConfigurationMetadataRepositoryJsonBuilder withJsonResource(InputStream inputStream) {
        return this.withJsonResource(inputStream, this.defaultCharset);
    }

    @CanIgnoreReturnValue
    public CasConfigurationMetadataRepositoryJsonBuilder withJsonResource(InputStream inputStream, Charset charset) {
        Objects.requireNonNull(inputStream, "InputStream must not be null.");
        this.repositories.add(this.add(inputStream, charset));
        return this;
    }

    public ConfigurationMetadataRepository build() {
        SimpleConfigurationMetadataRepository result = new SimpleConfigurationMetadataRepository();
        for (SimpleConfigurationMetadataRepository repository : this.repositories) {
            result.include((ConfigurationMetadataRepository)repository);
        }
        return result;
    }

    private SimpleConfigurationMetadataRepository add(InputStream in, Charset charset) {
        try {
            RawConfigurationMetadata metadata = this.reader.read(in, charset);
            return CasConfigurationMetadataRepositoryJsonBuilder.create(metadata);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to read configuration metadata", ex);
        }
    }
}

