/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import com.yubico.core.RegistrationStorage;
import com.yubico.core.SessionManager;
import com.yubico.webauthn.data.ByteArray;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.webauthn.WebAuthnCredential;
import org.apereo.cas.webauthn.WebAuthnMultifactorAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnValidateSessionCredentialTokenAction
extends AbstractMultifactorAuthenticationAction<WebAuthnMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebAuthnValidateSessionCredentialTokenAction.class);
    protected final RegistrationStorage webAuthnCredentialRepository;
    protected final SessionManager sessionManager;
    protected final PrincipalFactory principalFactory;
    protected final TenantExtractor tenantExtractor;

    protected Event doExecuteInternal(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            LOGGER.warn("Missing web authn token from the request");
            return this.eventFactory.event((Object)this, "authenticationFailure");
        }
        LOGGER.debug("Received web authn token [{}]", (Object)token);
        WebAuthnCredential credential = new WebAuthnCredential(token);
        WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
        Optional session = this.sessionManager.getSession(request, WebAuthnCredential.from((WebAuthnCredential)credential));
        if (session.isEmpty()) {
            LOGGER.warn("Unable to locate existing session from the current token [{}]", (Object)token);
            return this.eventFactory.event((Object)this, "authenticationFailure");
        }
        Optional result = this.webAuthnCredentialRepository.getUsernameForUserHandle((ByteArray)session.get());
        if (result.isEmpty()) {
            LOGGER.warn("Unable to locate user based on the given user handle");
            return this.eventFactory.event((Object)this, "authenticationFailure");
        }
        String username = (String)result.get();
        return (Event)FunctionUtils.doUnchecked(() -> {
            Authentication authentication = DefaultAuthenticationBuilder.newInstance().addCredential((Credential)credential).setPrincipal(this.principalFactory.createPrincipal(username)).build();
            LOGGER.debug("Finalized authentication attempt based on [{}]", (Object)authentication);
            WebUtils.putAuthentication((Authentication)authentication, (RequestContext)requestContext);
            return this.eventFactory.event((Object)this, "finalize");
        });
    }

    @Generated
    public WebAuthnValidateSessionCredentialTokenAction(RegistrationStorage webAuthnCredentialRepository, SessionManager sessionManager, PrincipalFactory principalFactory, TenantExtractor tenantExtractor) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
        this.sessionManager = sessionManager;
        this.principalFactory = principalFactory;
        this.tenantExtractor = tenantExtractor;
    }
}

