/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.multitenancy.TenantsManager;
import org.apereo.cas.multitenancy.UnknownTenantException;
import org.apereo.cas.web.flow.CasWebflowIdExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasWebflowIdExtractor
implements CasWebflowIdExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasWebflowIdExtractor.class);
    private final TenantExtractor tenantExtractor;
    private final TenantsManager tenantsManager;
    private final CasConfigurationProperties casProperties;

    public String extract(HttpServletRequest request, String flowId) {
        if (this.casProperties.getMultitenancy().getCore().isEnabled() && DefaultCasWebflowIdExtractor.isValidFlowId(flowId)) {
            TenantDefinition tenant = (TenantDefinition)this.tenantExtractor.extract(request).orElseThrow(() -> new UnknownTenantException("Unknown tenant definition for flow id " + flowId));
            request.setAttribute(TenantDefinition.class.getName(), (Object)tenant);
            return flowId.substring(flowId.lastIndexOf(47) + 1);
        }
        return flowId;
    }

    private static boolean isValidFlowId(String flowId) {
        return !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"webjars/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"css/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"favicon") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"images/") && !Strings.CI.startsWith((CharSequence)flowId, (CharSequence)"js/");
    }

    @Generated
    public TenantExtractor getTenantExtractor() {
        return this.tenantExtractor;
    }

    @Generated
    public TenantsManager getTenantsManager() {
        return this.tenantsManager;
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public DefaultCasWebflowIdExtractor(TenantExtractor tenantExtractor, TenantsManager tenantsManager, CasConfigurationProperties casProperties) {
        this.tenantExtractor = tenantExtractor;
        this.tenantsManager = tenantsManager;
        this.casProperties = casProperties;
    }
}

