/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.authentication;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetadata;
import org.apereo.cas.authentication.credential.AbstractCredential;
import org.apereo.cas.authentication.metadata.BasicCredentialMetadata;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.CasWebflowCredentialProvider;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasWebflowCredentialProvider
implements CasWebflowCredentialProvider {
    protected final TenantExtractor tenantExtractor;

    @Nonnull
    public List<Credential> extract(RequestContext requestContext) {
        Credential credential = WebUtils.getCredential((RequestContext)requestContext);
        if (credential instanceof AbstractCredential) {
            AbstractCredential ac = (AbstractCredential)credential;
            if (ac.getCredentialMetadata() == null) {
                ac.setCredentialMetadata((CredentialMetadata)new BasicCredentialMetadata(credential));
            }
            CredentialMetadata credentialMetadata = Objects.requireNonNull(credential).getCredentialMetadata();
            credentialMetadata.setTenant((String)this.tenantExtractor.extract(requestContext).map(TenantDefinition::getId).orElse(null));
        }
        return CollectionUtils.wrapList((Object[])new Credential[]{credential});
    }

    @Generated
    public DefaultCasWebflowCredentialProvider(TenantExtractor tenantExtractor) {
        this.tenantExtractor = tenantExtractor;
    }
}

