/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.web.flow.resolver.CasWebflowAware;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

final class WebflowExceptionTranslator {
    private static final EventFactorySupport EVENT_FACTORY_SUPPORT = new EventFactorySupport();
    private static final List<Class> SUPPORTED_EXCEPTIONS = List.of(AuthenticationException.class, AbstractTicketException.class, CasWebflowAware.class);

    public static Event from(Throwable exception, RequestContext requestContext) {
        if (WebflowExceptionTranslator.isSupportedException(exception)) {
            return EVENT_FACTORY_SUPPORT.event((Object)exception, "authenticationFailure");
        }
        if (WebflowExceptionTranslator.isSupportedException(exception.getCause())) {
            return EVENT_FACTORY_SUPPORT.event((Object)exception.getCause(), "authenticationFailure");
        }
        return EVENT_FACTORY_SUPPORT.event((Object)exception, "error");
    }

    private static boolean isSupportedException(Throwable exception) {
        return exception != null && SUPPORTED_EXCEPTIONS.stream().anyMatch(type -> type.isAssignableFrom(exception.getClass()));
    }

    @Generated
    private WebflowExceptionTranslator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

