/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import org.codehaus.groovy.runtime.FormatHelper;
import org.codehaus.groovy.runtime.MethodRankHelper;

public class MissingMethodException
extends GroovyRuntimeException {
    private static final long serialVersionUID = -6676430495683939401L;
    private final String method;
    private final Class<?> type;
    private final boolean isStatic;
    private final Object[] arguments;

    public MissingMethodException(String method, Class<?> type, Object[] arguments) {
        this(method, type, arguments, false);
    }

    public MissingMethodException(String method, Class<?> type, Object[] arguments, boolean isStatic) {
        this.method = method;
        this.type = type;
        this.isStatic = isStatic;
        this.arguments = arguments != null ? arguments : new Object[]{};
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getMessage() {
        Class<?> type = this.getType();
        Object[] args = this.getArguments();
        return "No signature of " + (this.isStatic() ? "static " : "") + "method: " + this.getMethod() + " for class: " + (type != null ? type.getName() : "<unknown>") + " is applicable for argument types: (" + FormatHelper.toTypeString(args, 80) + ") values: " + FormatHelper.toArrayString(args, 80, true) + (type != null ? MethodRankHelper.getMethodSuggestionString(this.getMethod(), type, args) : "");
    }

    public String getMethod() {
        return this.method;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

