/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter;

import java.time.Instant;
import java.util.Map;
import org.apache.syncope.wa.bootstrap.WAProperties;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.config.WARefreshContextJob;
import org.apereo.cas.config.CasGoogleAuthenticatorLdapAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.metadata.CasConfigurationPropertiesValidator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.gson.GsonAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.autoconfigure.jersey.JerseyAutoConfiguration;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication(exclude={HibernateJpaAutoConfiguration.class, JerseyAutoConfiguration.class, GroovyTemplateAutoConfiguration.class, GsonAutoConfiguration.class, JmxAutoConfiguration.class, DataSourceAutoConfiguration.class, DataSourceHealthContributorAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class, RedisAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, CassandraAutoConfiguration.class, CasGoogleAuthenticatorLdapAutoConfiguration.class})
@EnableConfigurationProperties(value={WAProperties.class, CasConfigurationProperties.class})
@EnableAsync(proxyTargetClass=false)
@EnableAspectJAutoProxy(proxyTargetClass=false)
@EnableTransactionManagement(proxyTargetClass=false)
@EnableScheduling
public class SyncopeWAApplication
extends SpringBootServletInitializer {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeWAApplication.class);

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeWAApplication.class}).properties(Map.of("spring.config.name", "wa", "spring.cloud.bootstrap.name", "wa")).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("spring.config.name", "wa", "spring.cloud.bootstrap.name", "wa")).sources(new Class[]{SyncopeWAApplication.class});
    }

    @EventListener
    public void handleApplicationReadyEvent(ApplicationReadyEvent event) {
        new CasConfigurationPropertiesValidator(event.getApplicationContext()).validate();
        WARestClient waRestClient = (WARestClient)event.getApplicationContext().getBean(WARestClient.class);
        ContextRefresher contextRefresher = (ContextRefresher)event.getApplicationContext().getBean(ContextRefresher.class);
        SamlIdPMetadataGenerator metadataGenerator = (SamlIdPMetadataGenerator)event.getApplicationContext().getBean(SamlIdPMetadataGenerator.class);
        WARefreshContextJob job = new WARefreshContextJob(waRestClient, contextRefresher, metadataGenerator);
        WAProperties waProperties = (WAProperties)event.getApplicationContext().getBean(WAProperties.class);
        TaskScheduler scheduler = (TaskScheduler)event.getApplicationContext().getBean(TaskScheduler.class);
        Instant startAt = Instant.now().plusSeconds(waProperties.getContextRefreshDelay());
        try {
            scheduler.schedule((Runnable)job, startAt);
            LOG.info("Scheduled job to refresh application context @ [{}]", (Object)startAt);
        }
        catch (TaskRejectedException e) {
            throw new IllegalStateException("Could not schedule refresh job", e);
        }
    }
}

