/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.pushpull.AnyPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.SyncopeResultHandlerDispatcher;
import org.springframework.transaction.annotation.Transactional;

public class PushResultHandlerDispatcher
extends SyncopeResultHandlerDispatcher<PushTask, PushActions, SyncopePushResultHandler> {
    protected SyncopePushExecutor executor;

    public PushResultHandlerDispatcher init(ProvisioningProfile<PushTask, PushActions> profile, SyncopePushExecutor executor) {
        this.init(profile);
        this.executor = executor;
        return this;
    }

    @Transactional(readOnly=true)
    public boolean handle(Any any) {
        if (this.tpte.isEmpty()) {
            boolean result = ((AnyPushResultHandler)this.nonConcurrentHandler(any.getType().getKey())).handle(any);
            this.executor.reportHandled(any.getType().getKey(), any.getKey());
            return result;
        }
        try {
            this.submit(() -> {
                ((AnyPushResultHandler)((Supplier)this.suppliers.get(any.getType().getKey())).get()).handle(any);
                this.executor.reportHandled(any.getType().getKey(), any.getKey());
            });
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.error("Could not submit push handler for {} {}", (Object)any.getType().getKey(), (Object)any.getKey());
            return false;
        }
    }

    @Transactional(readOnly=true)
    public boolean handle(Realm realm) {
        if (this.tpte.isEmpty()) {
            boolean result = ((RealmPushResultHandler)this.nonConcurrentHandler("REALM")).handle(realm);
            this.executor.reportHandled("REALM", realm.getKey());
            return result;
        }
        try {
            this.submit(() -> {
                ((RealmPushResultHandler)((Supplier)this.suppliers.get("REALM")).get()).handle(realm);
                this.executor.reportHandled("REALM", realm.getKey());
            });
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.error("Could not submit push handler for {} {}", (Object)"REALM", (Object)realm.getKey());
            return false;
        }
    }
}

