/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.springframework.data.domain.Pageable;

public interface RealmSearchDAO {
    public Optional<Realm> findByFullPath(String var1);

    public List<Realm> findByName(String var1);

    public List<Realm> findChildren(Realm var1);

    public long countDescendants(String var1, String var2);

    public long countDescendants(Set<String> var1, String var2);

    public List<Realm> findDescendants(String var1, String var2, Pageable var3);

    public List<Realm> findDescendants(Set<String> var1, String var2, Pageable var3);

    public List<String> findDescendants(String var1, String var2);

    default public void findAncestors(List<Realm> result, Realm realm) {
        if (realm.getParent() != null && !result.contains(realm.getParent())) {
            result.add(realm.getParent());
            this.findAncestors(result, realm.getParent());
        }
    }

    default public List<Realm> findAncestors(Realm realm) {
        ArrayList<Realm> result = new ArrayList<Realm>();
        result.add(realm);
        this.findAncestors(result, realm);
        return result;
    }
}

