/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.utils.RealmUtils;
import org.apache.syncope.core.persistence.common.dao.AnyFinder;
import org.apache.syncope.core.persistence.jpa.dao.repo.AbstractAnyRepoExt;
import org.apache.syncope.core.persistence.jpa.dao.repo.AnyObjectRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAARelationship;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAURelationship;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class AnyObjectRepoExtImpl
extends AbstractAnyRepoExt<AnyObject>
implements AnyObjectRepoExt {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;

    public AnyObjectRepoExtImpl(AnyUtilsFactory anyUtilsFactory, PlainSchemaDAO plainSchemaDAO, UserDAO userDAO, GroupDAO groupDAO, EntityManager entityManager, AnyFinder anyFinder) {
        super(plainSchemaDAO, entityManager, anyFinder, anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT));
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
    }

    @Override
    public Map<String, Long> countByType() {
        Query query = this.entityManager.createNativeQuery("SELECT e.type_id, COUNT(e.id) FROM AnyObject e GROUP BY e.type_id");
        List results = query.getResultList();
        LinkedHashMap countByRealm = new LinkedHashMap(results.size());
        results.forEach(result -> countByRealm.put(result[0].toString(), ((Number)result[1]).longValue()));
        return Collections.unmodifiableMap(countByRealm);
    }

    @Override
    public Map<String, Long> countByRealm(String anyType) {
        Query query = this.entityManager.createNativeQuery("SELECT r.fullPath, COUNT(e.id) FROM AnyObject e JOIN Realm r ON e.realm_id=r.id WHERE e.type_id=? GROUP BY r.fullPath");
        query.setParameter(1, (Object)anyType);
        List results = query.getResultList();
        return results.stream().collect(Collectors.toMap(result -> result[0].toString(), result -> ((Number)result[1]).longValue()));
    }

    @Override
    @Transactional(readOnly=true)
    public void securityChecks(Set<String> authRealms, String key, String realm, Collection<String> groups) {
        boolean authorized = authRealms.stream().map(authRealm -> RealmUtils.ManagerRealm.of((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(managerRealm -> key.equals(managerRealm.anyKey()));
        if (!authorized) {
            authorized = authRealms.stream().map(authRealm -> RealmUtils.ManagerRealm.of((String)authRealm).orElse(null)).filter(Objects::nonNull).anyMatch(managerRealm -> groups.contains(managerRealm.anyKey()));
        }
        if (!authorized) {
            authorized = authRealms.stream().anyMatch(realm::startsWith);
        }
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, AnyTypeKind.ANY_OBJECT.name(), key);
        }
    }

    @Override
    protected void securityChecks(AnyObject anyObject) {
        Set<String> authRealms = AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.READ.getFor(anyObject.getType().getKey()), Set.of());
        this.securityChecks(authRealms, anyObject.getKey(), anyObject.getRealm().getFullPath(), this.findAllGroupKeys(anyObject));
    }

    @Override
    public void deleteMembership(AMembership membership) {
        this.entityManager.remove((Object)membership);
    }

    @Override
    public List<Relationship<Any, AnyObject>> findAllRelationships(AnyObject anyObject) {
        ArrayList<Relationship<Any, AnyObject>> result = new ArrayList<Relationship<Any, AnyObject>>();
        TypedQuery aquery = (TypedQuery)this.entityManager.createQuery("SELECT e FROM " + JPAARelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject OR e.leftEnd=:anyObject");
        aquery.setParameter("anyObject", (Object)anyObject);
        result.addAll(aquery.getResultList());
        TypedQuery uquery = (TypedQuery)this.entityManager.createQuery("SELECT e FROM " + JPAURelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject");
        uquery.setParameter("anyObject", (Object)anyObject);
        result.addAll(uquery.getResultList());
        return result;
    }

    @Override
    public <S extends AnyObject> S save(S anyObject) {
        this.checkBeforeSave((JPAAnyObject)anyObject);
        AnyObject merged = (AnyObject)this.entityManager.merge(anyObject);
        this.entityManager.flush();
        return (S)merged;
    }

    protected List<ARelationship> findARelationships(AnyObject anyObject) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAARelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject", ARelationship.class);
        query.setParameter("anyObject", (Object)anyObject);
        return query.getResultList();
    }

    protected List<URelationship> findURelationships(AnyObject anyObject) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAURelationship.class.getSimpleName() + " e WHERE e.rightEnd=:anyObject", URelationship.class);
        query.setParameter("anyObject", (Object)anyObject);
        return query.getResultList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<Group> findAllGroups(AnyObject anyObject) {
        return anyObject.getMemberships().stream().map(Relationship::getRightEnd).collect(Collectors.toSet());
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<String> findAllGroupKeys(AnyObject anyObject) {
        return this.findAllGroups(anyObject).stream().map(Entity::getKey).toList();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, readOnly=true)
    public Collection<ExternalResource> findAllResources(AnyObject anyObject) {
        HashSet<ExternalResource> result = new HashSet<ExternalResource>();
        result.addAll(anyObject.getResources());
        this.findAllGroups(anyObject).forEach(group -> result.addAll(group.getResources()));
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public Collection<String> findAllResourceKeys(String key) {
        return this.findAllResources((AnyObject)this.authFind(key)).stream().map(Entity::getKey).toList();
    }

    @Override
    public void delete(AnyObject anyObject) {
        this.findARelationships(anyObject).forEach(relationship -> {
            ((AnyObject)relationship.getLeftEnd()).remove((Relationship)relationship);
            this.save((AnyObject)relationship.getLeftEnd());
            this.entityManager.remove(relationship);
        });
        this.findURelationships(anyObject).forEach(relationship -> {
            ((User)relationship.getLeftEnd()).remove((Relationship)relationship);
            this.userDAO.save((Entity)((User)relationship.getLeftEnd()));
            this.entityManager.remove(relationship);
        });
        this.entityManager.remove((Object)anyObject);
    }
}

