/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.bypass;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public abstract class BaseMultifactorAuthenticationProviderBypassEvaluator
implements MultifactorAuthenticationProviderBypassEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseMultifactorAuthenticationProviderBypassEvaluator.class);
    private static final long serialVersionUID = 2372899636154131393L;
    private final String providerId;
    private final String id = this.getClass().getSimpleName();
    private final ApplicationContext applicationContext;

    protected static boolean locateMatchingAttributeValue(String attrName, Set<String> attrValue, Map<String, List<Object>> attributes, boolean matchIfNoValueProvided) {
        LOGGER.debug("Locating matching attribute [{}] with value [{}] amongst the attribute collection [{}]", new Object[]{attrName, attrValue, attributes});
        if (StringUtils.isBlank((CharSequence)attrName)) {
            LOGGER.debug("Failed to match since attribute name is undefined");
            return false;
        }
        Map<String, List<Object>> names = BaseMultifactorAuthenticationProviderBypassEvaluator.locateMatchingAttributeName(attributes, attrName);
        if (names.isEmpty()) {
            return false;
        }
        if (attrValue == null || attrValue.isEmpty()) {
            LOGGER.debug("No attribute value to match is provided; Match result is set to [{}]", (Object)matchIfNoValueProvided);
            return matchIfNoValueProvided;
        }
        Set values = names.entrySet().stream().filter(e -> {
            Set allValues = CollectionUtils.toCollection(e.getValue());
            LOGGER.debug("Matching attribute [{}] with values [{}] against [{}]", new Object[]{e.getKey(), allValues, attrValue});
            return RegexUtils.findFirst((Collection)attrValue, (Collection)allValues).isPresent();
        }).collect(Collectors.toSet());
        LOGGER.debug("Matching attribute values remaining are [{}]", values);
        return !values.isEmpty();
    }

    protected static Map<String, List<Object>> locateMatchingAttributeName(Map<String, List<Object>> attributes, String attrName) {
        Map<String, List<Object>> names = attributes.entrySet().stream().filter(e -> {
            LOGGER.debug("Attempting to match [{}] against [{}]", (Object)attrName, e.getKey());
            return RegexUtils.find((String)attrName, (String)((String)e.getKey()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LOGGER.debug("Found [{}] attributes relevant for multifactor authentication bypass", (Object)names.size());
        return names;
    }

    @Audit(action="MULTIFACTOR_AUTHENTICATION_BYPASS_EVALUATION", actionResolverName="MULTIFACTOR_AUTHENTICATION_BYPASS_ACTION_RESOLVER", resourceResolverName="MULTIFACTOR_AUTHENTICATION_BYPASS_RESOURCE_RESOLVER")
    public boolean shouldMultifactorAuthenticationProviderExecute(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request, Service service) {
        return this.shouldMultifactorAuthenticationProviderExecuteInternal(authentication, registeredService, provider, request);
    }

    public boolean isMultifactorAuthenticationBypassed(Authentication authentication, String requestedContext) {
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey("bypassMultifactorAuthentication")) {
            Boolean bypass;
            Optional result = CollectionUtils.firstElement(attributes.get("bypassMultifactorAuthentication"));
            Optional providerRes = CollectionUtils.firstElement(attributes.get("bypassedMultifactorAuthenticationProviderId"));
            if (result.isPresent() && (bypass = (Boolean)result.get()).booleanValue() && providerRes.isPresent()) {
                String provider = providerRes.get().toString();
                return Strings.CI.equals(requestedContext, provider);
            }
        }
        return false;
    }

    public void forgetBypass(Authentication authentication) {
        authentication.addAttribute("bypassMultifactorAuthentication", (Object)Boolean.FALSE);
    }

    public void rememberBypass(Authentication authentication, MultifactorAuthenticationProvider provider) {
        authentication.addAttribute("bypassMultifactorAuthentication", (Object)Boolean.TRUE);
        authentication.addAttribute("bypassedMultifactorAuthenticationProviderId", (Object)provider.getId());
    }

    public Optional<MultifactorAuthenticationProviderBypassEvaluator> belongsToMultifactorAuthenticationProvider(String providerId) {
        if (this.getProviderId().equalsIgnoreCase(providerId)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    protected abstract boolean shouldMultifactorAuthenticationProviderExecuteInternal(Authentication var1, RegisteredService var2, MultifactorAuthenticationProvider var3, HttpServletRequest var4);

    protected Principal resolvePrincipal(Principal principal) {
        ArrayList resolvers = new ArrayList(this.applicationContext.getBeansOfType(MultifactorAuthenticationPrincipalResolver.class).values());
        AnnotationAwareOrderComparator.sort(resolvers);
        return resolvers.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }

    @Generated
    public String getProviderId() {
        return this.providerId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    protected BaseMultifactorAuthenticationProviderBypassEvaluator(String providerId, ApplicationContext applicationContext) {
        this.providerId = providerId;
        this.applicationContext = applicationContext;
    }

    @Generated
    public String toString() {
        return "BaseMultifactorAuthenticationProviderBypassEvaluator(providerId=" + this.providerId + ", id=" + this.id + ", applicationContext=" + String.valueOf(this.applicationContext) + ")";
    }
}

