/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.indy;

import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.Label;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class InvokeDynamicWriter
extends InvocationWriter {
    private static final String BSM_DESCRIPTOR = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE).toMethodDescriptorString();
    private static final Handle BSM = new Handle(6, IndyInterface.class.getName().replace('.', '/'), "bootstrap", BSM_DESCRIPTOR, false);
    private static final Object[] CAST_ARGS = new Object[]{"()", 0};

    public InvokeDynamicWriter(WriterController controller) {
        super(controller);
    }

    @Override
    protected boolean makeCachedCall(Expression origin, ClassExpression sender, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis, boolean containsSpreadExpression) {
        String methodName;
        if (!(spreadSafe || adapter != null && adapter != invokeMethod && adapter != invokeMethodOnCurrent && adapter != invokeStaticMethod || (methodName = this.getMethodName(message)) == null)) {
            this.makeIndyCall(adapter, receiver, implicitThis, safe, methodName, arguments);
            return true;
        }
        return false;
    }

    private String prepareIndyCall(Expression receiver, boolean implicitThis) {
        CompileStack compileStack = this.controller.getCompileStack();
        OperandStack operandStack = this.controller.getOperandStack();
        compileStack.pushLHS(false);
        compileStack.pushImplicitThis(implicitThis);
        receiver.visit(this.controller.getAcg());
        compileStack.popImplicitThis();
        return "(" + BytecodeHelper.getTypeDescription(operandStack.getTopOperand());
    }

    private void finishIndyCall(Handle bsmHandle, String methodName, String sig, int numberOfArguments, Object ... bsmArgs) {
        CompileStack compileStack = this.controller.getCompileStack();
        OperandStack operandStack = this.controller.getOperandStack();
        this.controller.getMethodVisitor().visitInvokeDynamicInsn(methodName, sig, bsmHandle, bsmArgs);
        operandStack.replace(ClassHelper.OBJECT_TYPE, numberOfArguments);
        compileStack.popLHS();
    }

    private void makeIndyCall(MethodCallerMultiAdapter adapter, Expression origReceiver, boolean implicitThis, boolean safe, String methodName, Expression arguments) {
        OperandStack operandStack = this.controller.getOperandStack();
        Expression receiver = this.correctReceiverForInterfaceCall(origReceiver);
        StringBuilder sig = new StringBuilder(this.prepareIndyCall(receiver, implicitThis));
        Label end = null;
        if (safe && !ClassHelper.isPrimitiveType(operandStack.getTopOperand())) {
            operandStack.dup();
            end = operandStack.jump(198);
        }
        int numberOfArguments = 1;
        List<Expression> args = InvokeDynamicWriter.makeArgumentList(arguments).getExpressions();
        boolean containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments);
        AsmClassGenerator acg = this.controller.getAcg();
        if (containsSpreadExpression) {
            acg.despreadList(args, true);
            sig.append(BytecodeHelper.getTypeDescription(Object[].class));
        } else {
            for (Expression arg : args) {
                arg.visit(acg);
                if (arg instanceof CastExpression) {
                    operandStack.box();
                    acg.loadWrapper(arg);
                    sig.append(BytecodeHelper.getTypeDescription(Wrapper.class));
                } else {
                    sig.append(BytecodeHelper.getTypeDescription(operandStack.getTopOperand()));
                }
                ++numberOfArguments;
            }
        }
        sig.append(")Ljava/lang/Object;");
        String callSiteName = IndyInterface.CallType.METHOD.getCallSiteName();
        if (adapter == null) {
            callSiteName = IndyInterface.CallType.INIT.getCallSiteName();
        }
        if (receiver != origReceiver) {
            callSiteName = IndyInterface.CallType.INTERFACE.getCallSiteName();
        }
        int flags = InvokeDynamicWriter.getMethodCallFlags(adapter, false, containsSpreadExpression);
        this.finishIndyCall(BSM, callSiteName, sig.toString(), numberOfArguments, methodName, flags);
        if (end != null) {
            this.controller.getMethodVisitor().visitLabel(end);
        }
    }

    private Expression correctReceiverForInterfaceCall(Expression receiver) {
        PropertyExpression pexp;
        if (receiver instanceof PropertyExpression && (pexp = (PropertyExpression)receiver).getObjectExpression() instanceof ClassExpression && pexp.getProperty() instanceof ConstantExpression) {
            String name = pexp.getProperty().getText();
            ClassNode type = pexp.getObjectExpression().getType();
            if ((name.equals("this") || name.equals("super")) && type.isInterface()) {
                return GeneralUtils.bytecodeX(type, mv -> mv.visitIntInsn(25, 0));
            }
        }
        return receiver;
    }

    private static int getMethodCallFlags(MethodCallerMultiAdapter adapter, boolean safe, boolean spread) {
        int flags = 0;
        if (safe) {
            flags |= 1;
        }
        if (spread) {
            flags |= 0x10;
        }
        if (adapter == invokeMethodOnCurrent) {
            flags |= 2;
        }
        return flags;
    }

    @Override
    public void makeSingleArgumentCall(Expression receiver, String message, Expression arguments, boolean safe) {
        this.makeIndyCall(invokeMethod, receiver, false, safe, message, arguments);
    }

    protected void writeGetProperty(Expression receiver, String propertyName, boolean safe, boolean implicitThis, boolean groovyObject) {
        String descriptor = this.prepareIndyCall(receiver, implicitThis) + ")Ljava/lang/Object;";
        int flags = 0;
        if (safe) {
            flags |= 1;
        }
        if (groovyObject) {
            flags |= 4;
        }
        if (implicitThis) {
            flags |= 8;
        } else if (ExpressionUtils.isThisExpression(receiver)) {
            flags |= 2;
        }
        this.finishIndyCall(BSM, IndyInterface.CallType.GET.getCallSiteName(), descriptor, 1, propertyName, flags);
    }

    @Override
    protected void writeNormalConstructorCall(ConstructorCallExpression call) {
        this.makeCall(call, new ClassExpression(call.getType()), new ConstantExpression("<init>"), call.getArguments(), null, false, false, false);
    }

    @Override
    public void coerce(ClassNode from, ClassNode target) {
        ClassNode wrapper = ClassHelper.getWrapper(target);
        this.makeIndyCall(invokeMethod, EmptyExpression.INSTANCE, false, false, "asType", new ClassExpression(wrapper));
        if (ClassHelper.isPrimitiveBoolean(target) || ClassHelper.isWrapperBoolean(target)) {
            this.writeIndyCast(ClassHelper.OBJECT_TYPE, target);
        } else {
            BytecodeHelper.doCast(this.controller.getMethodVisitor(), wrapper);
            this.controller.getOperandStack().replace(wrapper);
            this.controller.getOperandStack().doGroovyCast(target);
        }
    }

    @Override
    public void castToNonPrimitiveIfNecessary(ClassNode sourceType, ClassNode targetType) {
        if (WideningCategories.implementsInterfaceOrSubclassOf(ClassHelper.getWrapper(sourceType), targetType)) {
            this.controller.getOperandStack().box();
        } else {
            this.writeIndyCast(sourceType, targetType);
        }
    }

    @Override
    public void castNonPrimitiveToBool(ClassNode sourceType) {
        this.writeIndyCast(sourceType, ClassHelper.boolean_TYPE);
    }

    private void writeIndyCast(ClassNode sourceType, ClassNode targetType) {
        String descriptor = "(" + BytecodeHelper.getTypeDescription(sourceType) + ")" + BytecodeHelper.getTypeDescription(targetType);
        this.controller.getMethodVisitor().visitInvokeDynamicInsn(IndyInterface.CallType.CAST.getCallSiteName(), descriptor, BSM, CAST_ARGS);
        this.controller.getOperandStack().replace(targetType);
    }
}

