/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.serializer.fast2;

import com.giffing.wicket.spring.boot.context.exceptions.extensions.ExtensionMisconfigurationException;
import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.external.development.springboot.devtools.SpringDevtoolsSerializerConfig;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.serializer.fast2.WicketSerializerFast2Properties;
import lombok.Generated;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.serialize.java.JavaSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.wicketstuff.pageserializer.fast2.Fast2WicketSerializer;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.serializer.fast2", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Fast2WicketSerializer.class})
@EnableConfigurationProperties(value={WicketSerializerFast2Properties.class})
@ConditionalOnMissingBean(value={SpringDevtoolsSerializerConfig.class})
public class WicketSerializerFast2Config
implements WicketApplicationInitConfiguration {
    private final WicketSerializerFast2Properties props;
    private final WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        ISerializer currentSerializer = webApplication.getFrameworkSettings().getSerializer();
        if (!currentSerializer.getClass().equals(JavaSerializer.class)) {
            throw new ExtensionMisconfigurationException("Fast2Config: There is already another serializer configured " + String.valueOf(currentSerializer));
        }
        webApplication.getFrameworkSettings().setSerializer((ISerializer)new Fast2WicketSerializer());
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.props).build());
    }

    @Generated
    public WicketSerializerFast2Config(WicketSerializerFast2Properties props, WicketEndpointRepository wicketEndpointRepository) {
        this.props = props;
        this.wicketEndpointRepository = wicketEndpointRepository;
    }
}

