/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.shiro;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.scan.WicketAccessDeniedPage;
import com.giffing.wicket.spring.boot.context.scan.WicketSignInPage;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.shiro.ShiroSecurityProperties;
import lombok.Generated;
import org.apache.shiro.spring.boot.autoconfigure.ShiroAutoConfiguration;
import org.apache.shiro.spring.web.config.DefaultShiroFilterChainDefinition;
import org.apache.shiro.spring.web.config.ShiroFilterChainDefinition;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.wicketstuff.shiro.annotation.AnnotationsShiroAuthorizationStrategy;
import org.wicketstuff.shiro.authz.ShiroUnauthorizedComponentListener;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.restannotations", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AnnotationsShiroAuthorizationStrategy.class, ShiroAutoConfiguration.class})
@EnableConfigurationProperties(value={ShiroSecurityProperties.class})
public class ShiroSecurityConfig
implements WicketApplicationInitConfiguration {
    private final WicketClassCandidatesHolder classCandidates;

    @Bean
    ShiroFilterChainDefinition shiroFilterChainDefinition() {
        return new DefaultShiroFilterChainDefinition();
    }

    public void init(WebApplication webApplication) {
        AnnotationsShiroAuthorizationStrategy authz = new AnnotationsShiroAuthorizationStrategy();
        webApplication.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)authz);
        if (this.classCandidates.getSignInPageCandidates().isEmpty()) {
            throw new IllegalStateException("Couln't find sign in page - please annotate the sign in page with @" + WicketSignInPage.class.getName());
        }
        if (this.classCandidates.getAccessDeniedPageCandidates().isEmpty()) {
            throw new IllegalStateException("Couln't find access denied in page - please annotate the sign in page with @" + WicketAccessDeniedPage.class.getName());
        }
        Class<WebPage> signInPage = this.classCandidates.getSignInPageCandidates().iterator().next().getCandidate();
        Class<Page> accessDeniedPage = this.classCandidates.getAccessDeniedPageCandidates().iterator().next().getCandidate();
        webApplication.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)new ShiroUnauthorizedComponentListener(signInPage, accessDeniedPage, authz));
    }

    @Generated
    public ShiroSecurityConfig(WicketClassCandidatesHolder classCandidates) {
        this.classCandidates = classCandidates;
    }
}

