/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.generator;

import java.util.Optional;
import org.apache.commons.lang3.Strings;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.springframework.core.io.Resource;

@FunctionalInterface
public interface SamlIdPMetadataGenerator {
    public static final String BEAN_NAME = "samlIdPMetadataGenerator";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    public SamlIdPMetadataDocument generate(Optional<SamlRegisteredService> var1) throws Throwable;

    public static String cleanCertificate(String cert) {
        String result = Strings.CI.remove(cert, BEGIN_CERTIFICATE);
        result = Strings.CI.remove(result, END_CERTIFICATE).trim();
        return result;
    }

    default public String getAppliesToFor(Optional<SamlRegisteredService> result) {
        return SamlIdPUtils.getSamlIdPMetadataOwner(result);
    }

    public record CertificateAndKey(Resource certificate, Resource key) {
    }
}

