/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.log.LocalLog$;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLogTest$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.SegmentPosition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.compress.NoCompression;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.record.ArbitraryMemoryRecords;
import org.apache.kafka.common.record.InvalidMemoryRecordsProvider;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.raft.internals.BatchBuilder;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\r\rg\u0001B%K\u0005=CQA\u0016\u0001\u0005\u0002]C\u0011B\u0017\u0001A\u0002\u0003\u0007I\u0011A.\t\u0013\u0011\u0004\u0001\u0019!a\u0001\n\u0003)\u0007\"C6\u0001\u0001\u0004\u0005\t\u0015)\u0003]\u0011\u001da\u0007A1A\u0005\u00025Daa\u001f\u0001!\u0002\u0013q\u0007\"\u0002?\u0001\t\u0003i\bBBA\n\u0001\u0011\u0005Q\u0010\u0003\u0004\u0002\u001e\u0001!\t! \u0005\u0007\u0003O\u0001A\u0011A?\t\r\u0005-\u0002\u0001\"\u0001~\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a)\u0001\t\u0003\t)\u000b\u0003\u0004\u0002`\u0002!\t! \u0005\u0007\u0003G\u0004A\u0011A?\t\r\u0005\u001d\b\u0001\"\u0001~\u0011\u0019\tY\u000f\u0001C\u0001{\"1\u0011q\u001e\u0001\u0005\u0002uDa!a=\u0001\t\u0003i\bBBA|\u0001\u0011\u0005Q\u0010\u0003\u0004\u0002|\u0002!\t! \u0005\u0007\u0003\u007f\u0004A\u0011A?\t\r\t\r\u0001\u0001\"\u0001~\u0011\u0019\u00119\u0001\u0001C\u0001{\"1!1\u0002\u0001\u0005\u0002uDaAa\u0004\u0001\t\u0003i\bB\u0002B\n\u0001\u0011\u0005Q\u0010\u0003\u0004\u0003\u0018\u0001!\t! \u0005\u0007\u00057\u0001A\u0011A?\t\r\t}\u0001\u0001\"\u0001~\u0011\u0019\u0011\u0019\u0003\u0001C\u0001{\"9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\u0007\u0005\u000b\u0002A\u0011A?\t\r\t%\u0003\u0001\"\u0001~\u0011\u0019\u0011i\u0005\u0001C\u0001{\"1!\u0011\u000b\u0001\u0005\u0002uDaA!\u0016\u0001\t\u0003i\bB\u0002B-\u0001\u0011\u0005Q\u0010C\u0004\u0003^\u0001!IAa\u0018\t\r\tM\u0004\u0001\"\u0001~\u0011\u0019\u00119\b\u0001C\u0001{\"1!1\u0010\u0001\u0005\u0002uDaAa \u0001\t\u0003i\bB\u0002BB\u0001\u0011\u0005Q\u0010\u0003\u0004\u0003\b\u0002!\t! \u0005\u0007\u0005\u0017\u0003A\u0011A?\t\r\t=\u0005\u0001\"\u0001~\u0011\u0019\u0011\u0019\n\u0001C\u0001{\"1!q\u0013\u0001\u0005\u0002uDaAa'\u0001\t\u0003i\bB\u0002BP\u0001\u0011\u0005Q\u0010\u0003\u0004\u0003$\u0002!\t!`\u0004\b\u0005OS\u0005\u0012\u0001BU\r\u0019I%\n#\u0001\u0003,\"1ak\u000eC\u0001\u0005[3aAa,8\u0001\tE\u0006B\u0002,:\t\u0003\u0011I\u000eC\u0004\u0003ne\"\tEa8\t\u000f\tU\u0018\b\"\u0011\u0003x\"91qA\u001d\u0005B\r%\u0001\"CB\ro\t\u0007I\u0011AB\u000e\u0011!\u0019\u0019c\u000eQ\u0001\n\ru\u0001bBB\u0013o\u0011\u00051q\u0005\u0005\n\u0007\u001f:\u0014\u0013!C\u0001\u0007#Bqaa\u001a8\t\u0003\u0019I\u0007C\u0005\u0004r]\n\n\u0011\"\u0001\u0004R!911O\u001c\u0005\u0002\rU\u0004bBB?o\u0011\u00051q\u0010\u0005\b\u0007\u000b;D\u0011ABD\u0011\u001d\u0019)i\u000eC\u0001\u0007?Cqaa-8\t\u0013\u0019)L\u0001\u000bLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pOR+7\u000f\u001e\u0006\u0003\u00172\u000bAA]1gi*\tQ*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021B\u0011\u0011\fA\u0007\u0002\u0015\u00069A/Z7q\t&\u0014X#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017AA5p\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\t\u0019KG.Z\u0001\fi\u0016l\u0007\u000fR5s?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0011kZ\u0005\u0003QJ\u0013A!\u00168ji\"9!nAA\u0001\u0002\u0004a\u0016a\u0001=%c\u0005AA/Z7q\t&\u0014\b%\u0001\u0005n_\u000e\\G+[7f+\u0005q\u0007CA8z\u001b\u0005\u0001(BA9s\u0003\u0011)H/\u001b7\u000b\u0005M$\u0018AB:feZ,'O\u0003\u0002Nk*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ\bO\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0003tKR,\u0006\u000fF\u0001gQ\t9q\u0010\u0005\u0003\u0002\u0002\u0005=QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\n\u0005-\u0011a\u00026va&$XM\u001d\u0006\u0004\u0003\u001b9\u0018!\u00026v]&$\u0018\u0002BA\t\u0003\u0007\u0011!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\u0005\u0002\u0018A!\u0011\u0011AA\r\u0013\u0011\tY\"a\u0001\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0003;fgR\u001cuN\u001c4jO\"\u001a\u0011\"!\t\u0011\t\u0005\u0005\u00111E\u0005\u0005\u0003K\t\u0019A\u0001\u0003UKN$\u0018A\u0007;fgR,f.\u001a=qK\u000e$X\rZ!qa\u0016tGm\u00144gg\u0016$\bf\u0001\u0006\u0002\"\u0005IB/Z:u\u000b6\u0004H/_!qa\u0016tGMT8u\u00032dwn^3eQ\rY\u0011\u0011E\u0001\u0019i\u0016\u001cH/\u00138wC2LG-T3n_JL(+Z2pe\u0012\u001cH#\u00024\u00024\u0005\u001d\u0003bBA\u001b\u0019\u0001\u0007\u0011qG\u0001\be\u0016\u001cwN\u001d3t!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\taA]3d_J$'bAA!i\u000611m\\7n_:LA!!\u0012\u0002<\tiQ*Z7pef\u0014VmY8sINDq!!\u0013\r\u0001\u0004\tY%A\tfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:\u0004b!!\u0014\u0002R\u0005USBAA(\u0015\t\t\b-\u0003\u0003\u0002T\u0005=#\u0001C(qi&|g.\u00197\u0011\r\u0005]\u0013QMA6\u001d\u0011\tI&!\u0019\u0011\u0007\u0005m#+\u0004\u0002\u0002^)\u0019\u0011q\f(\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019GU\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0006\u00072\f7o\u001d\u0006\u0004\u0003G\u0012\u0006\u0003BA7\u0003orA!a\u001c\u0002t9!\u00111LA9\u0013\u0005\u0019\u0016bAA;%\u00069\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005U$\u000bK\u0002\r\u0003\u007f\u0002B!!!\u0002\b6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9!\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u0013\u000b\u0019IA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs\u0001DAG\u00033\u000bY\n\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*a!\u0002\u0011A\u0014xN^5eKJLA!a&\u0002\u0012\ny\u0011I]4v[\u0016tGo]*pkJ\u001cW-A\u0003wC2,Xm\t\u0002\u0002\u001eB!\u0011\u0011HAP\u0013\u0011\t\t+a\u000f\u00039%sg/\u00197jI6+Wn\u001c:z%\u0016\u001cwN\u001d3t!J|g/\u001b3fe\u0006\tB/Z:u%\u0006tGm\\7SK\u000e|'\u000fZ:\u0015\u0007\u0019\f9\u000bC\u0004\u000265\u0001\r!a\u000e)\u0011\u0005\u001d\u00161VA_\u0003\u007f\u0003B!!,\u0002:6\u0011\u0011q\u0016\u0006\u0005\u0003\u000b\t\tL\u0003\u0003\u00024\u0006U\u0016!\u00026ro&\\'BAA\\\u0003\rqW\r^\u0005\u0005\u0003w\u000byK\u0001\u0004G_J\fE\u000e\\\u0001\tgV\u0004\b\u000f\\5fe\u000e\u0012\u0011\u0011\u0019\t\u0005\u0003s\t\u0019-\u0003\u0003\u0002F\u0006m\"AF!sE&$(/\u0019:z\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u00175\tI-a4\u0002R\u0006M\u0017Q\u001b\t\u0005\u0003[\u000bY-\u0003\u0003\u0002N\u0006=&\u0001\u0003)s_B,'\u000f^=\u0002\u000bQ\u0014\u0018.Z:\u001e\u0003\u0011\fA\"\u00194uKJ4\u0015-\u001b7ve\u0016$#!a6\n\t\u0005e\u00171\\\u0001\f'\u0006k\u0005\u000bT#`\u001f:c\u0015L\u0003\u0003\u0002^\u0006=\u0016\u0001E!gi\u0016\u0014h)Y5mkJ,Wj\u001c3f\u0003Y!Xm\u001d;J]Z\fG.\u001b3MK\u0006$WM]#q_\u000eD\u0007f\u0001\b\u0002\"\u0005\u0011B/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8uQ\ry\u0011\u0011E\u0001 i\u0016\u001cHo\u0011:fCR,7K\\1qg\"|GO\u0012:p[\u0016sGm\u00144gg\u0016$\bf\u0001\t\u0002\"\u0005AC/Z:u\u0007J,\u0017\r^3T]\u0006\u00048\u000f[8u\u0019\u0006$XM\u001d+iC:D\u0015n\u001a5XCR,'/\\1sW\"\u001a\u0011#!\t\u0002AQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^'vG\"d\u0015\r^3s\u000bB|7\r\u001b\u0015\u0004%\u0005\u0005\u0012a\b;fgRD\u0015n\u001a5XCR,'/\\1sW>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u001a1#!\t\u0002MQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e\u001e\"fM>\u0014X\rT8h'R\f'\u000f^(gMN,G\u000fK\u0002\u0015\u0003C\t\u0001\u0005^3ti\u000e\u0013X-\u0019;f':\f\u0007o\u001d5pi\u0012Kg/\u001a:hS:<W\t]8dQ\"\u001aQ#!\t\u00029Q,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^(mI\u0016\u0014X\t]8dQ\"\u001aa#!\t\u0002EQ,7\u000f^\"sK\u0006$Xm\u00158baNDw\u000e^,ji\"l\u0015n]:j]\u001e,\u0005o\\2iQ\r9\u0012\u0011E\u0001\u001bi\u0016\u001cHo\u0011:fCR,W\t_5ti&twm\u00158baNDw\u000e\u001e\u0015\u00041\u0005\u0005\u0012a\u0003;fgR$v\u000e]5d\u0013\u0012D3!GA\u0011\u0003]!Xm\u001d;SK\u0006$W*[:tS:<7K\\1qg\"|G\u000fK\u0002\u001b\u0003C\tQ\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti\u0016tGo\u00158baNDw\u000e\u001e\u0015\u00047\u0005\u0005\u0012!\t;fgR$&/\u001e8dCR,g)\u001e7msR{G*\u0019;fgR\u001cf.\u00199tQ>$\bf\u0001\u000f\u0002\"\u0005\u0019C/Z:u)J,hnY1uK^KG\u000e\u001c*f[>4Xm\u00147eKJ\u001cf.\u00199tQ>$\bfA\u000f\u0002\"\u0005\u0019C/Z:u'R\f'\u000f^;q/&$\b.\u00138wC2LGm\u00158baNDw\u000e^*uCR,\u0007f\u0001\u0010\u0002\"\u0005aC/Z:u':\f\u0007o\u001d5pi\u0012+G.\u001a;j_:<\u0016\u000e\u001e5J]Z\fG.\u001b3T]\u0006\u00048\u000f[8u'R\fG/\u001a\u0015\u0004?\u0005\u0005\u0012AD7fi\u0006$\u0017\r^1M_\u001e$\u0015N\u001d\u000b\u00049\n-\u0002B\u0002B\u0017A\u0001\u0007A,\u0001\u0004m_\u001e$\u0015N]\u0001\u0013oJLG/Z#naRL8K\\1qg\"|G\u000fF\u0003g\u0005g\u00119\u0004\u0003\u0004\u00036\u0005\u0002\r\u0001X\u0001\f[\u0016$\u0018\rZ1uC\u0012K'\u000fC\u0004\u0003:\u0005\u0002\rAa\u000f\u0002\u0015Mt\u0017\r]:i_RLE\r\u0005\u0003\u0003>\t\u0005SB\u0001B \u0015\tYE/\u0003\u0003\u0003D\t}\"AD(gMN,G/\u00118e\u000bB|7\r[\u0001\u0018i\u0016\u001cH\u000fR8fg:$HK];oG\u0006$XMR;mYfD3AIA\u0011\u0003m!Xm\u001d;DY\u0016\fg.\u001e9QCJ$\u0018.\u00197T]\u0006\u00048\u000f[8ug\"\u001a1%!\t\u00023Q,7\u000f^\"mK\u0006tW\u000f](mI\u0016\u00148K\\1qg\"|Go\u001d\u0015\u0004I\u0005\u0005\u0012!\n;fgR\u001c%/Z1uKJ+\u0007\u000f\\5dCR,G\rT8h)J,hnY1uKN4U\u000f\u001c7zQ\r)\u0013\u0011E\u0001\u0011i\u0016\u001cH/T1y\u0005\u0006$8\r[*ju\u0016D3AJA\u0011\u0003y!Xm\u001d;UeVt7-\u0019;f\u0005\u0016dwn\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000eK\u0002(\u0003C\taBY;jY\u00124U\u000f\u001c7CCR\u001c\u0007\u000e\u0006\u0005\u00028\t\u0005$1\u000eB8\u0011\u001d\u0011\u0019\u0007\u000ba\u0001\u0005K\n1\u0002\\3bI\u0016\u0014X\t]8dQB\u0019\u0011Ka\u001a\n\u0007\t%$KA\u0002J]RDqA!\u001c)\u0001\u0004\u0011)'\u0001\u0006sK\u000e|'\u000fZ*ju\u0016DqA!\u001d)\u0001\u0004\u0011)'A\nnCb\u0014\u0015\r^2i'&TX-\u00138CsR,7/\u0001\u0016uKN$h+\u00197jI\u0006$X-\u00129pG\"<%/Z1uKJ$\u0006.\u00198MCN$8J\\8x]\u0016\u0003xn\u00195)\u0007%\n\t#\u0001\u0017uKN$h+\u00197jI\u0006$X-\u00129pG\"dUm]:UQ\u0006tw\n\u001c3fgR\u001cf.\u00199tQ>$X\t]8dQ\"\u001a!&!\t\u0002]Q,7\u000f\u001e,bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'fgN$\u0006.\u00198PY\u0012,7\u000f^*oCB\u001c\bn\u001c;PM\u001a\u001cX\r\u001e\u0015\u0004W\u0005\u0005\u0012!\f;fgR4\u0016\r\\5eCR,wJ\u001a4tKR,\u0015/^1m)>|E\u000eZ3tiNs\u0017\r]:i_R|eMZ:fi\"\u001aA&!\t\u0002\u0005R,7\u000f\u001e,bY&$\u0017\r^3V].twn\u001e8Fa>\u001c\u0007\u000eT3tgRC\u0017M\u001c'bgR\\en\\<o\u000fJ,\u0017\r^3s)\"\fgn\u00147eKN$8K\\1qg\"|G\u000fK\u0002.\u0003C\t\u0001\u0006^3tiZ\u000bG.\u001b3bi\u0016,\u0005o\\2i\u0019\u0016\u001c8\u000f\u00165b]\u001aK'o\u001d;Fa>\u001c\u0007.\u00138M_\u001eD3ALA\u0011\u0003\u0011\"Xm\u001d;WC2LG-\u0019;f\u001f\u001a47/\u001a;He\u0016\fG\u000f\u00165b]\u0016sGm\u00144gg\u0016$\bfA\u0018\u0002\"\u0005iB/Z:u-\u0006d\u0017\u000eZ1uK>3gm]3u\u0019\u0016\u001c8\u000f\u00165b]2+u\nK\u00021\u0003C\tq\u0004^3tiZ\u000bG.\u001b3bi\u00164\u0016\r\\5e\u000bB|7\r[!oI>3gm]3uQ\r\t\u0014\u0011E\u0001'i\u0016\u001cH/\u00113wC:\u001cW\rT8h'R\f'\u000f^(gMN,G/\u00114uKJ\u001cE.Z1oS:<\u0007f\u0001\u001a\u0002\"\u0005\u0019B/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\"\u001a1'!\t\u0002-Q,7\u000f^*pMR\u0014V\r^3oi&|g\u000eT5nSRD3\u0001NA\u0011\u0003\t\"Xm\u001d;TK\u001elWM\u001c;t\u0019\u0016\u001c8\u000f\u00165b]2\u000bG/Z:u':\f\u0007o\u001d5pi\"\u001aQ'!\t\u0002)-\u000bgm[1NKR\fG-\u0019;b\u0019><G+Z:u!\tIvg\u0005\u00028!R\u0011!\u0011\u0016\u0002\u000f\u0005f$X-\u0011:sCf\u001cVM\u001d3f'\u0015I$1\u0017B`!\u0011\u0011)La/\u000e\u0005\t]&b\u0001B]A\u0006!A.\u00198h\u0013\u0011\u0011iLa.\u0003\r=\u0013'.Z2u!\u0019\u0011\tM!3\u0003N6\u0011!1\u0019\u0006\u0005\u0005\u000b\u00149-A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0004\u0003\u0003\u0012\u0018\u0002\u0002Bf\u0005\u0007\u00141BU3d_J$7+\u001a:eKB)\u0011Ka4\u0003T&\u0019!\u0011\u001b*\u0003\u000b\u0005\u0013(/Y=\u0011\u0007E\u0013).C\u0002\u0003XJ\u0013AAQ=uKR\u0011!1\u001c\t\u0004\u0005;LT\"A\u001c\u0015\r\t\u0015$\u0011\u001dBs\u0011\u001d\u0011\u0019o\u000fa\u0001\u0005\u001b\fA\u0001Z1uC\"9!q]\u001eA\u0002\t%\u0018AE:fe&\fG.\u001b>bi&|gnQ1dQ\u0016\u0004BAa;\u0003r6\u0011!Q\u001e\u0006\u0005\u0005_\fy$\u0001\u0005qe>$xnY8m\u0013\u0011\u0011\u0019P!<\u00031=\u0013'.Z2u'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8DC\u000eDW-A\u0003xe&$X\rF\u0004g\u0005s\u0014YP!@\t\u000f\t\rH\b1\u0001\u0003N\"9!q\u001d\u001fA\u0002\t%\bb\u0002B\u0000y\u0001\u00071\u0011A\u0001\u0004_V$\b\u0003\u0002Bv\u0007\u0007IAa!\u0002\u0003n\nAqK]5uC\ndW-\u0001\u0003sK\u0006$GC\u0002Bg\u0007\u0017\u0019)\u0002C\u0004\u0004\u000eu\u0002\raa\u0004\u0002\u000b%t\u0007/\u001e;\u0011\t\t-8\u0011C\u0005\u0005\u0007'\u0011iO\u0001\u0005SK\u0006$\u0017M\u00197f\u0011\u001d\u00199\"\u0010a\u0001\u0005K\nAa]5{K\u0006AB)\u001a4bk2$X*\u001a;bI\u0006$\u0018\rT8h\u0007>tg-[4\u0016\u0005\ru\u0001cA-\u0004 %\u00191\u0011\u0005&\u0003#5+G/\u00193bi\u0006dunZ\"p]\u001aLw-A\rEK\u001a\fW\u000f\u001c;NKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\u0004\u0013A\u00062vS2$W*\u001a;bI\u0006$\u0018\rT8h\u0003:$G)\u001b:\u0015\u0011\r%2QIB$\u0007\u0017\u0002\u0012\"UB\u0016\u0007_\u0019yd!\b\n\u0007\r5\"K\u0001\u0004UkBdWm\r\t\u0005\u0007c\u0019Y$\u0004\u0002\u00044)!1QGB\u001c\u0003\u00111\u0017\u000e\\3\u000b\u0007\re\u0002-A\u0002oS>LAa!\u0010\u00044\t!\u0001+\u0019;i!\rI6\u0011I\u0005\u0004\u0007\u0007R%\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0011\u0015Q\u0006\t1\u0001]\u0011\u0019\u0019I\u0005\u0011a\u0001]\u0006!A/[7f\u0011%\u0019i\u0005\u0011I\u0001\u0002\u0004\u0019i\"A\tnKR\fG-\u0019;b\u0019><7i\u001c8gS\u001e\f\u0001EY;jY\u0012lU\r^1eCR\fGj\\4B]\u0012$\u0015N\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u000b\u0016\u0005\u0007;\u0019)f\u000b\u0002\u0004XA!1\u0011LB2\u001b\t\u0019YF\u0003\u0003\u0004^\r}\u0013!C;oG\",7m[3e\u0015\r\u0019\tGU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB3\u00077\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0005\u0004@\r-4QNB8\u0011\u0015Q&\t1\u0001]\u0011\u0019\u0019IE\u0011a\u0001]\"I1Q\n\"\u0011\u0002\u0003\u00071QD\u0001\u001bEVLG\u000eZ'fi\u0006$\u0017\r^1M_\u001e$C-\u001a4bk2$HeM\u0001\u0012GJ,\u0017\r^3OK^\u001cf.\u00199tQ>$H#\u00024\u0004x\rm\u0004bBB=\t\u0002\u00071qH\u0001\u0004Y><\u0007b\u0002B\u001d\t\u0002\u0007!1H\u0001\u001bGJ,\u0017\r^3OK^\u001cf.\u00199tQ>$XK\\2lK\u000e\\W\r\u001a\u000b\u0006M\u000e\u000551\u0011\u0005\b\u0007s*\u0005\u0019AB \u0011\u001d\u0011I$\u0012a\u0001\u0005w\ta!\u00199qK:$G\u0003CBE\u0007\u001f\u001b9ja'\u0011\t\tu21R\u0005\u0005\u0007\u001b\u0013yDA\u0007M_\u001e\f\u0005\u000f]3oI&sgm\u001c\u0005\b\u0007s2\u0005\u0019ABI!\u0011\u0011ida%\n\t\rU%q\b\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\t\u000f\ree\t1\u0001\u0003f\u0005ya.^7cKJ|eMU3d_J$7\u000fC\u0004\u0004\u001e\u001a\u0003\rA!\u001a\u0002\u000b\u0015\u0004xn\u00195\u0015\u000b\u0019\u001c\tk!-\t\u000f\r\rv\t1\u0001\u0004&\u0006q1O\\1qg\"|Go\u0016:ji\u0016\u0014\b\u0003BBT\u0007[k!a!+\u000b\u0007\r-F/\u0001\u0005t]\u0006\u00048\u000f[8u\u0013\u0011\u0019yk!+\u0003#I\u000bwo\u00158baNDw\u000e^,sSR,'\u000fC\u0004\u0004\u001a\u001e\u0003\rA!\u001a\u0002%\r\u0014X-\u0019;f\u0019><G)\u001b:fGR|'/\u001f\u000b\u00069\u000e]6\u0011\u0018\u0005\u0007\u0005[A\u0005\u0019\u0001/\t\u000f\rm\u0006\n1\u0001\u0004>\u0006QAn\\4ESJt\u0015-\\3\u0011\t\u0005]3qX\u0005\u0005\u0007\u0003\fIG\u0001\u0004TiJLgn\u001a")
public final class KafkaMetadataLogTest {
    private File tempDir;
    private final MockTime mockTime = new MockTime();

    public static void append(RawSnapshotWriter snapshotWriter, int numberOfRecords) {
        KafkaMetadataLogTest$.MODULE$.append(snapshotWriter, numberOfRecords);
    }

    public static LogAppendInfo append(ReplicatedLog log, int numberOfRecords, int epoch) {
        return KafkaMetadataLogTest$.MODULE$.append(log, numberOfRecords, epoch);
    }

    public static void createNewSnapshotUnckecked(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
    }

    public static void createNewSnapshot(KafkaMetadataLog log, OffsetAndEpoch snapshotId) {
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
    }

    public static MetadataLogConfig buildMetadataLog$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static KafkaMetadataLog buildMetadataLog(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig buildMetadataLogAndDir$default$3() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public static Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> buildMetadataLogAndDir(File tempDir, MockTime time, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(tempDir, time, metadataLogConfig);
    }

    public static MetadataLogConfig DefaultMetadataLogConfig() {
        return KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        this.tempDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tempDir());
    }

    @Test
    public void testConfig() {
        Properties props = new Properties();
        props.put("process.roles", Arrays.asList("broker"));
        props.put("controller.quorum.voters", "1@localhost:9093");
        props.put("node.id", BoxesRunTime.boxToInteger((int)2));
        props.put("controller.listener.names", "SSL");
        props.put("metadata.log.segment.bytes", BoxesRunTime.boxToInteger((int)10240));
        props.put("metadata.log.segment.ms", BoxesRunTime.boxToInteger((int)10240));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
            KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
        });
        props.put("metadata.log.segment.min.bytes", BoxesRunTime.boxToInteger((int)10240));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        MetadataLogConfig metadataConfig = MetadataLogConfig$.MODULE$.apply(kafkaConfig, 0x800000, 0x800000);
        KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), metadataConfig);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnexpectedAppendOffset() {
        void withRecords_records;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        SimpleRecord recordFoo = new SimpleRecord("foo".getBytes());
        int currentEpoch = 3;
        long initialOffset = log.endOffset().offset();
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
        NoCompression withRecords_compression = Compression.NONE;
        Object var6_6 = null;
        simpleRecordArray = null;
        log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsLeader((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            void withRecords_records;
            SimpleRecord[] simpleRecordArray = new SimpleRecord[]{recordFoo};
            NoCompression withRecords_compression = Compression.NONE;
            Object var5_5 = null;
            simpleRecordArray = null;
            log.appendAsFollower((Records)MemoryRecords.withRecords((byte)2, (long)initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)currentEpoch, (boolean)false, (SimpleRecord[])withRecords_records), currentEpoch);
        });
    }

    @Test
    public void testEmptyAppendNotAllowed() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.appendAsFollower((Records)MemoryRecords.EMPTY, 1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.appendAsLeader((Records)MemoryRecords.EMPTY, 1));
    }

    @ParameterizedTest
    @ArgumentsSource(value=InvalidMemoryRecordsProvider.class)
    public void testInvalidMemoryRecords(MemoryRecords records, Optional<Class<Exception>> expectedException) {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        long previousEndOffset = log.endOffset().offset();
        Executable action = () -> log.appendAsFollower((Records)records, Integer.MAX_VALUE);
        if (expectedException.isPresent()) {
            Assertions.assertThrows(expectedException.get(), (Executable)action);
        } else {
            Assertions.assertThrows(CorruptRecordException.class, (Executable)action);
        }
        Assertions.assertEquals((long)previousEndOffset, (long)log.endOffset().offset());
    }

    @Property(tries=100, afterFailure=AfterFailureMode.SAMPLE_ONLY)
    public void testRandomRecords(@ForAll(supplier=ArbitraryMemoryRecords.class) MemoryRecords records) {
        File tempDir = TestUtils.tempDirectory(null, null);
        try {
            KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(tempDir, this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
            long previousEndOffset = log.endOffset().offset();
            Assertions.assertThrows(CorruptRecordException.class, () -> log.appendAsFollower((Records)records, Integer.MAX_VALUE));
            Assertions.assertEquals((long)previousEndOffset, (long)log.endOffset().offset());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidLeaderEpoch() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compression;
        void withRecords_records2;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        long previousEndOffset = log.endOffset().offset();
        int epoch = log.lastFetchedEpoch() + 1;
        int numberOfRecords = 10;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$testInvalidLeaderEpoch$1(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        NoCompression withRecords_compression2 = Compression.NONE;
        Object var10_6 = null;
        simpleRecordArray = null;
        MemoryRecords batchWithValidEpoch = MemoryRecords.withRecords((byte)2, (long)previousEndOffset, (Compression)withRecords_compression2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)epoch, (boolean)false, (SimpleRecord[])withRecords_records2);
        SimpleRecord[] simpleRecordArray2 = (SimpleRecord[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRecords).map((Function1 & Serializable)number -> KafkaMetadataLogTest.$anonfun$testInvalidLeaderEpoch$2(BoxesRunTime.unboxToInt((Object)number))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        int n = epoch + 1;
        NoCompression noCompression = Compression.NONE;
        long withRecords_initialOffset = previousEndOffset + (long)numberOfRecords;
        noCompression = null;
        simpleRecordArray2 = null;
        MemoryRecords batchWithInvalidEpoch = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (Compression)withRecords_compression, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        ByteBuffer buffer = ByteBuffer.allocate(batchWithValidEpoch.sizeInBytes() + batchWithInvalidEpoch.sizeInBytes());
        buffer.put(batchWithValidEpoch.buffer());
        buffer.put(batchWithInvalidEpoch.buffer());
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        log.appendAsFollower((Records)records, epoch);
        Assertions.assertEquals((long)(previousEndOffset + (long)numberOfRecords), (long)log.endOffset().offset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
    }

    @Test
    public void testCreateSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals((long)0L, (long)((RawSnapshotReader)log.readSnapshot(snapshotId).get()).sizeInBytes());
    }

    @Test
    public void testCreateSnapshotFromEndOffset() {
        int numberOfRecords = 10;
        int firstEpoch = 1;
        int secondEpoch = 3;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)(2 * numberOfRecords)));
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords - 1), firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch(1L, firstEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(2 * numberOfRecords - 1), secondEpoch)).get()).close();
        ((RawSnapshotWriter)log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), secondEpoch)).get()).close();
    }

    @Test
    public void testCreateSnapshotLaterThanHighWatermark() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)(numberOfRecords + 1), epoch)));
    }

    @Test
    public void testCreateSnapshotMuchLaterEpoch() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)numberOfRecords, epoch + 1)));
    }

    @Test
    public void testHighWatermarkOffsetMetadata() {
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        LogOffsetMetadata highWatermarkMetadata = log.highWatermark();
        Assertions.assertEquals((long)numberOfRecords, (long)highWatermarkMetadata.offset());
        Assertions.assertTrue((boolean)highWatermarkMetadata.metadata().isPresent());
        SegmentPosition segmentPosition = (SegmentPosition)highWatermarkMetadata.metadata().get();
        Assertions.assertEquals((long)0L, (long)segmentPosition.baseOffset());
        Assertions.assertTrue((segmentPosition.relativePosition() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSnapshotBeforeLogStartOffset() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 4), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset(snapshotId.offset() - 1L, LogStartOffsetIncrementReason.SegmentDeletion);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset() - 2L, snapshotId.epoch())));
    }

    @Test
    public void testCreateSnapshotDivergingEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotOlderEpoch() {
        int numberOfRecords = 10;
        int epoch = 2;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch() - 1)));
    }

    @Test
    public void testCreateSnapshotWithMissingEpoch() {
        int firstBatchRecords = 5;
        int firstEpoch = 1;
        int missingEpoch = firstEpoch + 1;
        int secondBatchRecords = 5;
        int secondEpoch = missingEpoch + 1;
        int numberOfRecords = firstBatchRecords + secondBatchRecords;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, firstBatchRecords, firstEpoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, secondBatchRecords, secondEpoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch(1L, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)firstBatchRecords, missingEpoch)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.createNewSnapshot(new OffsetAndEpoch((long)secondBatchRecords, missingEpoch)));
    }

    @Test
    public void testCreateExistingSnapshot() {
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        Assertions.assertEquals(Optional.empty(), (Object)log.createNewSnapshot(snapshotId), (String)"Creating an existing snapshot should not do anything");
    }

    @Test
    public void testTopicId() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)KafkaRaftServer$.MODULE$.MetadataTopicId(), (Object)log.topicId());
    }

    @Test
    public void testReadMissingSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals(Optional.empty(), (Object)log.readSnapshot(new OffsetAndEpoch(10L, 0)));
    }

    @Test
    public void testDeleteNonExistentSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 10;
        int epoch = 0;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        Assertions.assertFalse((boolean)log.deleteBeforeSnapshot(new OffsetAndEpoch(2L, epoch)));
        Assertions.assertEquals((long)0L, (long)log.startOffset());
        Assertions.assertEquals((int)epoch, (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)offset, (long)log.endOffset().offset());
        Assertions.assertEquals((long)offset, (long)log.highWatermark().offset());
    }

    @Test
    public void testTruncateFullyToLatestSnapshot() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 0;
        OffsetAndEpoch sameEpochSnapshotId = new OffsetAndEpoch((long)(2 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, sameEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)sameEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)sameEpochSnapshotId.offset(), (long)log.highWatermark().offset());
        OffsetAndEpoch greaterEpochSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, greaterEpochSnapshotId);
        Assertions.assertTrue((boolean)log.truncateToLatestSnapshot());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.startOffset());
        Assertions.assertEquals((int)greaterEpochSnapshotId.epoch(), (int)log.lastFetchedEpoch());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.endOffset().offset());
        Assertions.assertEquals((long)greaterEpochSnapshotId.offset(), (long)log.highWatermark().offset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTruncateWillRemoveOlderSnapshot() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        Assertions.assertNotEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        Assertions.assertTrue((boolean)var3_3.truncateToLatestSnapshot());
        Assertions.assertEquals((Object)var3_3.earliestSnapshotId(), (Object)var3_3.latestSnapshotId());
        var3_3.close();
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$3 -> x$3.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testTruncateWillRemoveOlderSnapshot$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testStartupWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$1 = log.log();
        Option x$2 = qual$1.truncateFullyAndStartAt$default$2();
        qual$1.truncateFullyAndStartAt(100L, x$2);
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(50L, 1));
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(100L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        UnifiedLog qual$2 = log.log();
        Option x$4 = qual$2.truncateFullyAndStartAt$default$2();
        qual$2.truncateFullyAndStartAt(200L, x$4);
        log.close();
        this.writeEmptySnapshot(metadataDir, new OffsetAndEpoch(500L, 1));
        log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((long)500L, (long)log.log().logStartOffset());
    }

    @Test
    public void testSnapshotDeletionWithInvalidSnapshotState() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.log().truncateFullyAndStartAt(100L, log.log().truncateFullyAndStartAt$default$2());
        log.close();
        File metadataDir = this.metadataLogDir(this.tempDir());
        Assertions.assertTrue((boolean)metadataDir.exists());
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(100L, 1);
        this.writeEmptySnapshot(metadataDir, snapshotId);
        Path deletedPath = Snapshots.markForDelete((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId);
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
        Assertions.assertThrows(IllegalStateException.class, () -> KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig()));
        Assertions.assertTrue((boolean)deletedPath.toFile().exists());
    }

    private File metadataLogDir(File logDir) {
        TopicPartition logDirName_topicPartition = KafkaRaftServer$.MODULE$.MetadataPartition();
        Object var2_2 = null;
        return new File(logDir.getAbsolutePath(), LocalLog$.MODULE$.logDirName(logDirName_topicPartition));
    }

    private void writeEmptySnapshot(File metadataDir, OffsetAndEpoch snapshotId) {
        Using$.MODULE$.resource((Object)FileRawSnapshotWriter.create((Path)metadataDir.toPath(), (OffsetAndEpoch)snapshotId), (Function1 & Serializable)x$4 -> {
            x$4.freeze();
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Test
    public void testDoesntTruncateFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderEpochSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderEpochSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        OffsetAndEpoch olderOffsetSnapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, olderOffsetSnapshotId);
        Assertions.assertFalse((boolean)log.truncateToLatestSnapshot());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupPartialSnapshots() {
        void var2_2;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch(1L, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, snapshotId);
        var3_3.close();
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(0L, epoch - 1));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(1L, epoch));
        Snapshots.createTempFile((Path)var2_2, (OffsetAndEpoch)new OffsetAndEpoch(2L, epoch + 1));
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)0L, (long)var3_3.startOffset());
        Assertions.assertEquals((int)epoch, (int)var3_3.lastFetchedEpoch());
        Assertions.assertEquals((long)numberOfRecords, (long)var3_3.endOffset().offset());
        Assertions.assertEquals((long)0L, (long)secondLog.highWatermark().offset());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$6 -> x$6.isPresent()).forEach(path -> Assertions.assertFalse((boolean)((SnapshotPath)path.get()).partial));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanupOlderSnapshots() {
        void var2_2;
        void var4_4;
        void var3_3;
        Tuple3<Path, KafkaMetadataLog, MetadataLogConfig> tuple3 = KafkaMetadataLogTest$.MODULE$.buildMetadataLogAndDir(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        Path logDir = (Path)tuple3._1();
        KafkaMetadataLog log = (KafkaMetadataLog)tuple3._2();
        MetadataLogConfig config = (MetadataLogConfig)tuple3._3();
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch - 1);
        OffsetAndEpoch oldSnapshotId1 = new OffsetAndEpoch(1L, epoch - 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, 1, epoch);
        OffsetAndEpoch oldSnapshotId2 = new OffsetAndEpoch(2L, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords - 2, epoch);
        OffsetAndEpoch oldSnapshotId3 = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, oldSnapshotId3);
        OffsetAndEpoch greaterSnapshotId = new OffsetAndEpoch((long)(3 * numberOfRecords), epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)var3_3, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked((KafkaMetadataLog)var3_3, greaterSnapshotId);
        var3_3.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)greaterSnapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)(3 * numberOfRecords), (long)secondLog.startOffset());
        Assertions.assertEquals((int)epoch, (int)secondLog.lastFetchedEpoch());
        this.mockTime().sleep(var4_4.fileDeleteDelayMs());
        Files.walk((Path)var2_2, 1, new FileVisitOption[0]).map(x$1 -> Snapshots.parse((Path)x$1)).filter(x$8 -> x$8.isPresent()).forEach(arg_0 -> KafkaMetadataLogTest.$anonfun$testCleanupOlderSnapshots$3((KafkaMetadataLog)var3_3, arg_0));
    }

    @Test
    public void testCreateReplicatedLogTruncatesFully() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)(numberOfRecords + 1), epoch + 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.close();
        KafkaMetadataLog secondLog = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        Assertions.assertEquals((Object)snapshotId, secondLog.latestSnapshotId().get());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.startOffset());
        Assertions.assertEquals((int)snapshotId.epoch(), (int)secondLog.lastFetchedEpoch());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.endOffset().offset());
        Assertions.assertEquals((long)snapshotId.offset(), (long)secondLog.highWatermark().offset());
    }

    @Test
    public void testMaxBatchSize() {
        int leaderEpoch = 5;
        int maxBatchSizeInBytes = 16384;
        int recordSize = 64;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig copy$default$1_this = metadataLogConfig;
        Object var20_4 = null;
        int x$2 = copy$default$1_this.logSegmentBytes();
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$2_this = metadataLogConfig2;
        Object var21_6 = null;
        int x$3 = copy$default$2_this.logSegmentMinBytes();
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$3_this = metadataLogConfig3;
        Object var22_8 = null;
        long x$4 = copy$default$3_this.logSegmentMillis();
        MetadataLogConfig metadataLogConfig4 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig4 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$4_this = metadataLogConfig4;
        Object var23_10 = null;
        long x$5 = copy$default$4_this.retentionMaxBytes();
        MetadataLogConfig metadataLogConfig5 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig5 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$5_this = metadataLogConfig5;
        Object var24_12 = null;
        long x$6 = copy$default$5_this.retentionMillis();
        MetadataLogConfig metadataLogConfig6 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig6 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$7_this = metadataLogConfig6;
        Object var25_14 = null;
        int x$7 = copy$default$7_this.maxFetchSizeInBytes();
        MetadataLogConfig metadataLogConfig7 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig7 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$8_this = metadataLogConfig7;
        Object var26_16 = null;
        long x$8 = copy$default$8_this.fileDeleteDelayMs();
        MetadataLogConfig metadataLogConfig8 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig8 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig8;
        Object var27_18 = null;
        int x$9 = copy$default$9_this.nodeId();
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), new MetadataLogConfig(x$2, x$3, x$4, x$5, x$6, maxBatchSizeInBytes, x$7, x$8, x$9));
        MemoryRecords oversizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes + recordSize);
        Assertions.assertThrows(RecordTooLargeException.class, () -> log.appendAsLeader((Records)oversizeBatch, leaderEpoch));
        MemoryRecords undersizeBatch = this.buildFullBatch(leaderEpoch, recordSize, maxBatchSizeInBytes);
        LogAppendInfo appendInfo = log.appendAsLeader((Records)undersizeBatch, leaderEpoch);
        Assertions.assertEquals((long)0L, (long)appendInfo.firstOffset);
    }

    @Test
    public void testTruncateBelowHighWatermark() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numRecords = 10;
        int epoch = 5;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numRecords, epoch);
        Assertions.assertEquals((long)numRecords, (long)log.endOffset().offset());
        log.updateHighWatermark(new LogOffsetMetadata((long)numRecords));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
        Assertions.assertThrows(IllegalArgumentException.class, () -> log.truncateTo(5L));
        Assertions.assertEquals((long)numRecords, (long)log.highWatermark().offset());
    }

    private MemoryRecords buildFullBatch(int leaderEpoch, int recordSize, int maxBatchSizeInBytes) {
        ByteBuffer buffer = ByteBuffer.allocate(maxBatchSizeInBytes);
        BatchBuilder batchBuilder = new BatchBuilder(buffer, (RecordSerde)new ByteArraySerde(), (Compression)Compression.NONE, 0L, this.mockTime().milliseconds(), leaderEpoch, maxBatchSizeInBytes);
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        List<byte[]> records = Collections.singletonList(new byte[recordSize]);
        while (!batchBuilder.bytesNeeded(records, serializationCache).isPresent()) {
            batchBuilder.appendRecord((Object)records.get(0), serializationCache);
        }
        return batchBuilder.build();
    }

    @Test
    public void testValidateEpochGreaterThanLastKnownEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch + 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanOldestSnapshotEpoch() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)numberOfRecords));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)numberOfRecords, epoch - 1);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        log.log().maybeIncrementLogStartOffset((long)offset, LogStartOffsetIncrementReason.SegmentDeletion);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(offset - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.SNAPSHOT, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetEqualToOldestSnapshotOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int offset = 2;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, offset, epoch);
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, epoch);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshot(log, snapshotId);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)offset, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateUnknownEpochLessThanLastKnownGreaterThanOldestSnapshot() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 1);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 2);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 4);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 3);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(20L, 2), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateEpochLessThanFirstEpochInLog() {
        int offset = 10;
        int numOfRecords = 5;
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        log.updateHighWatermark(new LogOffsetMetadata((long)offset));
        OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        log.truncateToLatestSnapshot();
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numOfRecords, 3);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(100L, 2);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)snapshotId, (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetGreatThanEndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 1;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords + 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(log.endOffset().offset(), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateOffsetLessThanLEO() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 10;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch + 1);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch(11L, epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.DIVERGING, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch(10L, epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    @Test
    public void testValidateValidEpochAndOffset() {
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig());
        int numberOfRecords = 5;
        int epoch = 1;
        KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, numberOfRecords, epoch);
        ValidOffsetAndEpoch resultOffsetAndEpoch = log.validateOffsetAndEpoch((long)(numberOfRecords - 1), epoch);
        Assertions.assertEquals((Object)ValidOffsetAndEpoch.Kind.VALID, (Object)resultOffsetAndEpoch.kind());
        Assertions.assertEquals((Object)new OffsetAndEpoch((long)(numberOfRecords - 1), epoch), (Object)resultOffsetAndEpoch.offsetAndEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAdvanceLogStartOffsetAfterCleaning() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        MetadataLogConfig config = new MetadataLogConfig(512, 512, 10000L, 256L, 60000L, 512, KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig().maxFetchSizeInBytes(), 60000L, 1);
        int n = config.nodeId();
        long l = config.fileDeleteDelayMs();
        int n2 = config.maxFetchSizeInBytes();
        int n3 = config.maxBatchSizeInBytes();
        long l2 = config.retentionMillis();
        long l3 = config.retentionMaxBytes();
        long l4 = config.logSegmentMillis();
        int n4 = config.logSegmentMinBytes();
        int copy_logSegmentBytes = config.logSegmentBytes();
        new MetadataLogConfig(copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$9 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 47, 1));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since HW was still 0");
        log.updateHighWatermark(new LogOffsetMetadata(4000L));
        Assertions.assertFalse((boolean)log.maybeClean(), (String)"Should not clean since no snapshots exist");
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long lsoBefore = log.startOffset();
        Assertions.assertTrue((boolean)log.maybeClean(), (String)"Expected to clean since there was at least one snapshot");
        long lsoAfter = log.startOffset();
        Assertions.assertTrue((lsoAfter > lsoBefore ? 1 : 0) != 0, (String)"Log Start Offset should have increased after cleaning");
        Assertions.assertTrue((lsoAfter == snapshotId2.offset() ? 1 : 0) != 0, (String)"Expected the Log Start Offset to be less than or equal to the snapshot offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteSnapshots() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var17_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 100;
        long l2 = 60000L;
        long l3 = 1024L;
        long l4 = 10000L;
        int n4 = 1024;
        int n5 = 1024;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).foreach((Function1 & Serializable)x$10 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(1001L));
        package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 200, 300, 400, 500, 600})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            OffsetAndEpoch snapshotId = new OffsetAndEpoch((long)offset, 1);
            KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId);
        });
        Assertions.assertEquals((int)6, (int)log.snapshotCount());
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected only one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            KafkaMetadataLogTest.$anonfun$testDeleteSnapshots$3((OffsetAndEpoch)assertOptional_optional.get());
        } else {
            Assertions.fail((String)"Missing value from Optional");
        }
        Object var3_13 = null;
        Assertions.assertEquals((long)log.startOffset(), (long)600L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSoftRetentionLimit() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var19_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 100;
        long l2 = 60000L;
        long l3 = 10240L;
        long l4 = 10000L;
        int n4 = 10240;
        int n5 = 10240;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$11 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 1, 1));
        log.updateHighWatermark(new LogOffsetMetadata(2000L));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(1000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId1).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$2(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(2000L, 1);
        Using$.MODULE$.resource(log.createNewSnapshotUnchecked(snapshotId2).get(), (Function1 & Serializable)snapshot -> {
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$3(snapshot);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount(), (String)"Expected one snapshot after cleaning");
        Optional assertOptional_optional = log.latestSnapshotId();
        if (assertOptional_optional.isPresent()) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$4(log, config, offsetAndEpoch);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentsLessThanLatestSnapshot() {
        void copy_nodeId;
        void copy_fileDeleteDelayMs;
        void copy_maxFetchSizeInBytes;
        void copy_maxBatchSizeInBytes;
        void copy_retentionMillis;
        void copy_retentionMaxBytes;
        void copy_logSegmentMillis;
        void copy_logSegmentMinBytes;
        void copy_logSegmentBytes;
        MetadataLogConfig metadataLogConfig = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig2 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig2 == null) {
            throw null;
        }
        MetadataLogConfig metadataLogConfig3 = KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig();
        if (metadataLogConfig3 == null) {
            throw null;
        }
        MetadataLogConfig copy$default$9_this = metadataLogConfig3;
        Object var22_1 = null;
        int n = copy$default$9_this.nodeId();
        long l = metadataLogConfig2.fileDeleteDelayMs();
        int n2 = metadataLogConfig.maxFetchSizeInBytes();
        int n3 = 200;
        long l2 = 60000L;
        long l3 = 10240L;
        long l4 = 10000L;
        int n4 = 10240;
        int n5 = 10240;
        if (KafkaMetadataLogTest$.MODULE$.DefaultMetadataLogConfig() == null) {
            throw null;
        }
        MetadataLogConfig config = new MetadataLogConfig((int)copy_logSegmentBytes, (int)copy_logSegmentMinBytes, (long)copy_logSegmentMillis, (long)copy_retentionMaxBytes, (long)copy_retentionMillis, (int)copy_maxBatchSizeInBytes, (int)copy_maxFetchSizeInBytes, (long)copy_fileDeleteDelayMs, (int)copy_nodeId);
        KafkaMetadataLog log = KafkaMetadataLogTest$.MODULE$.buildMetadataLog(this.tempDir(), this.mockTime(), config);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 2000).foreach((Function1 & Serializable)x$12 -> KafkaMetadataLogTest$.MODULE$.append((ReplicatedLog)log, 10, 1));
        log.updateHighWatermark(new LogOffsetMetadata(log.endOffset().offset()));
        OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().logSegments()).asScala().drop(1)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId1);
        OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(((LogSegment)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(log.log().logSegments()).asScala().drop(2)).head()).baseOffset(), 1);
        KafkaMetadataLogTest$.MODULE$.createNewSnapshotUnckecked(log, snapshotId2);
        long defaultLogRetentionMs = 1209600000L;
        this.mockTime().sleep(defaultLogRetentionMs);
        Assertions.assertTrue((boolean)log.maybeClean());
        Assertions.assertEquals((int)1, (int)log.snapshotCount());
        Assertions.assertTrue((log.startOffset() > 0L ? 1 : 0) != 0, (String)new StringBuilder(23).append(log.startOffset()).append(" must be greater than 0").toString());
        long latestSnapshotOffset = ((OffsetAndEpoch)log.latestSnapshotId().get()).offset();
        Assertions.assertTrue((latestSnapshotOffset >= log.startOffset() ? 1 : 0) != 0, (String)new StringBuilder(56).append("latest snapshot offset (").append(latestSnapshotOffset).append(") must be >= log start offset (").append(log.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testInvalidLeaderEpoch$1(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testInvalidLeaderEpoch$2(int number) {
        return new SimpleRecord(Integer.toString(number).getBytes());
    }

    public static final /* synthetic */ void $anonfun$testTruncateWillRemoveOlderSnapshot$3(KafkaMetadataLog log$10, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$10.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanupOlderSnapshots$3(KafkaMetadataLog log$11, Optional path) {
        Assertions.assertFalse((((SnapshotPath)path.get()).snapshotId.offset() < log$11.startOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testDeleteSnapshots$3(OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)600L, (long)snapshotId.offset());
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$2(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$3(RawSnapshotWriter snapshot) {
        KafkaMetadataLogTest$.MODULE$.append(snapshot, 500);
        snapshot.freeze();
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$5(KafkaMetadataLog log$16, MetadataLogConfig config$1, RawSnapshotReader reader) {
        Assertions.assertTrue((reader.sizeInBytes() + log$16.log().size() > config$1.retentionMaxBytes() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSoftRetentionLimit$4(KafkaMetadataLog log$16, MetadataLogConfig config$1, OffsetAndEpoch snapshotId) {
        Assertions.assertEquals((long)2000L, (long)snapshotId.offset(), (String)"Unexpected offset for latest snapshot");
        Optional assertOptional_optional = log$16.readSnapshot(snapshotId);
        if (assertOptional_optional.isPresent()) {
            RawSnapshotReader rawSnapshotReader = (RawSnapshotReader)assertOptional_optional.get();
            KafkaMetadataLogTest.$anonfun$testSoftRetentionLimit$5(log$16, config$1, rawSnapshotReader);
            return;
        }
        Assertions.fail((String)"Missing value from Optional");
    }

    public static class ByteArraySerde
    implements RecordSerde<byte[]> {
        public int recordSize(byte[] data, ObjectSerializationCache serializationCache) {
            return data.length;
        }

        public void write(byte[] data, ObjectSerializationCache serializationCache, Writable out) {
            out.writeByteArray(data);
        }

        public byte[] read(Readable input, int size) {
            return input.readArray(size);
        }
    }
}

