/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerChannelManagerImpl;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120L)
@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\u0006\r\u0001EAQ\u0001\u0007\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\r\u0001\u0005\u0002EBQA\u0017\u0001\u0005\u0002mCq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u00111\u0010\u0001\u0005\u0002\u0005u\u0004bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003c\u0003A\u0011AAZ\u0005u\u0011%o\\6feJ+w-[:ue\u0006$\u0018n\u001c8SKF,Xm\u001d;UKN$(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0019\u0005\u0001#M]8lKJ$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s)\tq\u0002\u0006\u0005\u0002 M5\t\u0001E\u0003\u0002\u000eC)\u0011qB\t\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014x-\u0003\u0002(A\tqbj\u001c3f)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM\u001d\u0005\u0006S\t\u0001\rAK\u0001\u0010G2,8\u000f^3s\u0013:\u001cH/\u00198dKB\u00111FL\u0007\u0002Y)\u0011QFD\u0001\u0005i\u0016\u001cH/\u0003\u00020Y\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW-\u0001\btK:$\u0017I\u001c3SK\u000e,\u0017N^3\u0016\u0007IzU\u0007\u0006\u00034\u0007\u0016+\u0006C\u0001\u001b6\u0019\u0001!QAN\u0002C\u0002]\u0012\u0011AU\t\u0003qm\u0002\"aE\u001d\n\u0005i\"\"a\u0002(pi\"Lgn\u001a\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003\u0001\u0006\naaY8n[>t\u0017B\u0001\">\u0005A\t%m\u001d;sC\u000e$(+Z:q_:\u001cX\rC\u0003E\u0007\u0001\u0007a$\u0001\bdQ\u0006tg.\u001a7NC:\fw-\u001a:\t\u000b\u0019\u001b\u0001\u0019A$\u0002\u0015I,\u0017OQ;jY\u0012,'\u000fE\u0002I\u0017:s!\u0001P%\n\u0005)k\u0014aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\n\u00051k%a\u0002\"vS2$WM\u001d\u0006\u0003\u0015v\u0002\"\u0001N(\u0005\u000bA\u001b!\u0019A)\u0003\u0003Q\u000b\"\u0001\u000f*\u0011\u0005q\u001a\u0016B\u0001+>\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\b\"\u0002,\u0004\u0001\u00049\u0016!\u0003;j[\u0016|W\u000f^'t!\t\u0019\u0002,\u0003\u0002Z)\t\u0019\u0011J\u001c;\u0002\u001dI,w-[:uKJ\u0014%o\\6feR1ALY2qej\u0004\"!\u00181\u000e\u0003yS!aX \u0002\u0011A\u0014x\u000e^8d_2L!!\u00190\u0003\r\u0015\u0013(o\u001c:t\u0011\u0015!E\u00011\u0001\u001f\u0011\u0015!G\u00011\u0001f\u0003%\u0019G.^:uKJLE\r\u0005\u0002g[:\u0011qm\u001b\t\u0003QRi\u0011!\u001b\u0006\u0003UB\ta\u0001\u0010:p_Rt\u0014B\u00017\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011an\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051$\u0002\"B9\u0005\u0001\u00049\u0016\u0001\u00032s_.,'/\u00133\t\u000bM$\u0001\u0019\u0001;\u0002\u000fi\\W\t]8dQB\u00191#^<\n\u0005Y$\"AB(qi&|g\u000e\u0005\u0002\u0014q&\u0011\u0011\u0010\u0006\u0002\u0005\u0019>tw\rC\u0003|\t\u0001\u0007A0A\u0005jEB$vnU3oIB\u00191#^?\u0011\rMq\u0018\u0011AA\u0001\u0013\tyHC\u0001\u0004UkBdWM\r\t\u0005\u0003\u0007\t9!\u0004\u0002\u0002\u0006)\u0011\u0001\tI\u0005\u0005\u0003\u0013\t)AA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u00031\u0019'/Z1uKR{\u0007/[2t)\u0015a\u0016qBA\t\u0011\u0015!U\u00011\u0001\u001f\u0011\u0019\t\u0019\"\u0002a\u0001K\u0006IAo\u001c9jG:\u000bW.Z\u0001)i\u0016\u001cHOU3hSN$XM\u001d.l/&$\bn\u0013*bMRl\u0015n\u001a:bi&|g\u000eR5tC\ndW\r\u001a\u000b\u0005\u00033\ty\u0002E\u0002\u0014\u00037I1!!\b\u0015\u0005\u0011)f.\u001b;\t\u000b%2\u0001\u0019\u0001\u0016)/\u0019\t\u0019#a\f\u00022\u0005u\u0012qHA!\u0003\u0007\n)%a\u0012\u0002R\u0005M\u0003\u0003BA\u0013\u0003Wi!!a\n\u000b\u0007\u0005%B&\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002(\tY1\t\\;ti\u0016\u0014H+Z:u\u0003\u0015!\u0018\u0010]3tY\t\t\u0019\u0004\n\u0002\u00026%!\u0011qGA\u001d\u0003\u0015Y%+\u0011$U\u0015\u0011\tY$a\n\u0002\tQK\b/Z\u0001\bEJ|7.\u001a:t;\u0005\u0001\u0011aC2p]R\u0014x\u000e\u001c7feNl\u0012!A\u0001\u0010[\u0016$\u0018\rZ1uCZ+'o]5p]\u0012\u0012\u0011\u0011J\u0005\u0005\u0003\u0017\ni%A\u0006J\u0005B{6g\u0018\u001b`\u0013Z\u0003$\u0002BA(\u0003\u000b\tq\"T3uC\u0012\fG/\u0019,feNLwN\\\u0001\u0011g\u0016\u0014h/\u001a:Qe>\u0004XM\u001d;jKNd#!!\u0016,\u0015\u0005]\u0013QLA0\u0003G\n)\u0007\u0005\u0003\u0002&\u0005e\u0013\u0002BA.\u0003O\u0011Qc\u00117vgR,'oQ8oM&<\u0007K]8qKJ$\u00180A\u0002lKf\f#!!\u0019\u0002Gi|wn[3fa\u0016\u0014h&\\3uC\u0012\fG/\u0019\u0018nS\u001e\u0014\u0018\r^5p]:*g.\u00192mK\u0006)a/\u00197vK\u0006\u0012\u0011qM\u0001\u0006M\u0006d7/Z\u0001\u001fi\u0016\u001cHOU3hSN$XM\u001d.l/&$\bnM\u001aD_:$(o\u001c7mKJ$B!!\u0007\u0002n!)\u0011f\u0002a\u0001U!:r!a\t\u00020\u0005E\u0014QHA \u0003\u0003\n\u0019%!\u0012\u0002t\u0005E\u0013\u0011\u0010\u0017\u0003\u0003g!#!!\u001e\n\t\u0005]\u0014QJ\u0001\f\u0013\n\u0003vlM04?&36\u0007\f\u0002\u0002V\u00059C/Z:u%\u0016<\u0017n\u001d;fej[w+\u001b;i\u0017J\u000bg\r^'jOJ\fG/[8o\u000b:\f'\r\\3e)\u0011\tI\"a \t\u000b%B\u0001\u0019\u0001\u0016)7!\t\u0019#a\f\u0002\u0004\u0006u\u00121IA!\u0003\u0007\n)%!\"\u0002\f\u00065\u0015\u0011KALY\t\t\u0019\u0004\n\u0002\u0002\b&!\u0011\u0011RA'\u0003-I%\tU04?Zz\u0016JV\u0019\u0002\u0013\u0005,Ho\\*uCJ$HEAAH\u0013\u0011\t\t*a%\u0002\u00059{%\u0002BAK\u0003O\t\u0011\"Q;u_N#\u0018M\u001d;-\u0005\u0005e5FCA,\u0003;\ny&a\u0019\u0002\u001c\u0006\u0012\u0011QT\u0001\u0005iJ,X-\u0001\u0018uKN$(+Z4jgR,'OW6XSRD7JU1gi6KwM]1uS>tWI\\1cY\u0016$7JU1giZ\u000bD\u0003BA\r\u0003GCQ!K\u0005A\u0002)B3$CA\u0012\u0003_\t9+!\u0010\u0002D\u0005\u0005\u00131IA#\u0003S\u000bY)!$\u0002R\u0005=FFAA\u001aI\t\tY+\u0003\u0003\u0002.\u00065\u0013aC%C!~\u001bt,O0J-Bb#!!'\u0002OQ,7\u000f\u001e(p\u001b\u0016$\u0018\rZ1uC\u000eC\u0017M\\4fg&s\u0007K]3NS\u001e\u0014\u0018\r^5p]6{G-\u001a\u000b\u0005\u00033\t)\fC\u0003*\u0015\u0001\u0007!\u0006K\u0004\u000b\u0003s\u000b\u0019'a0\u0011\t\u0005\u0015\u00121X\u0005\u0005\u0003{\u000b9C\u0001\u0007DYV\u001cH/\u001a:UKN$8\u000f\f\u0002\u0002B.2\u00121EA\u0018\u0003\u0007\fY)!$\u0002B\u0005\r\u0013QIA$\u0003#\n)\r\f\u0002\u000241\u0012\u0011\u0011\u0014\u0015\b\u0001\u0005%\u00171MAo!\u0011\tY-!7\u000e\u0005\u00055'\u0002BAh\u0003#\f1!\u00199j\u0015\u0011\t\u0019.!6\u0002\u000f),\b/\u001b;fe*\u0019\u0011q\u001b\u0013\u0002\u000b),h.\u001b;\n\t\u0005m\u0017Q\u001a\u0002\b)&lWm\\;u=\u0005A\bf\u0002\u0001\u0002b\u0006\r\u0014Q\u001e\t\u0005\u0003G\fI/\u0004\u0002\u0002f*!\u0011q]Ag\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002l\u0006\u0015(AC#yi\u0016tGmV5uQ2\u0012\u0011q^\u0012\u0003\u0003c\u0004B!a=\u0002x6\u0011\u0011Q\u001f\u0006\u0004\u0003/d\u0013\u0002BA}\u0003k\u0014Qc\u00117vgR,'\u000fV3ti\u0016CH/\u001a8tS>t7\u000f")
public class BrokerRegistrationRequestTest {
    public NodeToControllerChannelManager brokerToControllerChannelManager(ClusterInstance clusterInstance) {
        return new NodeToControllerChannelManagerImpl(new ControllerNodeProvider(null, clusterInstance){
            private final SecurityProtocol securityProtocol;
            private final String saslMechanism;
            private final ClusterInstance clusterInstance$1;

            private Option<Node> node() {
                return new Some((Object)new Node(this.clusterInstance$1.anyControllerSocketServer().config().nodeId(), "127.0.0.1", this.clusterInstance$1.anyControllerSocketServer().boundPort(this.clusterInstance$1.controllerListenerName().get())));
            }

            private ListenerName listenerName() {
                return this.clusterInstance$1.controllerListenerName().get();
            }

            private SecurityProtocol securityProtocol() {
                return this.securityProtocol;
            }

            private String saslMechanism() {
                return this.saslMechanism;
            }

            private boolean isZkController() {
                return !this.clusterInstance$1.isKRaftTest();
            }

            public ControllerInformation getControllerInfo() {
                return new ControllerInformation(this.node(), this.listenerName(), this.securityProtocol(), this.saslMechanism(), this.isZkController());
            }
            {
                this.clusterInstance$1 = clusterInstance$1;
                this.securityProtocol = SecurityProtocol.PLAINTEXT;
                this.saslMechanism = "";
            }
        }, Time.SYSTEM, new Metrics(), clusterInstance.anyControllerSocketServer().config(), "heartbeat", "test-heartbeat-", 10000L);
    }

    public <T extends AbstractRequest, R extends AbstractResponse> R sendAndReceive(NodeToControllerChannelManager channelManager, AbstractRequest.Builder<T> reqBuilder, int timeoutMs) {
        CompletableFuture responseFuture = new CompletableFuture();
        channelManager.sendRequest(reqBuilder, new ControllerRequestCompletionHandler(null, responseFuture){
            private final CompletableFuture responseFuture$1;

            public void onTimeout() {
                this.responseFuture$1.completeExceptionally(new TimeoutException());
            }

            public void onComplete(ClientResponse response) {
                this.responseFuture$1.complete(response.responseBody());
            }
            {
                this.responseFuture$1 = responseFuture$1;
            }
        });
        return (R)((AbstractResponse)responseFuture.get(timeoutMs, TimeUnit.MILLISECONDS));
    }

    public Errors registerBroker(NodeToControllerChannelManager channelManager, String clusterId, int brokerId, Option<Object> zkEpoch, Option<Tuple2<MetadataVersion, MetadataVersion>> ibpToSend) {
        BrokerRegistrationRequestData.FeatureCollection features = new BrokerRegistrationRequestData.FeatureCollection();
        ibpToSend.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerRegistrationRequestTest.$anonfun$registerBroker$1(features, x0$1)));
        Features.PRODUCTION_FEATURES.stream().filter(x$1 -> {
            String string = x$1.featureName();
            String string2 = "metadata.version";
            return string == null || !string.equals(string2);
        }).forEach(feature -> features.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName(feature.featureName()).setMinSupportedVersion(feature.minimumProduction()).setMaxSupportedVersion(feature.latestTesting())));
        BrokerRegistrationRequestData req = new BrokerRegistrationRequestData().setBrokerId(brokerId).setLogDirs(Collections.singletonList(Uuid.randomUuid())).setClusterId(clusterId).setIncarnationId(Uuid.randomUuid()).setIsMigratingZkBroker(zkEpoch.isDefined()).setFeatures(features).setListeners(new BrokerRegistrationRequestData.ListenerCollection(Arrays.asList(new BrokerRegistrationRequestData.Listener().setName("EXTERNAL").setHost("example.com").setPort(8082).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id)).iterator()));
        return Errors.forCode((short)((BrokerRegistrationResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)new BrokerRegistrationRequest.Builder(req), 30000)).data().errorCode());
    }

    public Errors createTopics(NodeToControllerChannelManager channelManager, String topicName) {
        CreateTopicsRequestData createTopics = new CreateTopicsRequestData();
        createTopics.setTopics(new CreateTopicsRequestData.CreatableTopicCollection());
        createTopics.topics().add((ImplicitLinkedHashCollection.Element)new CreateTopicsRequestData.CreatableTopic().setName(topicName).setNumPartitions(10).setReplicationFactor((short)1));
        createTopics.setTimeoutMs(500);
        CreateTopicsRequest.Builder req = new CreateTopicsRequest.Builder(createTopics);
        return Errors.forCode((short)((CreateTopicsResponse)this.sendAndReceive(channelManager, (AbstractRequest.Builder)req, 3000)).data().topics().find(topicName).errorCode());
    }

    @ClusterTest(types={Type.KRAFT}, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWithKRaftMigrationDisabled(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(types={Type.KRAFT}, brokers=0, controllers=1, metadataVersion=MetadataVersion.IBP_3_3_IV3, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="false")})
    public void testRegisterZkWith33Controller(ClusterInstance clusterInstance) {
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(types={Type.KRAFT}, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_6_IV1, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabled(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().values().forEach(x$2 -> x$2.startup());
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_6_IV1))));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)None$.MODULE$));
            Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.IBP_3_3_IV3))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.IBP_3_4_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTest(types={Type.KRAFT}, brokers=1, controllers=1, metadataVersion=MetadataVersion.IBP_3_9_IV0, autoStart=AutoStart.NO, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})
    public void testRegisterZkWithKRaftMigrationEnabledKRaftV1(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().values().forEach(x$3 -> x$3.startup());
        String clusterId = clusterInstance.clusterId();
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertEquals((Object)Errors.NONE, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)1L)), (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.IBP_3_9_IV0))));
            Assertions.assertEquals((Object)Errors.BROKER_ID_NOT_REGISTERED, (Object)this.registerBroker(channelManager, clusterId, 100, (Option<Object>)None$.MODULE$, (Option<Tuple2<MetadataVersion, MetadataVersion>>)new Some((Object)new Tuple2((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.IBP_3_9_IV0))));
        }
        finally {
            channelManager.shutdown();
        }
    }

    @ClusterTests(value={@ClusterTest(types={Type.KRAFT}, autoStart=AutoStart.NO, controllers=1, metadataVersion=MetadataVersion.IBP_3_4_IV0, serverProperties={@ClusterConfigProperty(key="zookeeper.metadata.migration.enable", value="true")})})
    public void testNoMetadataChangesInPreMigrationMode(ClusterInstance clusterInstance) {
        ((RaftClusterInvocationContext.RaftClusterInstance)clusterInstance).controllers().values().forEach(x$4 -> x$4.startup());
        NodeToControllerChannelManager channelManager = this.brokerToControllerChannelManager(clusterInstance);
        try {
            channelManager.start();
            Assertions.assertThrows(TimeoutException.class, () -> this.createTopics(channelManager, "test-pre-migration"));
        }
        finally {
            channelManager.shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerBroker$1(BrokerRegistrationRequestData.FeatureCollection features$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataVersion min = (MetadataVersion)x0$1._1();
            MetadataVersion max = (MetadataVersion)x0$1._2();
            return features$1.add((ImplicitLinkedHashCollection.Element)new BrokerRegistrationRequestData.Feature().setName("metadata.version").setMinSupportedVersion(min.featureLevel()).setMaxSupportedVersion(max.featureLevel()));
        }
        throw new MatchError(null);
    }
}

