/*
 * Decompiled with CFR 0.152.
 */
package kafka.test.junit;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.api.IntegrationTestHarness;
import kafka.network.SocketServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterInstanceParameterResolver;
import kafka.utils.EmptyTestInfo;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;

public class ZkClusterInvocationContext
implements TestTemplateInvocationContext {
    private final String baseDisplayName;
    private final ClusterConfig clusterConfig;
    private final AtomicReference<ClusterConfigurableIntegrationHarness> clusterReference;

    public ZkClusterInvocationContext(String baseDisplayName, ClusterConfig clusterConfig) {
        this.baseDisplayName = baseDisplayName;
        this.clusterConfig = clusterConfig;
        this.clusterReference = new AtomicReference();
    }

    public String getDisplayName(int invocationIndex) {
        return String.format("%s [%d] Type=ZK, %s", this.baseDisplayName, invocationIndex, String.join((CharSequence)",", this.clusterConfig.displayTags()));
    }

    public List<Extension> getAdditionalExtensions() {
        if (this.clusterConfig.numControllers() != 1) {
            throw new IllegalArgumentException("For ZK clusters, please specify exactly 1 controller.");
        }
        ZkClusterInstance clusterShim = new ZkClusterInstance(this.clusterConfig, this.clusterReference);
        return Arrays.asList(context -> {
            this.clusterReference.set(new ClusterConfigurableIntegrationHarness(this.clusterConfig));
            if (this.clusterConfig.isAutoStart()) {
                clusterShim.start();
            }
        }, context -> clusterShim.stop(), new ClusterInstanceParameterResolver(clusterShim));
    }

    private static class ClusterConfigurableIntegrationHarness
    extends IntegrationTestHarness {
        private ClusterConfig clusterConfig;

        private ClusterConfigurableIntegrationHarness(ClusterConfig clusterConfig) {
            this.clusterConfig = Objects.requireNonNull(clusterConfig);
        }

        public void setClusterConfig(ClusterConfig clusterConfig) {
            this.clusterConfig = Objects.requireNonNull(clusterConfig);
        }

        @Override
        public void modifyConfigs(Seq<Properties> props) {
            super.modifyConfigs(props);
            for (int i = 0; i < props.length(); ++i) {
                ((Properties)props.apply(i)).putAll((Map<?, ?>)this.clusterConfig.perServerOverrideProperties().getOrDefault(i, Collections.emptyMap()));
            }
        }

        @Override
        public Properties serverConfig() {
            Properties props = new Properties();
            props.putAll(this.clusterConfig.serverProperties());
            props.put("inter.broker.protocol.version", this.clusterConfig.metadataVersion().version());
            return props;
        }

        @Override
        public Properties adminClientConfig() {
            Properties props = new Properties();
            props.putAll(this.clusterConfig.adminClientProperties());
            return props;
        }

        @Override
        public Properties consumerConfig() {
            Properties props = new Properties();
            props.putAll(this.clusterConfig.consumerProperties());
            return props;
        }

        @Override
        public Properties producerConfig() {
            Properties props = new Properties();
            props.putAll(this.clusterConfig.producerProperties());
            return props;
        }

        @Override
        public SecurityProtocol securityProtocol() {
            return this.clusterConfig.securityProtocol();
        }

        @Override
        public ListenerName listenerName() {
            return this.clusterConfig.listenerName().map(ListenerName::normalised).orElseGet(() -> ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol()));
        }

        @Override
        public Option<Properties> serverSaslProperties() {
            if (this.clusterConfig.saslServerProperties().isEmpty()) {
                return Option.empty();
            }
            Properties props = new Properties();
            props.putAll(this.clusterConfig.saslServerProperties());
            return Option.apply((Object)props);
        }

        @Override
        public Option<Properties> clientSaslProperties() {
            if (this.clusterConfig.saslClientProperties().isEmpty()) {
                return Option.empty();
            }
            Properties props = new Properties();
            props.putAll(this.clusterConfig.saslClientProperties());
            return Option.apply((Object)props);
        }

        @Override
        public int brokerCount() {
            return this.clusterConfig.numBrokers();
        }

        @Override
        public int logDirCount() {
            return this.clusterConfig.numDisksPerBroker();
        }

        @Override
        public Option<File> trustStoreFile() {
            return OptionConverters.toScala(this.clusterConfig.trustStoreFile());
        }
    }

    public static class ZkClusterInstance
    implements ClusterInstance {
        final AtomicReference<ClusterConfigurableIntegrationHarness> clusterReference;
        final ClusterConfig config;
        final AtomicBoolean started = new AtomicBoolean(false);
        final AtomicBoolean stopped = new AtomicBoolean(false);

        ZkClusterInstance(ClusterConfig config, AtomicReference<ClusterConfigurableIntegrationHarness> clusterReference) {
            this.config = config;
            this.clusterReference = clusterReference;
        }

        @Override
        public String bootstrapServers() {
            return kafka.utils.TestUtils.bootstrapServers(this.clusterReference.get().servers(), this.clusterReference.get().listenerName());
        }

        @Override
        public String bootstrapControllers() {
            throw new RuntimeException("Cannot use --bootstrap-controller with ZK-based clusters.");
        }

        @Override
        public ListenerName clientListener() {
            return this.clusterReference.get().listenerName();
        }

        @Override
        public Optional<ListenerName> controlPlaneListenerName() {
            return OptionConverters.toJava((Option)((KafkaServer)this.clusterReference.get().servers().head()).config().controlPlaneListenerName());
        }

        @Override
        public Collection<SocketServer> controllerSocketServers() {
            return this.brokers().values().stream().filter(s -> ((KafkaServer)s).kafkaController().isActive()).map(KafkaBroker::socketServer).collect(Collectors.toList());
        }

        @Override
        public String clusterId() {
            return this.brokers().values().stream().findFirst().map(KafkaBroker::clusterId).orElseThrow(() -> new RuntimeException("No broker instances found"));
        }

        @Override
        public Type type() {
            return Type.ZK;
        }

        @Override
        public ClusterConfig config() {
            return this.config;
        }

        @Override
        public Set<Integer> controllerIds() {
            return this.brokerIds();
        }

        @Override
        public IntegrationTestHarness getUnderlying() {
            return this.clusterReference.get();
        }

        @Override
        public Admin createAdminClient(Properties configOverrides) {
            return this.clusterReference.get().createAdminClient(this.clientListener(), configOverrides);
        }

        @Override
        public void start() {
            if (this.started.compareAndSet(false, true)) {
                this.clusterReference.get().setUp(new EmptyTestInfo());
            }
        }

        @Override
        public void stop() {
            if (this.stopped.compareAndSet(false, true)) {
                this.clusterReference.get().tearDown();
            }
        }

        @Override
        public void shutdownBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).shutdown();
        }

        @Override
        public void startBroker(int brokerId) {
            this.findBrokerOrThrow(brokerId).startup();
        }

        public void rollingBrokerRestart(Optional<ClusterConfig> clusterConfig) {
            Objects.requireNonNull(clusterConfig);
            if (!this.started.get()) {
                throw new IllegalStateException("Tried to restart brokers but the cluster has not been started!");
            }
            for (int i = 0; i < this.clusterReference.get().brokerCount(); ++i) {
                this.clusterReference.get().killBroker(i);
            }
            clusterConfig.ifPresent(config -> this.clusterReference.get().setClusterConfig((ClusterConfig)config));
            this.clusterReference.get().restartDeadBrokers(true);
            this.clusterReference.get().adminClientConfig().put("bootstrap.servers", this.bootstrapServers());
        }

        @Override
        public void waitForReadyBrokers() throws InterruptedException {
            TestUtils.waitForCondition(() -> {
                int numRegisteredBrokers = this.clusterReference.get().zkClient().getAllBrokersInCluster().size();
                return numRegisteredBrokers == this.config.numBrokers();
            }, (String)"Timed out while waiting for brokers to become ready");
        }

        private KafkaServer findBrokerOrThrow(int brokerId) {
            return this.brokers().values().stream().filter(server -> server.config().brokerId() == brokerId).map(s -> (KafkaServer)s).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown brokerId " + brokerId));
        }

        @Override
        public Map<Integer, ControllerServer> controllers() {
            return Collections.emptyMap();
        }

        @Override
        public Map<Integer, KafkaBroker> brokers() {
            return JavaConverters.asJavaCollection(this.clusterReference.get().servers()).stream().collect(Collectors.toMap(s -> s.config().brokerId(), s -> s));
        }
    }
}

