/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.persistence.PostLoad;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.AttributeDefinitionStore;
import org.apereo.cas.authentication.attribute.CaseCanonicalizationMode;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeFilter;
import org.apereo.cas.services.RegisteredServiceAttributeReleaseActivationCriteria;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceConsentPolicy;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class AbstractRegisteredServiceAttributeReleasePolicy
implements RegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRegisteredServiceAttributeReleasePolicy.class);
    private static final long serialVersionUID = 5325460875620586503L;
    private RegisteredServiceAttributeFilter attributeFilter;
    private RegisteredServicePrincipalAttributesRepository principalAttributesRepository = new DefaultPrincipalAttributesRepository();
    private RegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy();
    private boolean authorizedToReleaseCredentialPassword;
    private boolean authorizedToReleaseProxyGrantingTicket;
    private boolean excludeDefaultAttributes;
    private boolean authorizedToReleaseAuthenticationAttributes = true;
    private String principalIdAttribute;
    private int order;
    private String canonicalizationMode = "NONE";
    private RegisteredServiceAttributeReleaseActivationCriteria activationCriteria;

    @PostLoad
    public void postLoad() {
        if (this.principalAttributesRepository == null) {
            this.principalAttributesRepository = new DefaultPrincipalAttributesRepository();
        }
        if (this.consentPolicy == null) {
            this.consentPolicy = new DefaultRegisteredServiceConsentPolicy();
        }
        this.canonicalizationMode = (String)StringUtils.defaultIfBlank((CharSequence)this.canonicalizationMode, (CharSequence)"NONE");
    }

    public Map<String, List<Object>> getAttributes(RegisteredServiceAttributeReleasePolicyContext context) throws Throwable {
        TreeMap<String, List<Object>> attributesToRelease = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        if (this.supports(context)) {
            LOGGER.debug("Initiating attributes release phase via [{}] for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{this.getClass().getSimpleName(), context.getPrincipal().getId(), context.getService(), context.getRegisteredService().getServiceId()});
            Map<String, List<Object>> principalAttributes = this.resolveAttributesFromPrincipalAttributeRepository(context);
            LOGGER.debug("Found principal attributes [{}] for [{}]", principalAttributes, (Object)context.getPrincipal().getId());
            Map<String, List<Object>> availableAttributes = this.resolveAttributesFromAttributeDefinitionStore(context, principalAttributes);
            LOGGER.trace("Resolved principal attributes [{}] for [{}] from attribute definition store", availableAttributes, (Object)context.getPrincipal().getId());
            RegisteredServicePrincipalAttributesRepository repository = this.getRegisteredServicePrincipalAttributesRepository(context);
            LOGGER.trace("Updating principal attributes repository cache for [{}] with [{}]", (Object)context.getPrincipal().getId(), availableAttributes);
            repository.update(context.getPrincipal().getId(), availableAttributes, context);
            LOGGER.trace("Calling attribute policy [{}] to process attributes for [{}]", (Object)this.getClass().getSimpleName(), (Object)context.getPrincipal().getId());
            Map<String, List<Object>> policyAttributes = this.getAttributesInternal(context, availableAttributes);
            LOGGER.debug("Attribute policy [{}] allows release of [{}] for [{}]", new Object[]{this.getClass().getSimpleName(), policyAttributes, context.getPrincipal().getId()});
            LOGGER.trace("Attempting to merge policy attributes and default attributes");
            if (this.isExcludeDefaultAttributes()) {
                LOGGER.debug("Ignoring default attribute policy attributes");
            } else {
                LOGGER.trace("Checking default attribute policy attributes");
                Map<String, List<Object>> defaultAttributes = this.getReleasedByDefaultAttributes(context, availableAttributes);
                LOGGER.debug("Default attributes found to be released are [{}]", defaultAttributes);
                if (!defaultAttributes.isEmpty()) {
                    LOGGER.debug("Adding default attributes first to the released set of attributes");
                    attributesToRelease.putAll(defaultAttributes);
                }
            }
            LOGGER.trace("Adding policy attributes to the released set of attributes");
            attributesToRelease.putAll(policyAttributes);
            this.insertPrincipalIdAsAttributeIfNeeded(context, attributesToRelease);
            if (this.getAttributeFilter() != null) {
                LOGGER.debug("Invoking attribute filter [{}] on the final set of attributes", (Object)this.getAttributeFilter());
                return this.getAttributeFilter().filter(attributesToRelease);
            }
            LOGGER.debug("Finalizing attributes release phase for principal [{}] accessing service [{}] defined by registered service [{}]...", new Object[]{context.getPrincipal().getId(), context.getService(), context.getRegisteredService().getServiceId()});
            return this.returnFinalAttributesCollection(attributesToRelease, context.getRegisteredService());
        }
        return attributesToRelease;
    }

    public Map<String, List<Object>> getConsentableAttributes(RegisteredServiceAttributeReleasePolicyContext context) throws Throwable {
        Map<String, List<Object>> attributes = this.getAttributes(context);
        LOGGER.debug("Initial set of consentable attributes are [{}]", attributes);
        Map results = Optional.ofNullable(this.consentPolicy).filter(policy -> Objects.nonNull(policy.getStatus())).map(policy -> {
            if (policy.getStatus().isFalse()) {
                LOGGER.debug("Consent policy is turned off and disabled for service [{}].", (Object)context.getService());
                return new HashMap();
            }
            if (policy.getStatus().isTrue()) {
                if (policy.getExcludedServices() != null && policy.getExcludedServices().stream().anyMatch(ex -> RegexUtils.find((String)ex, (String)context.getService().getId()))) {
                    LOGGER.debug("Consent policy will exclude service [{}].", (Object)context.getService());
                    return new HashMap();
                }
                LOGGER.debug("Activating consent policy [{}] for service [{}]", policy, (Object)context.getService());
                Set excludedAttributes = policy.getExcludedAttributes();
                if (excludedAttributes != null && !excludedAttributes.isEmpty()) {
                    excludedAttributes.forEach(attributes::remove);
                    LOGGER.debug("Consentable attributes after removing excluded attributes are [{}]", (Object)attributes);
                } else {
                    LOGGER.debug("No attributes are defined per the consent policy to be excluded from the consentable attributes");
                }
                Set includeOnlyAttributes = policy.getIncludeOnlyAttributes();
                if (includeOnlyAttributes != null && !includeOnlyAttributes.isEmpty()) {
                    attributes.keySet().retainAll(includeOnlyAttributes);
                    LOGGER.debug("Consentable attributes after force-including attributes are [{}]", (Object)attributes);
                } else {
                    LOGGER.debug("No attributes are defined per the consent policy to forcefully be included in the consentable attributes");
                }
            }
            return attributes;
        }).orElseGet(() -> {
            LOGGER.debug("No consent policy is defined for service [{}]. Using the collection of attributes released for consent", (Object)context.getService());
            return attributes;
        });
        LOGGER.debug("Finalized set of consentable attributes are [{}]", (Object)results);
        return results;
    }

    protected abstract Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext var1, Map<String, List<Object>> var2) throws Throwable;

    protected boolean supports(RegisteredServiceAttributeReleasePolicyContext context) {
        RegisteredServiceAttributeReleaseActivationCriteria criteria = this.getActivationCriteria();
        return criteria == null || criteria.shouldActivate(context);
    }

    protected Map<String, List<Object>> resolveAttributesFromAttributeDefinitionStore(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> principalAttributes) {
        if (context.getApplicationContext().containsBean("attributeDefinitionStore")) {
            LOGGER.trace("Retrieving attribute definition store and attribute definitions...");
            AttributeDefinitionStore definitionStore = (AttributeDefinitionStore)context.getApplicationContext().getBean("attributeDefinitionStore", AttributeDefinitionStore.class);
            LinkedHashMap<String, List<Object>> availableAttributes = new LinkedHashMap<String, List<Object>>(principalAttributes);
            availableAttributes.putAll(context.getReleasingAttributes());
            if (definitionStore.isEmpty()) {
                LOGGER.trace("No attribute definitions are defined in the attribute definition store, or no attribute definitions are requested.");
                return availableAttributes;
            }
            LinkedHashSet<String> requestedDefinitions = new LinkedHashSet<String>(this.determineRequestedAttributeDefinitions(context));
            requestedDefinitions.addAll(principalAttributes.keySet());
            LOGGER.debug("Finding requested attribute definitions [{}] based on available attributes [{}]", requestedDefinitions, availableAttributes);
            return definitionStore.resolveAttributeValues(requestedDefinitions, availableAttributes, context.getPrincipal(), context.getRegisteredService(), context.getService());
        }
        LOGGER.trace("No attribute definition store is available in application context");
        return principalAttributes;
    }

    protected Map<String, List<Object>> resolveAttributesFromPrincipalAttributeRepository(RegisteredServiceAttributeReleasePolicyContext context) {
        RegisteredServicePrincipalAttributesRepository repository = this.getRegisteredServicePrincipalAttributesRepository(context);
        LOGGER.debug("Using principal attribute repository [{}] to retrieve attributes", (Object)repository);
        Map attributes = repository.getAttributes(context);
        LOGGER.debug("Attributes retrieved from principal attribute repository for [{}] are [{}]", (Object)context.getPrincipal().getId(), (Object)attributes);
        return attributes;
    }

    protected void insertPrincipalIdAsAttributeIfNeeded(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributesToRelease) throws Throwable {
        if (StringUtils.isNotBlank((CharSequence)this.getPrincipalIdAttribute()) && !attributesToRelease.containsKey(this.getPrincipalIdAttribute())) {
            LOGGER.debug("Attempting to resolve the principal id for service [{}]", (Object)context.getRegisteredService().getServiceId());
            RegisteredServiceUsernameAttributeProvider usernameProvider = context.getRegisteredService().getUsernameAttributeProvider();
            if (usernameProvider != null) {
                RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().service(context.getService()).principal(context.getPrincipal()).registeredService(context.getRegisteredService()).releasingAttributes(attributesToRelease).applicationContext(context.getApplicationContext()).build();
                String id = usernameProvider.resolveUsername(usernameContext);
                LOGGER.debug("Releasing resolved principal id [{}] as attribute [{}]", (Object)id, (Object)this.getPrincipalIdAttribute());
                attributesToRelease.put(this.getPrincipalIdAttribute(), CollectionUtils.wrapList((Object[])new Object[]{id}));
            }
        }
    }

    protected Map<String, List<Object>> returnFinalAttributesCollection(Map<String, List<Object>> attributesToRelease, RegisteredService service) {
        CaseCanonicalizationMode transform;
        LOGGER.debug("Final collection of attributes allowed are: [{}]", attributesToRelease);
        CaseCanonicalizationMode caseCanonicalizationMode = transform = StringUtils.isBlank((CharSequence)this.canonicalizationMode) ? CaseCanonicalizationMode.NONE : CaseCanonicalizationMode.valueOf((String)this.canonicalizationMode);
        if (transform != CaseCanonicalizationMode.NONE) {
            HashMap<String, List<Object>> transformedAttributes = new HashMap<String, List<Object>>(attributesToRelease);
            transformedAttributes.forEach((key, value) -> {
                List<String> values = value.stream().map(Object::toString).map(arg_0 -> ((CaseCanonicalizationMode)transform).canonicalize(arg_0)).toList();
                transformedAttributes.put((String)key, (List<Object>)values);
            });
            return transformedAttributes;
        }
        return attributesToRelease;
    }

    protected Map<String, List<Object>> getReleasedByDefaultAttributes(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        CasConfigurationProperties properties = (CasConfigurationProperties)context.getApplicationContext().getBean(CasConfigurationProperties.class);
        Set defaultAttrs = properties.getAuthn().getAttributeRepository().getCore().getDefaultAttributesToRelease();
        LOGGER.debug("Default attributes for release are: [{}]", (Object)defaultAttrs);
        TreeMap<String, List<Object>> defaultAttributesToRelease = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        defaultAttrs.forEach(key -> {
            if (attributes.containsKey(key)) {
                LOGGER.debug("Found and added default attribute for release: [{}]", key);
                defaultAttributesToRelease.put((String)key, (List)attributes.get(key));
            }
        });
        return defaultAttributesToRelease;
    }

    protected List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        return new ArrayList<String>();
    }

    private RegisteredServicePrincipalAttributesRepository getRegisteredServicePrincipalAttributesRepository(RegisteredServiceAttributeReleasePolicyContext context) {
        return Optional.ofNullable(this.principalAttributesRepository).orElseGet(() -> (RegisteredServicePrincipalAttributesRepository)context.getApplicationContext().getBean("globalPrincipalAttributeRepository", RegisteredServicePrincipalAttributesRepository.class));
    }

    @Generated
    public String toString() {
        return "AbstractRegisteredServiceAttributeReleasePolicy(attributeFilter=" + String.valueOf(this.attributeFilter) + ", principalAttributesRepository=" + String.valueOf(this.principalAttributesRepository) + ", consentPolicy=" + String.valueOf(this.consentPolicy) + ", authorizedToReleaseCredentialPassword=" + this.authorizedToReleaseCredentialPassword + ", authorizedToReleaseProxyGrantingTicket=" + this.authorizedToReleaseProxyGrantingTicket + ", excludeDefaultAttributes=" + this.excludeDefaultAttributes + ", authorizedToReleaseAuthenticationAttributes=" + this.authorizedToReleaseAuthenticationAttributes + ", principalIdAttribute=" + this.principalIdAttribute + ", order=" + this.order + ", canonicalizationMode=" + this.canonicalizationMode + ", activationCriteria=" + String.valueOf(this.activationCriteria) + ")";
    }

    @Generated
    public RegisteredServiceAttributeFilter getAttributeFilter() {
        return this.attributeFilter;
    }

    @Generated
    public RegisteredServicePrincipalAttributesRepository getPrincipalAttributesRepository() {
        return this.principalAttributesRepository;
    }

    @Generated
    public RegisteredServiceConsentPolicy getConsentPolicy() {
        return this.consentPolicy;
    }

    @Generated
    public boolean isAuthorizedToReleaseCredentialPassword() {
        return this.authorizedToReleaseCredentialPassword;
    }

    @Generated
    public boolean isAuthorizedToReleaseProxyGrantingTicket() {
        return this.authorizedToReleaseProxyGrantingTicket;
    }

    @Generated
    public boolean isExcludeDefaultAttributes() {
        return this.excludeDefaultAttributes;
    }

    @Generated
    public boolean isAuthorizedToReleaseAuthenticationAttributes() {
        return this.authorizedToReleaseAuthenticationAttributes;
    }

    @Generated
    public String getPrincipalIdAttribute() {
        return this.principalIdAttribute;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getCanonicalizationMode() {
        return this.canonicalizationMode;
    }

    @Generated
    public RegisteredServiceAttributeReleaseActivationCriteria getActivationCriteria() {
        return this.activationCriteria;
    }

    @Generated
    public void setAttributeFilter(RegisteredServiceAttributeFilter attributeFilter) {
        this.attributeFilter = attributeFilter;
    }

    @Generated
    public void setPrincipalAttributesRepository(RegisteredServicePrincipalAttributesRepository principalAttributesRepository) {
        this.principalAttributesRepository = principalAttributesRepository;
    }

    @Generated
    public void setConsentPolicy(RegisteredServiceConsentPolicy consentPolicy) {
        this.consentPolicy = consentPolicy;
    }

    @Generated
    public void setAuthorizedToReleaseCredentialPassword(boolean authorizedToReleaseCredentialPassword) {
        this.authorizedToReleaseCredentialPassword = authorizedToReleaseCredentialPassword;
    }

    @Generated
    public void setAuthorizedToReleaseProxyGrantingTicket(boolean authorizedToReleaseProxyGrantingTicket) {
        this.authorizedToReleaseProxyGrantingTicket = authorizedToReleaseProxyGrantingTicket;
    }

    @Generated
    public void setExcludeDefaultAttributes(boolean excludeDefaultAttributes) {
        this.excludeDefaultAttributes = excludeDefaultAttributes;
    }

    @Generated
    public void setAuthorizedToReleaseAuthenticationAttributes(boolean authorizedToReleaseAuthenticationAttributes) {
        this.authorizedToReleaseAuthenticationAttributes = authorizedToReleaseAuthenticationAttributes;
    }

    @Generated
    public void setPrincipalIdAttribute(String principalIdAttribute) {
        this.principalIdAttribute = principalIdAttribute;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setCanonicalizationMode(String canonicalizationMode) {
        this.canonicalizationMode = canonicalizationMode;
    }

    @Generated
    public void setActivationCriteria(RegisteredServiceAttributeReleaseActivationCriteria activationCriteria) {
        this.activationCriteria = activationCriteria;
    }

    @Generated
    protected AbstractRegisteredServiceAttributeReleasePolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractRegisteredServiceAttributeReleasePolicy)) {
            return false;
        }
        AbstractRegisteredServiceAttributeReleasePolicy other = (AbstractRegisteredServiceAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.authorizedToReleaseCredentialPassword != other.authorizedToReleaseCredentialPassword) {
            return false;
        }
        if (this.authorizedToReleaseProxyGrantingTicket != other.authorizedToReleaseProxyGrantingTicket) {
            return false;
        }
        if (this.excludeDefaultAttributes != other.excludeDefaultAttributes) {
            return false;
        }
        if (this.authorizedToReleaseAuthenticationAttributes != other.authorizedToReleaseAuthenticationAttributes) {
            return false;
        }
        if (this.order != other.order) {
            return false;
        }
        RegisteredServiceAttributeFilter this$attributeFilter = this.attributeFilter;
        RegisteredServiceAttributeFilter other$attributeFilter = other.attributeFilter;
        if (this$attributeFilter == null ? other$attributeFilter != null : !this$attributeFilter.equals(other$attributeFilter)) {
            return false;
        }
        RegisteredServicePrincipalAttributesRepository this$principalAttributesRepository = this.principalAttributesRepository;
        RegisteredServicePrincipalAttributesRepository other$principalAttributesRepository = other.principalAttributesRepository;
        if (this$principalAttributesRepository == null ? other$principalAttributesRepository != null : !this$principalAttributesRepository.equals(other$principalAttributesRepository)) {
            return false;
        }
        RegisteredServiceConsentPolicy this$consentPolicy = this.consentPolicy;
        RegisteredServiceConsentPolicy other$consentPolicy = other.consentPolicy;
        if (this$consentPolicy == null ? other$consentPolicy != null : !this$consentPolicy.equals(other$consentPolicy)) {
            return false;
        }
        String this$principalIdAttribute = this.principalIdAttribute;
        String other$principalIdAttribute = other.principalIdAttribute;
        if (this$principalIdAttribute == null ? other$principalIdAttribute != null : !this$principalIdAttribute.equals(other$principalIdAttribute)) {
            return false;
        }
        String this$canonicalizationMode = this.canonicalizationMode;
        String other$canonicalizationMode = other.canonicalizationMode;
        if (this$canonicalizationMode == null ? other$canonicalizationMode != null : !this$canonicalizationMode.equals(other$canonicalizationMode)) {
            return false;
        }
        RegisteredServiceAttributeReleaseActivationCriteria this$activationCriteria = this.activationCriteria;
        RegisteredServiceAttributeReleaseActivationCriteria other$activationCriteria = other.activationCriteria;
        return !(this$activationCriteria == null ? other$activationCriteria != null : !this$activationCriteria.equals(other$activationCriteria));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractRegisteredServiceAttributeReleasePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authorizedToReleaseCredentialPassword ? 79 : 97);
        result = result * 59 + (this.authorizedToReleaseProxyGrantingTicket ? 79 : 97);
        result = result * 59 + (this.excludeDefaultAttributes ? 79 : 97);
        result = result * 59 + (this.authorizedToReleaseAuthenticationAttributes ? 79 : 97);
        result = result * 59 + this.order;
        RegisteredServiceAttributeFilter $attributeFilter = this.attributeFilter;
        result = result * 59 + ($attributeFilter == null ? 43 : $attributeFilter.hashCode());
        RegisteredServicePrincipalAttributesRepository $principalAttributesRepository = this.principalAttributesRepository;
        result = result * 59 + ($principalAttributesRepository == null ? 43 : $principalAttributesRepository.hashCode());
        RegisteredServiceConsentPolicy $consentPolicy = this.consentPolicy;
        result = result * 59 + ($consentPolicy == null ? 43 : $consentPolicy.hashCode());
        String $principalIdAttribute = this.principalIdAttribute;
        result = result * 59 + ($principalIdAttribute == null ? 43 : $principalIdAttribute.hashCode());
        String $canonicalizationMode = this.canonicalizationMode;
        result = result * 59 + ($canonicalizationMode == null ? 43 : $canonicalizationMode.hashCode());
        RegisteredServiceAttributeReleaseActivationCriteria $activationCriteria = this.activationCriteria;
        result = result * 59 + ($activationCriteria == null ? 43 : $activationCriteria.hashCode());
        return result;
    }
}

