/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger.ui;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SwaggerUiOAuth2Config {
    private String clientId;
    private String clientSecret;
    private String realm;
    private String appName;
    private List<String> scopes;
    private Map<String, String> additionalQueryStringParams;
    private Boolean useBasicAuthenticationWithAccessCodeGrant;
    private Boolean usePkceWithAuthorizationCodeGrant;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SwaggerUiOAuth2Config clientId(String cid) {
        this.setClientId(cid);
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public SwaggerUiOAuth2Config clientSecret(String secret) {
        this.setClientSecret(secret);
        return this;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public SwaggerUiOAuth2Config realm(String re) {
        this.setRealm(re);
        return this;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public SwaggerUiOAuth2Config appName(String name) {
        this.setAppName(name);
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public SwaggerUiOAuth2Config scopes(List<String> scopesList) {
        this.setScopes(scopesList);
        return this;
    }

    public Map<String, String> getAdditionalQueryStringParams() {
        return this.additionalQueryStringParams;
    }

    public void setAdditionalQueryStringParams(Map<String, String> additionalQueryStringParams) {
        this.additionalQueryStringParams = additionalQueryStringParams;
    }

    public SwaggerUiOAuth2Config additionalQueryStringParams(Map<String, String> additionalParams) {
        this.setAdditionalQueryStringParams(additionalParams);
        return this;
    }

    public Boolean getUseBasicAuthenticationWithAccessCodeGrant() {
        return this.useBasicAuthenticationWithAccessCodeGrant;
    }

    public void setUseBasicAuthenticationWithAccessCodeGrant(Boolean useBasicAuthenticationWithAccessCodeGrant) {
        this.useBasicAuthenticationWithAccessCodeGrant = useBasicAuthenticationWithAccessCodeGrant;
    }

    public SwaggerUiOAuth2Config useBasicAuthenticationWithAccessCodeGrant(Boolean basicAuth) {
        this.setUseBasicAuthenticationWithAccessCodeGrant(basicAuth);
        return this;
    }

    public Boolean getUsePkceWithAuthorizationCodeGrant() {
        return this.usePkceWithAuthorizationCodeGrant;
    }

    public void setUsePkceWithAuthorizationCodeGrant(Boolean usePkceWithAuthorizationCodeGrant) {
        this.usePkceWithAuthorizationCodeGrant = usePkceWithAuthorizationCodeGrant;
    }

    public SwaggerUiOAuth2Config usePkceWithAuthorizationCodeGrant(Boolean pkce) {
        this.setUsePkceWithAuthorizationCodeGrant(pkce);
        return this;
    }

    public String toJsonString() {
        StringBuilder json = new StringBuilder("{");
        this.addStringField(json, "clientId", this.clientId);
        this.addStringField(json, "clientSecret", this.clientSecret);
        this.addStringField(json, "realm", this.realm);
        this.addStringField(json, "appName", this.appName);
        this.addListField(json, "scopes", this.scopes);
        this.addMapField(json, "additionalQueryStringParams", this.additionalQueryStringParams);
        this.addBooleanField(json, "useBasicAuthenticationWithAccessCodeGrant", this.useBasicAuthenticationWithAccessCodeGrant);
        this.addBooleanField(json, "usePkceWithAuthorizationCodeGrant", this.usePkceWithAuthorizationCodeGrant);
        if (json.toString().endsWith(",")) {
            json.delete(json.length() - 1, json.length());
        }
        return json.append('}').toString();
    }

    private void addStringField(StringBuilder json, String name, String value) {
        if (value != null) {
            json.append(this.quote(name)).append(':').append(this.quote(value)).append(',');
        }
    }

    private void addBooleanField(StringBuilder json, String name, Boolean value) {
        if (value != null) {
            json.append(this.quote(name)).append(':').append(value).append(',');
        }
    }

    private void addListField(StringBuilder json, String name, List<String> value) {
        if (value != null) {
            json.append(this.quote(name)).append(':').append(value.stream().map(this::quote).sorted().collect(Collectors.joining(",", "[", "]"))).append(',');
        }
    }

    private void addMapField(StringBuilder json, String name, Map<String, String> value) {
        if (value != null) {
            json.append(this.quote(name)).append(':').append(value.entrySet().stream().map(this::entryToString).sorted().collect(Collectors.joining(",", "{", "}"))).append(',');
        }
    }

    private String quote(String s) {
        return "\"" + s + "\"";
    }

    private String entryToString(Map.Entry<String, String> entry) {
        return this.quote(entry.getKey()) + ":" + this.quote(entry.getValue());
    }
}

