/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.lib;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.json.JsonMapper;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.syncope.client.lib.AnonymousAuthenticationHandler;
import org.apache.syncope.client.lib.AuthenticationHandler;
import org.apache.syncope.client.lib.BasicAuthenticationHandler;
import org.apache.syncope.client.lib.JWTAuthenticationHandler;
import org.apache.syncope.client.lib.RestClientExceptionMapper;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.ConnObjectTOFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.OrderByClauseBuilder;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.service.AccessTokenService;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.syncope.common.rest.api.service.ExecutableService;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeClient {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeClient.class);
    protected static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final JAXRSClientFactoryBean restClientFactory;
    protected final RestClientExceptionMapper exceptionMapper;
    protected final boolean useCompression;
    protected final HTTPClientPolicy httpClientPolicy;
    protected final TLSClientParameters tlsClientParameters;

    public static UserFiqlSearchConditionBuilder getUserSearchConditionBuilder() {
        return new UserFiqlSearchConditionBuilder();
    }

    public static GroupFiqlSearchConditionBuilder getGroupSearchConditionBuilder() {
        return new GroupFiqlSearchConditionBuilder();
    }

    public static AnyObjectFiqlSearchConditionBuilder getAnyObjectSearchConditionBuilder(String type) {
        return new AnyObjectFiqlSearchConditionBuilder(type);
    }

    public static ConnObjectTOFiqlSearchConditionBuilder getConnObjectTOFiqlSearchConditionBuilder() {
        return new ConnObjectTOFiqlSearchConditionBuilder();
    }

    public static OrderByClauseBuilder getOrderByClauseBuilder() {
        return new OrderByClauseBuilder();
    }

    public static <T> T header(T service, String key, Object ... values) {
        WebClient.client(service).header(key, values);
        return service;
    }

    public static <T> T prefer(T service, Preference preference) {
        return SyncopeClient.header(service, "Prefer", preference.toString());
    }

    public static <T> T nullPriorityAsync(T service, boolean nullPriorityAsync) {
        return SyncopeClient.header(service, "X-Syncope-Null-Priority-Async", nullPriorityAsync);
    }

    protected static <T> T match(T service, EntityTag etag, boolean ifNot) {
        WebClient.client(service).match(etag, ifNot);
        return service;
    }

    public static <T> T ifMatch(T service, EntityTag etag) {
        return SyncopeClient.match(service, etag, false);
    }

    public static <T> T ifNoneMatch(T service, EntityTag etag) {
        return SyncopeClient.match(service, etag, true);
    }

    public static <T> EntityTag getLatestEntityTag(T service) {
        return WebClient.client(service).getResponse().getEntityTag();
    }

    public SyncopeClient(JAXRSClientFactoryBean restClientFactory, RestClientExceptionMapper exceptionMapper, AuthenticationHandler authHandler, boolean useCompression, HTTPClientPolicy httpClientPolicy, TLSClientParameters tlsClientParameters) {
        this.restClientFactory = restClientFactory;
        if (this.restClientFactory.getHeaders() == null) {
            this.restClientFactory.setHeaders(new HashMap());
        }
        this.exceptionMapper = exceptionMapper;
        this.useCompression = useCompression;
        this.httpClientPolicy = httpClientPolicy;
        this.tlsClientParameters = tlsClientParameters;
        this.init(authHandler);
    }

    protected void init(AuthenticationHandler authHandler) {
        this.cleanup();
        if (authHandler instanceof AnonymousAuthenticationHandler) {
            AnonymousAuthenticationHandler anonymous = (AnonymousAuthenticationHandler)authHandler;
            this.restClientFactory.setUsername(anonymous.getUsername());
            this.restClientFactory.setPassword(anonymous.getPassword());
        } else if (authHandler instanceof BasicAuthenticationHandler) {
            BasicAuthenticationHandler basic = (BasicAuthenticationHandler)authHandler;
            this.restClientFactory.setUsername(basic.getUsername());
            this.restClientFactory.setPassword(basic.getPassword());
            Response response = this.getService(AccessTokenService.class).login();
            String jwt = response.getHeaderString("X-Syncope-Token");
            String jwtExpiration = response.getHeaderString("X-Syncope-Token-Expire");
            this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwt));
            this.restClientFactory.getHeaders().put("Expires", List.of(jwtExpiration));
            this.restClientFactory.setUsername(null);
            this.restClientFactory.setPassword(null);
        } else if (authHandler instanceof JWTAuthenticationHandler) {
            JWTAuthenticationHandler jwt = (JWTAuthenticationHandler)authHandler;
            this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwt.getJwt()));
        }
    }

    protected void cleanup() {
        this.restClientFactory.getHeaders().remove("Authorization");
        this.restClientFactory.getHeaders().remove("Expires");
        this.restClientFactory.getHeaders().remove("X-Syncope-Delegated-By");
        this.restClientFactory.setUsername(null);
        this.restClientFactory.setPassword(null);
    }

    public String getAddress() {
        return this.restClientFactory.getAddress();
    }

    public SyncopeClient delegatedBy(String delegating) {
        if (delegating == null) {
            this.restClientFactory.getHeaders().remove("X-Syncope-Delegated-By");
        } else {
            this.restClientFactory.getHeaders().put("X-Syncope-Delegated-By", List.of(delegating));
        }
        return this;
    }

    public void refresh() {
        Response response = this.getService(AccessTokenService.class).refresh();
        String jwt = response.getHeaderString("X-Syncope-Token");
        String jwtExpiration = response.getHeaderString("X-Syncope-Token-Expire");
        this.restClientFactory.getHeaders().put("Authorization", List.of("Bearer " + jwt));
        this.restClientFactory.getHeaders().put("Expires", List.of(jwtExpiration));
    }

    public void logout() {
        try {
            this.getService(AccessTokenService.class).logout();
        }
        catch (Exception e) {
            LOG.error("While logging out, cleaning up anyway", (Throwable)e);
        }
        this.cleanup();
    }

    public void login(AuthenticationHandler handler) {
        this.init(handler);
    }

    public Optional<JwtInfo> jwtInfo() {
        String value = Optional.ofNullable((List)this.restClientFactory.getHeaders().get("Authorization")).filter(Predicate.not(List::isEmpty)).map(List::getFirst).filter(header -> header.startsWith("Bearer ")).map(header -> header.substring("Bearer ".length())).orElse(null);
        if (value == null) {
            return Optional.empty();
        }
        OffsetDateTime expiration = Optional.ofNullable((List)this.restClientFactory.getHeaders().get("Expires")).filter(Predicate.not(List::isEmpty)).map(List::getFirst).map(v -> OffsetDateTime.parse(v, DateTimeFormatter.ISO_OFFSET_DATE_TIME)).orElse(null);
        return Optional.of(new JwtInfo(value, expiration));
    }

    public String getDomain() {
        List headerValues = (List)this.restClientFactory.getHeaders().get("X-Syncope-Domain");
        return headerValues == null || headerValues.isEmpty() ? "Master" : (String)headerValues.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getService(Class<T> serviceClass) {
        Conduit conduit;
        Object serviceInstance;
        JAXRSClientFactoryBean jAXRSClientFactoryBean = this.restClientFactory;
        synchronized (jAXRSClientFactoryBean) {
            this.restClientFactory.setServiceClass(serviceClass);
            serviceInstance = this.restClientFactory.create(serviceClass, new Object[0]);
        }
        Client client = WebClient.client((Object)serviceInstance);
        client.type("application/json").accept(new String[]{"application/json"});
        if (serviceInstance instanceof AnyService || serviceInstance instanceof ExecutableService) {
            client.accept(new String[]{"multipart/mixed"});
        }
        ClientConfiguration config = WebClient.getConfig((Object)client);
        config.getRequestContext().put(HEADER_SPLIT_PROPERTY, true);
        if (this.useCompression) {
            config.getInInterceptors().add(new GZIPInInterceptor());
            config.getOutInterceptors().add(new GZIPOutInterceptor());
        }
        if ((conduit = config.getConduit()) instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            Optional.ofNullable(this.httpClientPolicy).ifPresent(arg_0 -> ((HTTPConduit)httpConduit).setClient(arg_0));
            Optional.ofNullable(this.tlsClientParameters).ifPresent(arg_0 -> ((HTTPConduit)httpConduit).setTlsClientParameters(arg_0));
        }
        return (T)serviceInstance;
    }

    public Self self() {
        Exception ex;
        UserSelfService service = this.getService(UserSelfService.class);
        WebClient.getConfig((Object)WebClient.client((Object)service)).getRequestContext().put(HEADER_SPLIT_PROPERTY, false);
        Response response = service.read();
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode() && (ex = this.exceptionMapper.fromResponse(response)) != null) {
            throw (RuntimeException)ex;
        }
        try {
            return new Self((UserTO)response.readEntity(UserTO.class), (Map)MAPPER.readValue(response.getHeaderString("X-Syncope-Entitlements"), (TypeReference)new TypeReference<Map<String, Set<String>>>(this){}), (List)MAPPER.readValue(response.getHeaderString("X-Syncope-Delegations"), (TypeReference)new TypeReference<List<String>>(this){}));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public BatchRequest batch() {
        return new BatchRequest(this.restClientFactory.getAddress(), this.restClientFactory.getProviders(), this.jwtInfo().map(JwtInfo::value).orElse(null), this.tlsClientParameters);
    }

    public record JwtInfo(String value, OffsetDateTime expiration) implements Serializable
    {
    }

    public record Self(UserTO user, Map<String, Set<String>> entitlements, List<String> delegations) implements Serializable
    {
    }
}

