/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;

public class SyncopeClientCompositeException
extends SyncopeClientException {
    private static final long serialVersionUID = 7882118041134372129L;
    private final Set<SyncopeClientException> exceptions = new HashSet<SyncopeClientException>();

    protected SyncopeClientCompositeException() {
        super(ClientExceptionType.Composite);
    }

    public boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    public Optional<SyncopeClientException> getException(ClientExceptionType exceptionType) {
        return this.exceptions.stream().filter(e -> e.getType() == exceptionType).findFirst();
    }

    public Set<SyncopeClientException> getExceptions() {
        return this.exceptions;
    }

    public boolean addException(SyncopeClientException exception) {
        if (exception.getType() == null) {
            exception.setType(ClientExceptionType.Unknown);
        }
        return this.exceptions.stream().filter(e -> e.getType() == exception.getType()).findFirst().map(e -> e.getElements().addAll(exception.getElements())).orElseGet(() -> this.exceptions.add(exception));
    }

    @Override
    public String getMessage() {
        return '{' + this.getExceptions().stream().map(e -> "[" + e.getMessage() + "]").collect(Collectors.joining(", ")) + '}';
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }
}

