/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.transaction;

import java.util.Stack;
import org.flowable.common.engine.impl.cfg.TransactionContext;

public class TransactionContextHolder {
    protected static ThreadLocal<Stack<TransactionContext>> transactionContextThreadLocal = new ThreadLocal();

    public static TransactionContext getTransactionContext() {
        Stack stack = TransactionContextHolder.getStack(transactionContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (TransactionContext)stack.peek();
    }

    public static void setTransactionContext(TransactionContext transactionContext) {
        TransactionContextHolder.getStack(transactionContextThreadLocal).push(transactionContext);
    }

    public static void removeTransactionContext() {
        TransactionContextHolder.getStack(transactionContextThreadLocal).pop();
    }

    public static boolean isTransactionContextActive() {
        return !TransactionContextHolder.getStack(transactionContextThreadLocal).isEmpty();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

